# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Notification(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'message': 'str',
        'expiration': 'int',
        'type': 'str',
        'priority': 'str',
        'db_create_date': 'int',
        'db_update_date': 'int'
    }

    attribute_map = {
        'id': 'id',
        'message': 'message',
        'expiration': 'expiration',
        'type': 'type',
        'priority': 'priority',
        'db_create_date': 'dbCreateDate',
        'db_update_date': 'dbUpdateDate'
    }

    def __init__(self, id=None, message=None, expiration=None, type=None, priority=None, db_create_date=None, db_update_date=None, _configuration=None):  # noqa: E501
        """Notification - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._id = None
        self._message = None
        self._expiration = None
        self._type = None
        self._priority = None
        self._db_create_date = None
        self._db_update_date = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if message is not None:
            self.message = message
        if expiration is not None:
            self.expiration = expiration
        if type is not None:
            self.type = type
        if priority is not None:
            self.priority = priority
        if db_create_date is not None:
            self.db_create_date = db_create_date
        if db_update_date is not None:
            self.db_update_date = db_update_date

    @property
    def id(self):
        """Gets the id of this Notification.  # noqa: E501

        ID for the notification  # noqa: E501

        :return: The id of this Notification.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Notification.

        ID for the notification  # noqa: E501

        :param id: The id of this Notification.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def message(self):
        """Gets the message of this Notification.  # noqa: E501

        Text content of the notification to be displayed  # noqa: E501

        :return: The message of this Notification.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this Notification.

        Text content of the notification to be displayed  # noqa: E501

        :param message: The message of this Notification.  # noqa: E501
        :type: str
        """
        if (self._configuration.client_side_validation and
                message is not None and len(message) > 1024):
            raise ValueError("Invalid value for `message`, length must be less than or equal to `1024`")  # noqa: E501
        if (self._configuration.client_side_validation and
                message is not None and len(message) < 0):
            raise ValueError("Invalid value for `message`, length must be greater than or equal to `0`")  # noqa: E501

        self._message = message

    @property
    def expiration(self):
        """Gets the expiration of this Notification.  # noqa: E501

        Timestamp at which the notification is expired  # noqa: E501

        :return: The expiration of this Notification.  # noqa: E501
        :rtype: int
        """
        return self._expiration

    @expiration.setter
    def expiration(self, expiration):
        """Sets the expiration of this Notification.

        Timestamp at which the notification is expired  # noqa: E501

        :param expiration: The expiration of this Notification.  # noqa: E501
        :type: int
        """

        self._expiration = expiration

    @property
    def type(self):
        """Gets the type of this Notification.  # noqa: E501

        Type of notification, sitewide or newsbody  # noqa: E501

        :return: The type of this Notification.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Notification.

        Type of notification, sitewide or newsbody  # noqa: E501

        :param type: The type of this Notification.  # noqa: E501
        :type: str
        """
        allowed_values = ["SITEWIDE", "NEWSBODY"]  # noqa: E501
        if (self._configuration.client_side_validation and
                type not in allowed_values):
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def priority(self):
        """Gets the priority of this Notification.  # noqa: E501

        Priority level of the notification  # noqa: E501

        :return: The priority of this Notification.  # noqa: E501
        :rtype: str
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """Sets the priority of this Notification.

        Priority level of the notification  # noqa: E501

        :param priority: The priority of this Notification.  # noqa: E501
        :type: str
        """
        allowed_values = ["LOW", "MEDIUM", "CRITICAL"]  # noqa: E501
        if (self._configuration.client_side_validation and
                priority not in allowed_values):
            raise ValueError(
                "Invalid value for `priority` ({0}), must be one of {1}"  # noqa: E501
                .format(priority, allowed_values)
            )

        self._priority = priority

    @property
    def db_create_date(self):
        """Gets the db_create_date of this Notification.  # noqa: E501

        Timestamp at which the notification was created  # noqa: E501

        :return: The db_create_date of this Notification.  # noqa: E501
        :rtype: int
        """
        return self._db_create_date

    @db_create_date.setter
    def db_create_date(self, db_create_date):
        """Sets the db_create_date of this Notification.

        Timestamp at which the notification was created  # noqa: E501

        :param db_create_date: The db_create_date of this Notification.  # noqa: E501
        :type: int
        """

        self._db_create_date = db_create_date

    @property
    def db_update_date(self):
        """Gets the db_update_date of this Notification.  # noqa: E501

        Timestamp at which the notification was last updated  # noqa: E501

        :return: The db_update_date of this Notification.  # noqa: E501
        :rtype: int
        """
        return self._db_update_date

    @db_update_date.setter
    def db_update_date(self, db_update_date):
        """Sets the db_update_date of this Notification.

        Timestamp at which the notification was last updated  # noqa: E501

        :param db_update_date: The db_update_date of this Notification.  # noqa: E501
        :type: int
        """

        self._db_update_date = db_update_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Notification, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Notification):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Notification):
            return True

        return self.to_dict() != other.to_dict()
