# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Organization(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'aliases': 'dict(str, Alias)',
        'collections_length': 'int',
        'db_create_date': 'int',
        'db_update_date': 'int',
        'id': 'int',
        'name': 'str',
        'description': 'str',
        'link': 'str',
        'location': 'str',
        'email': 'str',
        'status': 'str',
        'users': 'list[OrganizationUser]',
        'topic': 'str',
        'avatar_url': 'str',
        'display_name': 'str',
        'starred_users': 'list[User]'
    }

    attribute_map = {
        'aliases': 'aliases',
        'collections_length': 'collectionsLength',
        'db_create_date': 'dbCreateDate',
        'db_update_date': 'dbUpdateDate',
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'link': 'link',
        'location': 'location',
        'email': 'email',
        'status': 'status',
        'users': 'users',
        'topic': 'topic',
        'avatar_url': 'avatarUrl',
        'display_name': 'displayName',
        'starred_users': 'starredUsers'
    }

    def __init__(self, aliases=None, collections_length=None, db_create_date=None, db_update_date=None, id=None, name=None, description=None, link=None, location=None, email=None, status=None, users=None, topic=None, avatar_url=None, display_name=None, starred_users=None, _configuration=None):  # noqa: E501
        """Organization - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._aliases = None
        self._collections_length = None
        self._db_create_date = None
        self._db_update_date = None
        self._id = None
        self._name = None
        self._description = None
        self._link = None
        self._location = None
        self._email = None
        self._status = None
        self._users = None
        self._topic = None
        self._avatar_url = None
        self._display_name = None
        self._starred_users = None
        self.discriminator = None

        if aliases is not None:
            self.aliases = aliases
        if collections_length is not None:
            self.collections_length = collections_length
        if db_create_date is not None:
            self.db_create_date = db_create_date
        if db_update_date is not None:
            self.db_update_date = db_update_date
        if id is not None:
            self.id = id
        self.name = name
        if description is not None:
            self.description = description
        if link is not None:
            self.link = link
        if location is not None:
            self.location = location
        if email is not None:
            self.email = email
        self.status = status
        self.users = users
        if topic is not None:
            self.topic = topic
        if avatar_url is not None:
            self.avatar_url = avatar_url
        if display_name is not None:
            self.display_name = display_name
        if starred_users is not None:
            self.starred_users = starred_users

    @property
    def aliases(self):
        """Gets the aliases of this Organization.  # noqa: E501

        aliases can be used as an alternate unique id for organizations  # noqa: E501

        :return: The aliases of this Organization.  # noqa: E501
        :rtype: dict(str, Alias)
        """
        return self._aliases

    @aliases.setter
    def aliases(self, aliases):
        """Sets the aliases of this Organization.

        aliases can be used as an alternate unique id for organizations  # noqa: E501

        :param aliases: The aliases of this Organization.  # noqa: E501
        :type: dict(str, Alias)
        """

        self._aliases = aliases

    @property
    def collections_length(self):
        """Gets the collections_length of this Organization.  # noqa: E501

        collectionsLength  # noqa: E501

        :return: The collections_length of this Organization.  # noqa: E501
        :rtype: int
        """
        return self._collections_length

    @collections_length.setter
    def collections_length(self, collections_length):
        """Sets the collections_length of this Organization.

        collectionsLength  # noqa: E501

        :param collections_length: The collections_length of this Organization.  # noqa: E501
        :type: int
        """

        self._collections_length = collections_length

    @property
    def db_create_date(self):
        """Gets the db_create_date of this Organization.  # noqa: E501


        :return: The db_create_date of this Organization.  # noqa: E501
        :rtype: int
        """
        return self._db_create_date

    @db_create_date.setter
    def db_create_date(self, db_create_date):
        """Sets the db_create_date of this Organization.


        :param db_create_date: The db_create_date of this Organization.  # noqa: E501
        :type: int
        """

        self._db_create_date = db_create_date

    @property
    def db_update_date(self):
        """Gets the db_update_date of this Organization.  # noqa: E501


        :return: The db_update_date of this Organization.  # noqa: E501
        :rtype: int
        """
        return self._db_update_date

    @db_update_date.setter
    def db_update_date(self, db_update_date):
        """Sets the db_update_date of this Organization.


        :param db_update_date: The db_update_date of this Organization.  # noqa: E501
        :type: int
        """

        self._db_update_date = db_update_date

    @property
    def id(self):
        """Gets the id of this Organization.  # noqa: E501

        Implementation specific ID for the organization in this web service  # noqa: E501

        :return: The id of this Organization.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Organization.

        Implementation specific ID for the organization in this web service  # noqa: E501

        :param id: The id of this Organization.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this Organization.  # noqa: E501

        Name of the organization (ex. OICR)  # noqa: E501

        :return: The name of this Organization.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Organization.

        Name of the organization (ex. OICR)  # noqa: E501

        :param name: The name of this Organization.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501
        if (self._configuration.client_side_validation and
                name is not None and len(name) > 39):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `39`")  # noqa: E501
        if (self._configuration.client_side_validation and
                name is not None and len(name) < 3):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `3`")  # noqa: E501
        if (self._configuration.client_side_validation and
                name is not None and not re.search(r'[a-zA-Z][a-zA-Z\\d]*', name)):  # noqa: E501
            raise ValueError(r"Invalid value for `name`, must be a follow pattern or equal to `/[a-zA-Z][a-zA-Z\\d]*/`")  # noqa: E501

        self._name = name

    @property
    def description(self):
        """Gets the description of this Organization.  # noqa: E501

        Description of the organization  # noqa: E501

        :return: The description of this Organization.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Organization.

        Description of the organization  # noqa: E501

        :param description: The description of this Organization.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def link(self):
        """Gets the link of this Organization.  # noqa: E501

        Link to the organization website  # noqa: E501

        :return: The link of this Organization.  # noqa: E501
        :rtype: str
        """
        return self._link

    @link.setter
    def link(self, link):
        """Sets the link of this Organization.

        Link to the organization website  # noqa: E501

        :param link: The link of this Organization.  # noqa: E501
        :type: str
        """

        self._link = link

    @property
    def location(self):
        """Gets the location of this Organization.  # noqa: E501

        Location of the organization  # noqa: E501

        :return: The location of this Organization.  # noqa: E501
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this Organization.

        Location of the organization  # noqa: E501

        :param location: The location of this Organization.  # noqa: E501
        :type: str
        """

        self._location = location

    @property
    def email(self):
        """Gets the email of this Organization.  # noqa: E501

        Contact email for the organization  # noqa: E501

        :return: The email of this Organization.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this Organization.

        Contact email for the organization  # noqa: E501

        :param email: The email of this Organization.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def status(self):
        """Gets the status of this Organization.  # noqa: E501

        Is the organization approved, pending, or rejected  # noqa: E501

        :return: The status of this Organization.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Organization.

        Is the organization approved, pending, or rejected  # noqa: E501

        :param status: The status of this Organization.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and status is None:
            raise ValueError("Invalid value for `status`, must not be `None`")  # noqa: E501
        allowed_values = ["PENDING", "REJECTED", "APPROVED"]  # noqa: E501
        if (self._configuration.client_side_validation and
                status not in allowed_values):
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def users(self):
        """Gets the users of this Organization.  # noqa: E501

        Set of users in the organization  # noqa: E501

        :return: The users of this Organization.  # noqa: E501
        :rtype: list[OrganizationUser]
        """
        return self._users

    @users.setter
    def users(self, users):
        """Sets the users of this Organization.

        Set of users in the organization  # noqa: E501

        :param users: The users of this Organization.  # noqa: E501
        :type: list[OrganizationUser]
        """
        if self._configuration.client_side_validation and users is None:
            raise ValueError("Invalid value for `users`, must not be `None`")  # noqa: E501

        self._users = users

    @property
    def topic(self):
        """Gets the topic of this Organization.  # noqa: E501

        Short description of the organization  # noqa: E501

        :return: The topic of this Organization.  # noqa: E501
        :rtype: str
        """
        return self._topic

    @topic.setter
    def topic(self, topic):
        """Sets the topic of this Organization.

        Short description of the organization  # noqa: E501

        :param topic: The topic of this Organization.  # noqa: E501
        :type: str
        """

        self._topic = topic

    @property
    def avatar_url(self):
        """Gets the avatar_url of this Organization.  # noqa: E501

        Logo URL  # noqa: E501

        :return: The avatar_url of this Organization.  # noqa: E501
        :rtype: str
        """
        return self._avatar_url

    @avatar_url.setter
    def avatar_url(self, avatar_url):
        """Sets the avatar_url of this Organization.

        Logo URL  # noqa: E501

        :param avatar_url: The avatar_url of this Organization.  # noqa: E501
        :type: str
        """
        if (self._configuration.client_side_validation and
                avatar_url is not None and not re.search(r'([^\\s]+)(\\.jpg|\\.jpeg|\\.png|\\.gif)', avatar_url)):  # noqa: E501
            raise ValueError(r"Invalid value for `avatar_url`, must be a follow pattern or equal to `/([^\\s]+)(\\.jpg|\\.jpeg|\\.png|\\.gif)/`")  # noqa: E501

        self._avatar_url = avatar_url

    @property
    def display_name(self):
        """Gets the display_name of this Organization.  # noqa: E501

        Display name for an organization (Ex. Ontario Institute for Cancer Research). Not used for links.  # noqa: E501

        :return: The display_name of this Organization.  # noqa: E501
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """Sets the display_name of this Organization.

        Display name for an organization (Ex. Ontario Institute for Cancer Research). Not used for links.  # noqa: E501

        :param display_name: The display_name of this Organization.  # noqa: E501
        :type: str
        """
        if (self._configuration.client_side_validation and
                display_name is not None and len(display_name) > 50):
            raise ValueError("Invalid value for `display_name`, length must be less than or equal to `50`")  # noqa: E501
        if (self._configuration.client_side_validation and
                display_name is not None and len(display_name) < 3):
            raise ValueError("Invalid value for `display_name`, length must be greater than or equal to `3`")  # noqa: E501
        if (self._configuration.client_side_validation and
                display_name is not None and not re.search(r'[\\w ,_\\-&()\']*', display_name)):  # noqa: E501
            raise ValueError(r"Invalid value for `display_name`, must be a follow pattern or equal to `/[\\w ,_\\-&()']*/`")  # noqa: E501

        self._display_name = display_name

    @property
    def starred_users(self):
        """Gets the starred_users of this Organization.  # noqa: E501

        This indicates the users that have starred this organization  # noqa: E501

        :return: The starred_users of this Organization.  # noqa: E501
        :rtype: list[User]
        """
        return self._starred_users

    @starred_users.setter
    def starred_users(self, starred_users):
        """Sets the starred_users of this Organization.

        This indicates the users that have starred this organization  # noqa: E501

        :param starred_users: The starred_users of this Organization.  # noqa: E501
        :type: list[User]
        """

        self._starred_users = starred_users

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Organization, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Organization):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Organization):
            return True

        return self.to_dict() != other.to_dict()
