# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class OrganizationUser(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'accepted': 'bool',
        'db_create_date': 'int',
        'db_update_date': 'int',
        'id': 'OrganizationUserId',
        'organization': 'Organization',
        'role': 'str',
        'user': 'User'
    }

    attribute_map = {
        'accepted': 'accepted',
        'db_create_date': 'dbCreateDate',
        'db_update_date': 'dbUpdateDate',
        'id': 'id',
        'organization': 'organization',
        'role': 'role',
        'user': 'user'
    }

    def __init__(self, accepted=None, db_create_date=None, db_update_date=None, id=None, organization=None, role=None, user=None, _configuration=None):  # noqa: E501
        """OrganizationUser - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._accepted = None
        self._db_create_date = None
        self._db_update_date = None
        self._id = None
        self._organization = None
        self._role = None
        self._user = None
        self.discriminator = None

        self.accepted = accepted
        if db_create_date is not None:
            self.db_create_date = db_create_date
        if db_update_date is not None:
            self.db_update_date = db_update_date
        if id is not None:
            self.id = id
        if organization is not None:
            self.organization = organization
        self.role = role
        if user is not None:
            self.user = user

    @property
    def accepted(self):
        """Gets the accepted of this OrganizationUser.  # noqa: E501

        Has the user accepted their membership.  # noqa: E501

        :return: The accepted of this OrganizationUser.  # noqa: E501
        :rtype: bool
        """
        return self._accepted

    @accepted.setter
    def accepted(self, accepted):
        """Sets the accepted of this OrganizationUser.

        Has the user accepted their membership.  # noqa: E501

        :param accepted: The accepted of this OrganizationUser.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and accepted is None:
            raise ValueError("Invalid value for `accepted`, must not be `None`")  # noqa: E501

        self._accepted = accepted

    @property
    def db_create_date(self):
        """Gets the db_create_date of this OrganizationUser.  # noqa: E501


        :return: The db_create_date of this OrganizationUser.  # noqa: E501
        :rtype: int
        """
        return self._db_create_date

    @db_create_date.setter
    def db_create_date(self, db_create_date):
        """Sets the db_create_date of this OrganizationUser.


        :param db_create_date: The db_create_date of this OrganizationUser.  # noqa: E501
        :type: int
        """

        self._db_create_date = db_create_date

    @property
    def db_update_date(self):
        """Gets the db_update_date of this OrganizationUser.  # noqa: E501


        :return: The db_update_date of this OrganizationUser.  # noqa: E501
        :rtype: int
        """
        return self._db_update_date

    @db_update_date.setter
    def db_update_date(self, db_update_date):
        """Sets the db_update_date of this OrganizationUser.


        :param db_update_date: The db_update_date of this OrganizationUser.  # noqa: E501
        :type: int
        """

        self._db_update_date = db_update_date

    @property
    def id(self):
        """Gets the id of this OrganizationUser.  # noqa: E501


        :return: The id of this OrganizationUser.  # noqa: E501
        :rtype: OrganizationUserId
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this OrganizationUser.


        :param id: The id of this OrganizationUser.  # noqa: E501
        :type: OrganizationUserId
        """

        self._id = id

    @property
    def organization(self):
        """Gets the organization of this OrganizationUser.  # noqa: E501


        :return: The organization of this OrganizationUser.  # noqa: E501
        :rtype: Organization
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        """Sets the organization of this OrganizationUser.


        :param organization: The organization of this OrganizationUser.  # noqa: E501
        :type: Organization
        """

        self._organization = organization

    @property
    def role(self):
        """Gets the role of this OrganizationUser.  # noqa: E501

        The role of the user in the organization  # noqa: E501

        :return: The role of this OrganizationUser.  # noqa: E501
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this OrganizationUser.

        The role of the user in the organization  # noqa: E501

        :param role: The role of this OrganizationUser.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and role is None:
            raise ValueError("Invalid value for `role`, must not be `None`")  # noqa: E501
        allowed_values = ["ADMIN", "MAINTAINER", "MEMBER"]  # noqa: E501
        if (self._configuration.client_side_validation and
                role not in allowed_values):
            raise ValueError(
                "Invalid value for `role` ({0}), must be one of {1}"  # noqa: E501
                .format(role, allowed_values)
            )

        self._role = role

    @property
    def user(self):
        """Gets the user of this OrganizationUser.  # noqa: E501


        :return: The user of this OrganizationUser.  # noqa: E501
        :rtype: User
        """
        return self._user

    @user.setter
    def user(self, user):
        """Sets the user of this OrganizationUser.


        :param user: The user of this OrganizationUser.  # noqa: E501
        :type: User
        """

        self._user = user

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OrganizationUser, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OrganizationUser):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, OrganizationUser):
            return True

        return self.to_dict() != other.to_dict()
