# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class ParsedInformation(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'descriptor_language': 'str',
        'has_http_imports': 'bool',
        'has_local_imports': 'bool'
    }

    attribute_map = {
        'descriptor_language': 'descriptorLanguage',
        'has_http_imports': 'hasHTTPImports',
        'has_local_imports': 'hasLocalImports'
    }

    def __init__(self, descriptor_language=None, has_http_imports=None, has_local_imports=None, _configuration=None):  # noqa: E501
        """ParsedInformation - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._descriptor_language = None
        self._has_http_imports = None
        self._has_local_imports = None
        self.discriminator = None

        if descriptor_language is not None:
            self.descriptor_language = descriptor_language
        if has_http_imports is not None:
            self.has_http_imports = has_http_imports
        if has_local_imports is not None:
            self.has_local_imports = has_local_imports

    @property
    def descriptor_language(self):
        """Gets the descriptor_language of this ParsedInformation.  # noqa: E501


        :return: The descriptor_language of this ParsedInformation.  # noqa: E501
        :rtype: str
        """
        return self._descriptor_language

    @descriptor_language.setter
    def descriptor_language(self, descriptor_language):
        """Sets the descriptor_language of this ParsedInformation.


        :param descriptor_language: The descriptor_language of this ParsedInformation.  # noqa: E501
        :type: str
        """
        allowed_values = ["CWL", "WDL", "GXFORMAT2", "SWL", "NEXTFLOW", "SERVICE"]  # noqa: E501
        if (self._configuration.client_side_validation and
                descriptor_language not in allowed_values):
            raise ValueError(
                "Invalid value for `descriptor_language` ({0}), must be one of {1}"  # noqa: E501
                .format(descriptor_language, allowed_values)
            )

        self._descriptor_language = descriptor_language

    @property
    def has_http_imports(self):
        """Gets the has_http_imports of this ParsedInformation.  # noqa: E501


        :return: The has_http_imports of this ParsedInformation.  # noqa: E501
        :rtype: bool
        """
        return self._has_http_imports

    @has_http_imports.setter
    def has_http_imports(self, has_http_imports):
        """Sets the has_http_imports of this ParsedInformation.


        :param has_http_imports: The has_http_imports of this ParsedInformation.  # noqa: E501
        :type: bool
        """

        self._has_http_imports = has_http_imports

    @property
    def has_local_imports(self):
        """Gets the has_local_imports of this ParsedInformation.  # noqa: E501


        :return: The has_local_imports of this ParsedInformation.  # noqa: E501
        :rtype: bool
        """
        return self._has_local_imports

    @has_local_imports.setter
    def has_local_imports(self, has_local_imports):
        """Sets the has_local_imports of this ParsedInformation.


        :param has_local_imports: The has_local_imports of this ParsedInformation.  # noqa: E501
        :type: bool
        """

        self._has_local_imports = has_local_imports

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ParsedInformation, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ParsedInformation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ParsedInformation):
            return True

        return self.to_dict() != other.to_dict()
