# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Repository(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'can_delete': 'bool',
        'git_registry': 'str',
        'organization': 'str',
        'path': 'str',
        'present': 'bool',
        'repository_name': 'str'
    }

    attribute_map = {
        'can_delete': 'canDelete',
        'git_registry': 'gitRegistry',
        'organization': 'organization',
        'path': 'path',
        'present': 'present',
        'repository_name': 'repositoryName'
    }

    def __init__(self, can_delete=None, git_registry=None, organization=None, path=None, present=None, repository_name=None, _configuration=None):  # noqa: E501
        """Repository - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._can_delete = None
        self._git_registry = None
        self._organization = None
        self._path = None
        self._present = None
        self._repository_name = None
        self.discriminator = None

        if can_delete is not None:
            self.can_delete = can_delete
        if git_registry is not None:
            self.git_registry = git_registry
        if organization is not None:
            self.organization = organization
        if path is not None:
            self.path = path
        if present is not None:
            self.present = present
        if repository_name is not None:
            self.repository_name = repository_name

    @property
    def can_delete(self):
        """Gets the can_delete of this Repository.  # noqa: E501


        :return: The can_delete of this Repository.  # noqa: E501
        :rtype: bool
        """
        return self._can_delete

    @can_delete.setter
    def can_delete(self, can_delete):
        """Sets the can_delete of this Repository.


        :param can_delete: The can_delete of this Repository.  # noqa: E501
        :type: bool
        """

        self._can_delete = can_delete

    @property
    def git_registry(self):
        """Gets the git_registry of this Repository.  # noqa: E501


        :return: The git_registry of this Repository.  # noqa: E501
        :rtype: str
        """
        return self._git_registry

    @git_registry.setter
    def git_registry(self, git_registry):
        """Sets the git_registry of this Repository.


        :param git_registry: The git_registry of this Repository.  # noqa: E501
        :type: str
        """
        allowed_values = ["dockstore.org", "github.com", "bitbucket.org", "gitlab.com"]  # noqa: E501
        if (self._configuration.client_side_validation and
                git_registry not in allowed_values):
            raise ValueError(
                "Invalid value for `git_registry` ({0}), must be one of {1}"  # noqa: E501
                .format(git_registry, allowed_values)
            )

        self._git_registry = git_registry

    @property
    def organization(self):
        """Gets the organization of this Repository.  # noqa: E501


        :return: The organization of this Repository.  # noqa: E501
        :rtype: str
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        """Sets the organization of this Repository.


        :param organization: The organization of this Repository.  # noqa: E501
        :type: str
        """

        self._organization = organization

    @property
    def path(self):
        """Gets the path of this Repository.  # noqa: E501


        :return: The path of this Repository.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this Repository.


        :param path: The path of this Repository.  # noqa: E501
        :type: str
        """

        self._path = path

    @property
    def present(self):
        """Gets the present of this Repository.  # noqa: E501


        :return: The present of this Repository.  # noqa: E501
        :rtype: bool
        """
        return self._present

    @present.setter
    def present(self, present):
        """Sets the present of this Repository.


        :param present: The present of this Repository.  # noqa: E501
        :type: bool
        """

        self._present = present

    @property
    def repository_name(self):
        """Gets the repository_name of this Repository.  # noqa: E501


        :return: The repository_name of this Repository.  # noqa: E501
        :rtype: str
        """
        return self._repository_name

    @repository_name.setter
    def repository_name(self, repository_name):
        """Sets the repository_name of this Repository.


        :param repository_name: The repository_name of this Repository.  # noqa: E501
        :type: str
        """

        self._repository_name = repository_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Repository, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Repository):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Repository):
            return True

        return self.to_dict() != other.to_dict()
