# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class SharedWorkflows(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'role': 'str',
        'workflows': 'list[Workflow]'
    }

    attribute_map = {
        'role': 'role',
        'workflows': 'workflows'
    }

    def __init__(self, role=None, workflows=None, _configuration=None):  # noqa: E501
        """SharedWorkflows - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._role = None
        self._workflows = None
        self.discriminator = None

        if role is not None:
            self.role = role
        if workflows is not None:
            self.workflows = workflows

    @property
    def role(self):
        """Gets the role of this SharedWorkflows.  # noqa: E501


        :return: The role of this SharedWorkflows.  # noqa: E501
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this SharedWorkflows.


        :param role: The role of this SharedWorkflows.  # noqa: E501
        :type: str
        """
        allowed_values = ["OWNER", "WRITER", "READER"]  # noqa: E501
        if (self._configuration.client_side_validation and
                role not in allowed_values):
            raise ValueError(
                "Invalid value for `role` ({0}), must be one of {1}"  # noqa: E501
                .format(role, allowed_values)
            )

        self._role = role

    @property
    def workflows(self):
        """Gets the workflows of this SharedWorkflows.  # noqa: E501


        :return: The workflows of this SharedWorkflows.  # noqa: E501
        :rtype: list[Workflow]
        """
        return self._workflows

    @workflows.setter
    def workflows(self, workflows):
        """Sets the workflows of this SharedWorkflows.


        :param workflows: The workflows of this SharedWorkflows.  # noqa: E501
        :type: list[Workflow]
        """

        self._workflows = workflows

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SharedWorkflows, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SharedWorkflows):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SharedWorkflows):
            return True

        return self.to_dict() != other.to_dict()
