# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class SourceFile(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'verified_by_source': 'dict(str, VerificationInformation)',
        'type': 'str',
        'content': 'str',
        'path': 'str',
        'absolute_path': 'str',
        'frozen': 'bool',
        'checksums': 'list[Checksum]'
    }

    attribute_map = {
        'id': 'id',
        'verified_by_source': 'verifiedBySource',
        'type': 'type',
        'content': 'content',
        'path': 'path',
        'absolute_path': 'absolutePath',
        'frozen': 'frozen',
        'checksums': 'checksums'
    }

    def __init__(self, id=None, verified_by_source=None, type=None, content=None, path=None, absolute_path=None, frozen=None, checksums=None, _configuration=None):  # noqa: E501
        """SourceFile - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._id = None
        self._verified_by_source = None
        self._type = None
        self._content = None
        self._path = None
        self._absolute_path = None
        self._frozen = None
        self._checksums = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if verified_by_source is not None:
            self.verified_by_source = verified_by_source
        self.type = type
        if content is not None:
            self.content = content
        self.path = path
        self.absolute_path = absolute_path
        if frozen is not None:
            self.frozen = frozen
        if checksums is not None:
            self.checksums = checksums

    @property
    def id(self):
        """Gets the id of this SourceFile.  # noqa: E501

        Implementation specific ID for the source file in this web service  # noqa: E501

        :return: The id of this SourceFile.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this SourceFile.

        Implementation specific ID for the source file in this web service  # noqa: E501

        :param id: The id of this SourceFile.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def verified_by_source(self):
        """Gets the verified_by_source of this SourceFile.  # noqa: E501

        maps from platform to whether an entry successfully ran on it using this test json  # noqa: E501

        :return: The verified_by_source of this SourceFile.  # noqa: E501
        :rtype: dict(str, VerificationInformation)
        """
        return self._verified_by_source

    @verified_by_source.setter
    def verified_by_source(self, verified_by_source):
        """Sets the verified_by_source of this SourceFile.

        maps from platform to whether an entry successfully ran on it using this test json  # noqa: E501

        :param verified_by_source: The verified_by_source of this SourceFile.  # noqa: E501
        :type: dict(str, VerificationInformation)
        """

        self._verified_by_source = verified_by_source

    @property
    def type(self):
        """Gets the type of this SourceFile.  # noqa: E501

        Enumerates the type of file  # noqa: E501

        :return: The type of this SourceFile.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this SourceFile.

        Enumerates the type of file  # noqa: E501

        :param type: The type of this SourceFile.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["DOCKSTORE_CWL", "DOCKSTORE_WDL", "DOCKERFILE", "CWL_TEST_JSON", "WDL_TEST_JSON", "NEXTFLOW", "NEXTFLOW_CONFIG", "NEXTFLOW_TEST_PARAMS", "DOCKSTORE_YML", "DOCKSTORE_SERVICE_YML", "DOCKSTORE_SERVICE_TEST_JSON", "DOCKSTORE_SERVICE_OTHER", "DOCKSTORE_GXFORMAT2", "GXFORMAT2_TEST_FILE", "DOCKSTORE_SWL", "SWL_TEST_JSON"]  # noqa: E501
        if (self._configuration.client_side_validation and
                type not in allowed_values):
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def content(self):
        """Gets the content of this SourceFile.  # noqa: E501

        Cache for the contents of the target file  # noqa: E501

        :return: The content of this SourceFile.  # noqa: E501
        :rtype: str
        """
        return self._content

    @content.setter
    def content(self, content):
        """Sets the content of this SourceFile.

        Cache for the contents of the target file  # noqa: E501

        :param content: The content of this SourceFile.  # noqa: E501
        :type: str
        """

        self._content = content

    @property
    def path(self):
        """Gets the path of this SourceFile.  # noqa: E501

        Path to sourcefile relative to its parent  # noqa: E501

        :return: The path of this SourceFile.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this SourceFile.

        Path to sourcefile relative to its parent  # noqa: E501

        :param path: The path of this SourceFile.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and path is None:
            raise ValueError("Invalid value for `path`, must not be `None`")  # noqa: E501

        self._path = path

    @property
    def absolute_path(self):
        """Gets the absolute_path of this SourceFile.  # noqa: E501

        Absolute path of sourcefile in git repo  # noqa: E501

        :return: The absolute_path of this SourceFile.  # noqa: E501
        :rtype: str
        """
        return self._absolute_path

    @absolute_path.setter
    def absolute_path(self, absolute_path):
        """Sets the absolute_path of this SourceFile.

        Absolute path of sourcefile in git repo  # noqa: E501

        :param absolute_path: The absolute_path of this SourceFile.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and absolute_path is None:
            raise ValueError("Invalid value for `absolute_path`, must not be `None`")  # noqa: E501

        self._absolute_path = absolute_path

    @property
    def frozen(self):
        """Gets the frozen of this SourceFile.  # noqa: E501

        When true, this version cannot be affected by refreshes to the content or updates to its metadata  # noqa: E501

        :return: The frozen of this SourceFile.  # noqa: E501
        :rtype: bool
        """
        return self._frozen

    @frozen.setter
    def frozen(self, frozen):
        """Sets the frozen of this SourceFile.

        When true, this version cannot be affected by refreshes to the content or updates to its metadata  # noqa: E501

        :param frozen: The frozen of this SourceFile.  # noqa: E501
        :type: bool
        """

        self._frozen = frozen

    @property
    def checksums(self):
        """Gets the checksums of this SourceFile.  # noqa: E501

        The checksum(s) of the sourcefile's content  # noqa: E501

        :return: The checksums of this SourceFile.  # noqa: E501
        :rtype: list[Checksum]
        """
        return self._checksums

    @checksums.setter
    def checksums(self, checksums):
        """Sets the checksums of this SourceFile.

        The checksum(s) of the sourcefile's content  # noqa: E501

        :param checksums: The checksums of this SourceFile.  # noqa: E501
        :type: list[Checksum]
        """

        self._checksums = checksums

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SourceFile, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SourceFile):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SourceFile):
            return True

        return self.to_dict() != other.to_dict()
