# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Tag(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'authors': 'list[Author]',
        'id': 'int',
        'orcid_authors': 'list[OrcidAuthor]',
        'version_metadata': 'VersionMetadata',
        'reference': 'str',
        'name': 'str',
        'commit_id': 'str',
        'frozen': 'bool',
        'reference_type': 'str',
        'valid': 'bool',
        'dirty_bit': 'bool',
        'version_editor': 'User',
        'db_update_date': 'int',
        'input_file_formats': 'list[FileFormat]',
        'output_file_formats': 'list[FileFormat]',
        'validations': 'list[Validation]',
        'images': 'list[Image]',
        'verified': 'bool',
        'verified_source': 'str',
        'hidden': 'bool',
        'verified_sources': 'list[str]',
        'doi_url': 'str',
        'image_id': 'str',
        'doi_status': 'str',
        'author': 'str',
        'description': 'str',
        'description_source': 'str',
        'email': 'str',
        'last_built': 'int',
        'size': 'int',
        'dockerfile_path': 'str',
        'cwl_path': 'str',
        'wdl_path': 'str',
        'automated': 'bool',
        'working_directory': 'str'
    }

    attribute_map = {
        'authors': 'authors',
        'id': 'id',
        'orcid_authors': 'orcidAuthors',
        'version_metadata': 'versionMetadata',
        'reference': 'reference',
        'name': 'name',
        'commit_id': 'commitID',
        'frozen': 'frozen',
        'reference_type': 'referenceType',
        'valid': 'valid',
        'dirty_bit': 'dirtyBit',
        'version_editor': 'versionEditor',
        'db_update_date': 'dbUpdateDate',
        'input_file_formats': 'input_file_formats',
        'output_file_formats': 'output_file_formats',
        'validations': 'validations',
        'images': 'images',
        'verified': 'verified',
        'verified_source': 'verifiedSource',
        'hidden': 'hidden',
        'verified_sources': 'verifiedSources',
        'doi_url': 'doiURL',
        'image_id': 'image_id',
        'doi_status': 'doiStatus',
        'author': 'author',
        'description': 'description',
        'description_source': 'descriptionSource',
        'email': 'email',
        'last_built': 'last_built',
        'size': 'size',
        'dockerfile_path': 'dockerfile_path',
        'cwl_path': 'cwl_path',
        'wdl_path': 'wdl_path',
        'automated': 'automated',
        'working_directory': 'workingDirectory'
    }

    def __init__(self, authors=None, id=None, orcid_authors=None, version_metadata=None, reference=None, name=None, commit_id=None, frozen=None, reference_type=None, valid=None, dirty_bit=None, version_editor=None, db_update_date=None, input_file_formats=None, output_file_formats=None, validations=None, images=None, verified=None, verified_source=None, hidden=None, verified_sources=None, doi_url=None, image_id=None, doi_status=None, author=None, description=None, description_source=None, email=None, last_built=None, size=None, dockerfile_path=None, cwl_path=None, wdl_path=None, automated=None, working_directory=None, _configuration=None):  # noqa: E501
        """Tag - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._authors = None
        self._id = None
        self._orcid_authors = None
        self._version_metadata = None
        self._reference = None
        self._name = None
        self._commit_id = None
        self._frozen = None
        self._reference_type = None
        self._valid = None
        self._dirty_bit = None
        self._version_editor = None
        self._db_update_date = None
        self._input_file_formats = None
        self._output_file_formats = None
        self._validations = None
        self._images = None
        self._verified = None
        self._verified_source = None
        self._hidden = None
        self._verified_sources = None
        self._doi_url = None
        self._image_id = None
        self._doi_status = None
        self._author = None
        self._description = None
        self._description_source = None
        self._email = None
        self._last_built = None
        self._size = None
        self._dockerfile_path = None
        self._cwl_path = None
        self._wdl_path = None
        self._automated = None
        self._working_directory = None
        self.discriminator = None

        if authors is not None:
            self.authors = authors
        if id is not None:
            self.id = id
        if orcid_authors is not None:
            self.orcid_authors = orcid_authors
        if version_metadata is not None:
            self.version_metadata = version_metadata
        self.reference = reference
        self.name = name
        if commit_id is not None:
            self.commit_id = commit_id
        if frozen is not None:
            self.frozen = frozen
        if reference_type is not None:
            self.reference_type = reference_type
        if valid is not None:
            self.valid = valid
        if dirty_bit is not None:
            self.dirty_bit = dirty_bit
        if version_editor is not None:
            self.version_editor = version_editor
        if db_update_date is not None:
            self.db_update_date = db_update_date
        if input_file_formats is not None:
            self.input_file_formats = input_file_formats
        if output_file_formats is not None:
            self.output_file_formats = output_file_formats
        if validations is not None:
            self.validations = validations
        if images is not None:
            self.images = images
        if verified is not None:
            self.verified = verified
        if verified_source is not None:
            self.verified_source = verified_source
        if hidden is not None:
            self.hidden = hidden
        if verified_sources is not None:
            self.verified_sources = verified_sources
        if doi_url is not None:
            self.doi_url = doi_url
        if image_id is not None:
            self.image_id = image_id
        if doi_status is not None:
            self.doi_status = doi_status
        if author is not None:
            self.author = author
        if description is not None:
            self.description = description
        if description_source is not None:
            self.description_source = description_source
        if email is not None:
            self.email = email
        if last_built is not None:
            self.last_built = last_built
        if size is not None:
            self.size = size
        if dockerfile_path is not None:
            self.dockerfile_path = dockerfile_path
        if cwl_path is not None:
            self.cwl_path = cwl_path
        if wdl_path is not None:
            self.wdl_path = wdl_path
        if automated is not None:
            self.automated = automated
        if working_directory is not None:
            self.working_directory = working_directory

    @property
    def authors(self):
        """Gets the authors of this Tag.  # noqa: E501

        Non-ORCID Authors for each version.  # noqa: E501

        :return: The authors of this Tag.  # noqa: E501
        :rtype: list[Author]
        """
        return self._authors

    @authors.setter
    def authors(self, authors):
        """Sets the authors of this Tag.

        Non-ORCID Authors for each version.  # noqa: E501

        :param authors: The authors of this Tag.  # noqa: E501
        :type: list[Author]
        """

        self._authors = authors

    @property
    def id(self):
        """Gets the id of this Tag.  # noqa: E501

        Implementation specific ID for the tag in this web service  # noqa: E501

        :return: The id of this Tag.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Tag.

        Implementation specific ID for the tag in this web service  # noqa: E501

        :param id: The id of this Tag.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def orcid_authors(self):
        """Gets the orcid_authors of this Tag.  # noqa: E501

        ORCID Authors for versions.  # noqa: E501

        :return: The orcid_authors of this Tag.  # noqa: E501
        :rtype: list[OrcidAuthor]
        """
        return self._orcid_authors

    @orcid_authors.setter
    def orcid_authors(self, orcid_authors):
        """Sets the orcid_authors of this Tag.

        ORCID Authors for versions.  # noqa: E501

        :param orcid_authors: The orcid_authors of this Tag.  # noqa: E501
        :type: list[OrcidAuthor]
        """

        self._orcid_authors = orcid_authors

    @property
    def version_metadata(self):
        """Gets the version_metadata of this Tag.  # noqa: E501


        :return: The version_metadata of this Tag.  # noqa: E501
        :rtype: VersionMetadata
        """
        return self._version_metadata

    @version_metadata.setter
    def version_metadata(self, version_metadata):
        """Sets the version_metadata of this Tag.


        :param version_metadata: The version_metadata of this Tag.  # noqa: E501
        :type: VersionMetadata
        """

        self._version_metadata = version_metadata

    @property
    def reference(self):
        """Gets the reference of this Tag.  # noqa: E501

        git commit/tag/branch  # noqa: E501

        :return: The reference of this Tag.  # noqa: E501
        :rtype: str
        """
        return self._reference

    @reference.setter
    def reference(self, reference):
        """Sets the reference of this Tag.

        git commit/tag/branch  # noqa: E501

        :param reference: The reference of this Tag.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and reference is None:
            raise ValueError("Invalid value for `reference`, must not be `None`")  # noqa: E501

        self._reference = reference

    @property
    def name(self):
        """Gets the name of this Tag.  # noqa: E501

        Implementation specific, can be a quay.io or docker hub tag name  # noqa: E501

        :return: The name of this Tag.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Tag.

        Implementation specific, can be a quay.io or docker hub tag name  # noqa: E501

        :param name: The name of this Tag.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and name is None:
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def commit_id(self):
        """Gets the commit_id of this Tag.  # noqa: E501

        This is the commit id for the source control that the files belong to  # noqa: E501

        :return: The commit_id of this Tag.  # noqa: E501
        :rtype: str
        """
        return self._commit_id

    @commit_id.setter
    def commit_id(self, commit_id):
        """Sets the commit_id of this Tag.

        This is the commit id for the source control that the files belong to  # noqa: E501

        :param commit_id: The commit_id of this Tag.  # noqa: E501
        :type: str
        """

        self._commit_id = commit_id

    @property
    def frozen(self):
        """Gets the frozen of this Tag.  # noqa: E501

        When true, this version cannot be affected by refreshes to the content or updates to its metadata  # noqa: E501

        :return: The frozen of this Tag.  # noqa: E501
        :rtype: bool
        """
        return self._frozen

    @frozen.setter
    def frozen(self, frozen):
        """Sets the frozen of this Tag.

        When true, this version cannot be affected by refreshes to the content or updates to its metadata  # noqa: E501

        :param frozen: The frozen of this Tag.  # noqa: E501
        :type: bool
        """

        self._frozen = frozen

    @property
    def reference_type(self):
        """Gets the reference_type of this Tag.  # noqa: E501

        This indicates the type of git (or other source control) reference  # noqa: E501

        :return: The reference_type of this Tag.  # noqa: E501
        :rtype: str
        """
        return self._reference_type

    @reference_type.setter
    def reference_type(self, reference_type):
        """Sets the reference_type of this Tag.

        This indicates the type of git (or other source control) reference  # noqa: E501

        :param reference_type: The reference_type of this Tag.  # noqa: E501
        :type: str
        """
        allowed_values = ["COMMIT", "TAG", "BRANCH", "NOT_APPLICABLE", "UNSET"]  # noqa: E501
        if (self._configuration.client_side_validation and
                reference_type not in allowed_values):
            raise ValueError(
                "Invalid value for `reference_type` ({0}), must be one of {1}"  # noqa: E501
                .format(reference_type, allowed_values)
            )

        self._reference_type = reference_type

    @property
    def valid(self):
        """Gets the valid of this Tag.  # noqa: E501

        Implementation specific, whether this tag has valid files from source code repo  # noqa: E501

        :return: The valid of this Tag.  # noqa: E501
        :rtype: bool
        """
        return self._valid

    @valid.setter
    def valid(self, valid):
        """Sets the valid of this Tag.

        Implementation specific, whether this tag has valid files from source code repo  # noqa: E501

        :param valid: The valid of this Tag.  # noqa: E501
        :type: bool
        """

        self._valid = valid

    @property
    def dirty_bit(self):
        """Gets the dirty_bit of this Tag.  # noqa: E501

        True if user has altered the tag  # noqa: E501

        :return: The dirty_bit of this Tag.  # noqa: E501
        :rtype: bool
        """
        return self._dirty_bit

    @dirty_bit.setter
    def dirty_bit(self, dirty_bit):
        """Sets the dirty_bit of this Tag.

        True if user has altered the tag  # noqa: E501

        :param dirty_bit: The dirty_bit of this Tag.  # noqa: E501
        :type: bool
        """

        self._dirty_bit = dirty_bit

    @property
    def version_editor(self):
        """Gets the version_editor of this Tag.  # noqa: E501

        Particularly for hosted workflows, this records who edited to create a revision  # noqa: E501

        :return: The version_editor of this Tag.  # noqa: E501
        :rtype: User
        """
        return self._version_editor

    @version_editor.setter
    def version_editor(self, version_editor):
        """Sets the version_editor of this Tag.

        Particularly for hosted workflows, this records who edited to create a revision  # noqa: E501

        :param version_editor: The version_editor of this Tag.  # noqa: E501
        :type: User
        """

        self._version_editor = version_editor

    @property
    def db_update_date(self):
        """Gets the db_update_date of this Tag.  # noqa: E501


        :return: The db_update_date of this Tag.  # noqa: E501
        :rtype: int
        """
        return self._db_update_date

    @db_update_date.setter
    def db_update_date(self, db_update_date):
        """Sets the db_update_date of this Tag.


        :param db_update_date: The db_update_date of this Tag.  # noqa: E501
        :type: int
        """

        self._db_update_date = db_update_date

    @property
    def input_file_formats(self):
        """Gets the input_file_formats of this Tag.  # noqa: E501

        File formats for describing the input file formats of versions (tag/workflowVersion)  # noqa: E501

        :return: The input_file_formats of this Tag.  # noqa: E501
        :rtype: list[FileFormat]
        """
        return self._input_file_formats

    @input_file_formats.setter
    def input_file_formats(self, input_file_formats):
        """Sets the input_file_formats of this Tag.

        File formats for describing the input file formats of versions (tag/workflowVersion)  # noqa: E501

        :param input_file_formats: The input_file_formats of this Tag.  # noqa: E501
        :type: list[FileFormat]
        """

        self._input_file_formats = input_file_formats

    @property
    def output_file_formats(self):
        """Gets the output_file_formats of this Tag.  # noqa: E501

        File formats for describing the output file formats of versions (tag/workflowVersion)  # noqa: E501

        :return: The output_file_formats of this Tag.  # noqa: E501
        :rtype: list[FileFormat]
        """
        return self._output_file_formats

    @output_file_formats.setter
    def output_file_formats(self, output_file_formats):
        """Sets the output_file_formats of this Tag.

        File formats for describing the output file formats of versions (tag/workflowVersion)  # noqa: E501

        :param output_file_formats: The output_file_formats of this Tag.  # noqa: E501
        :type: list[FileFormat]
        """

        self._output_file_formats = output_file_formats

    @property
    def validations(self):
        """Gets the validations of this Tag.  # noqa: E501

        Cached validations for each version.  # noqa: E501

        :return: The validations of this Tag.  # noqa: E501
        :rtype: list[Validation]
        """
        return self._validations

    @validations.setter
    def validations(self, validations):
        """Sets the validations of this Tag.

        Cached validations for each version.  # noqa: E501

        :param validations: The validations of this Tag.  # noqa: E501
        :type: list[Validation]
        """

        self._validations = validations

    @property
    def images(self):
        """Gets the images of this Tag.  # noqa: E501

        The images that belong to this version  # noqa: E501

        :return: The images of this Tag.  # noqa: E501
        :rtype: list[Image]
        """
        return self._images

    @images.setter
    def images(self, images):
        """Sets the images of this Tag.

        The images that belong to this version  # noqa: E501

        :param images: The images of this Tag.  # noqa: E501
        :type: list[Image]
        """

        self._images = images

    @property
    def verified(self):
        """Gets the verified of this Tag.  # noqa: E501

        Whether this version has been verified or not  # noqa: E501

        :return: The verified of this Tag.  # noqa: E501
        :rtype: bool
        """
        return self._verified

    @verified.setter
    def verified(self, verified):
        """Sets the verified of this Tag.

        Whether this version has been verified or not  # noqa: E501

        :param verified: The verified of this Tag.  # noqa: E501
        :type: bool
        """

        self._verified = verified

    @property
    def verified_source(self):
        """Gets the verified_source of this Tag.  # noqa: E501

        Verified source for the version  # noqa: E501

        :return: The verified_source of this Tag.  # noqa: E501
        :rtype: str
        """
        return self._verified_source

    @verified_source.setter
    def verified_source(self, verified_source):
        """Sets the verified_source of this Tag.

        Verified source for the version  # noqa: E501

        :param verified_source: The verified_source of this Tag.  # noqa: E501
        :type: str
        """

        self._verified_source = verified_source

    @property
    def hidden(self):
        """Gets the hidden of this Tag.  # noqa: E501

        Implementation specific, whether this row is visible to other users aside from the owner  # noqa: E501

        :return: The hidden of this Tag.  # noqa: E501
        :rtype: bool
        """
        return self._hidden

    @hidden.setter
    def hidden(self, hidden):
        """Sets the hidden of this Tag.

        Implementation specific, whether this row is visible to other users aside from the owner  # noqa: E501

        :param hidden: The hidden of this Tag.  # noqa: E501
        :type: bool
        """

        self._hidden = hidden

    @property
    def verified_sources(self):
        """Gets the verified_sources of this Tag.  # noqa: E501

        Verified source for the version  # noqa: E501

        :return: The verified_sources of this Tag.  # noqa: E501
        :rtype: list[str]
        """
        return self._verified_sources

    @verified_sources.setter
    def verified_sources(self, verified_sources):
        """Sets the verified_sources of this Tag.

        Verified source for the version  # noqa: E501

        :param verified_sources: The verified_sources of this Tag.  # noqa: E501
        :type: list[str]
        """

        self._verified_sources = verified_sources

    @property
    def doi_url(self):
        """Gets the doi_url of this Tag.  # noqa: E501

        This is a URL for the DOI for the version of the entry  # noqa: E501

        :return: The doi_url of this Tag.  # noqa: E501
        :rtype: str
        """
        return self._doi_url

    @doi_url.setter
    def doi_url(self, doi_url):
        """Sets the doi_url of this Tag.

        This is a URL for the DOI for the version of the entry  # noqa: E501

        :param doi_url: The doi_url of this Tag.  # noqa: E501
        :type: str
        """

        self._doi_url = doi_url

    @property
    def image_id(self):
        """Gets the image_id of this Tag.  # noqa: E501


        :return: The image_id of this Tag.  # noqa: E501
        :rtype: str
        """
        return self._image_id

    @image_id.setter
    def image_id(self, image_id):
        """Sets the image_id of this Tag.


        :param image_id: The image_id of this Tag.  # noqa: E501
        :type: str
        """

        self._image_id = image_id

    @property
    def doi_status(self):
        """Gets the doi_status of this Tag.  # noqa: E501

        This indicates the DOI status  # noqa: E501

        :return: The doi_status of this Tag.  # noqa: E501
        :rtype: str
        """
        return self._doi_status

    @doi_status.setter
    def doi_status(self, doi_status):
        """Sets the doi_status of this Tag.

        This indicates the DOI status  # noqa: E501

        :param doi_status: The doi_status of this Tag.  # noqa: E501
        :type: str
        """
        allowed_values = ["NOT_REQUESTED", "REQUESTED", "CREATED"]  # noqa: E501
        if (self._configuration.client_side_validation and
                doi_status not in allowed_values):
            raise ValueError(
                "Invalid value for `doi_status` ({0}), must be one of {1}"  # noqa: E501
                .format(doi_status, allowed_values)
            )

        self._doi_status = doi_status

    @property
    def author(self):
        """Gets the author of this Tag.  # noqa: E501


        :return: The author of this Tag.  # noqa: E501
        :rtype: str
        """
        return self._author

    @author.setter
    def author(self, author):
        """Sets the author of this Tag.


        :param author: The author of this Tag.  # noqa: E501
        :type: str
        """

        self._author = author

    @property
    def description(self):
        """Gets the description of this Tag.  # noqa: E501


        :return: The description of this Tag.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Tag.


        :param description: The description of this Tag.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def description_source(self):
        """Gets the description_source of this Tag.  # noqa: E501


        :return: The description_source of this Tag.  # noqa: E501
        :rtype: str
        """
        return self._description_source

    @description_source.setter
    def description_source(self, description_source):
        """Sets the description_source of this Tag.


        :param description_source: The description_source of this Tag.  # noqa: E501
        :type: str
        """
        allowed_values = ["README", "DESCRIPTOR"]  # noqa: E501
        if (self._configuration.client_side_validation and
                description_source not in allowed_values):
            raise ValueError(
                "Invalid value for `description_source` ({0}), must be one of {1}"  # noqa: E501
                .format(description_source, allowed_values)
            )

        self._description_source = description_source

    @property
    def email(self):
        """Gets the email of this Tag.  # noqa: E501


        :return: The email of this Tag.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this Tag.


        :param email: The email of this Tag.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def last_built(self):
        """Gets the last_built of this Tag.  # noqa: E501

        For automated tools: The last time the container backing this tool version was built. For hosted: N/A  # noqa: E501

        :return: The last_built of this Tag.  # noqa: E501
        :rtype: int
        """
        return self._last_built

    @last_built.setter
    def last_built(self, last_built):
        """Sets the last_built of this Tag.

        For automated tools: The last time the container backing this tool version was built. For hosted: N/A  # noqa: E501

        :param last_built: The last_built of this Tag.  # noqa: E501
        :type: int
        """

        self._last_built = last_built

    @property
    def size(self):
        """Gets the size of this Tag.  # noqa: E501

        Size of the image  # noqa: E501

        :return: The size of this Tag.  # noqa: E501
        :rtype: int
        """
        return self._size

    @size.setter
    def size(self, size):
        """Sets the size of this Tag.

        Size of the image  # noqa: E501

        :param size: The size of this Tag.  # noqa: E501
        :type: int
        """

        self._size = size

    @property
    def dockerfile_path(self):
        """Gets the dockerfile_path of this Tag.  # noqa: E501

        Path for the Dockerfile  # noqa: E501

        :return: The dockerfile_path of this Tag.  # noqa: E501
        :rtype: str
        """
        return self._dockerfile_path

    @dockerfile_path.setter
    def dockerfile_path(self, dockerfile_path):
        """Sets the dockerfile_path of this Tag.

        Path for the Dockerfile  # noqa: E501

        :param dockerfile_path: The dockerfile_path of this Tag.  # noqa: E501
        :type: str
        """

        self._dockerfile_path = dockerfile_path

    @property
    def cwl_path(self):
        """Gets the cwl_path of this Tag.  # noqa: E501

        Path for the CWL document  # noqa: E501

        :return: The cwl_path of this Tag.  # noqa: E501
        :rtype: str
        """
        return self._cwl_path

    @cwl_path.setter
    def cwl_path(self, cwl_path):
        """Sets the cwl_path of this Tag.

        Path for the CWL document  # noqa: E501

        :param cwl_path: The cwl_path of this Tag.  # noqa: E501
        :type: str
        """

        self._cwl_path = cwl_path

    @property
    def wdl_path(self):
        """Gets the wdl_path of this Tag.  # noqa: E501

        Path for the WDL document  # noqa: E501

        :return: The wdl_path of this Tag.  # noqa: E501
        :rtype: str
        """
        return self._wdl_path

    @wdl_path.setter
    def wdl_path(self, wdl_path):
        """Sets the wdl_path of this Tag.

        Path for the WDL document  # noqa: E501

        :param wdl_path: The wdl_path of this Tag.  # noqa: E501
        :type: str
        """

        self._wdl_path = wdl_path

    @property
    def automated(self):
        """Gets the automated of this Tag.  # noqa: E501

        Implementation specific, indicates whether this is an automated build on quay.io  # noqa: E501

        :return: The automated of this Tag.  # noqa: E501
        :rtype: bool
        """
        return self._automated

    @automated.setter
    def automated(self, automated):
        """Sets the automated of this Tag.

        Implementation specific, indicates whether this is an automated build on quay.io  # noqa: E501

        :param automated: The automated of this Tag.  # noqa: E501
        :type: bool
        """

        self._automated = automated

    @property
    def working_directory(self):
        """Gets the working_directory of this Tag.  # noqa: E501


        :return: The working_directory of this Tag.  # noqa: E501
        :rtype: str
        """
        return self._working_directory

    @working_directory.setter
    def working_directory(self, working_directory):
        """Sets the working_directory of this Tag.


        :param working_directory: The working_directory of this Tag.  # noqa: E501
        :type: str
        """

        self._working_directory = working_directory

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Tag, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Tag):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Tag):
            return True

        return self.to_dict() != other.to_dict()
