# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class TokenAuth(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'db_create_date': 'int',
        'db_update_date': 'int',
        'id': 'int',
        'token_source': 'str',
        'content': 'str',
        'username': 'str',
        'refresh_token': 'str',
        'user_id': 'int',
        'token': 'str'
    }

    attribute_map = {
        'db_create_date': 'dbCreateDate',
        'db_update_date': 'dbUpdateDate',
        'id': 'id',
        'token_source': 'tokenSource',
        'content': 'content',
        'username': 'username',
        'refresh_token': 'refreshToken',
        'user_id': 'userId',
        'token': 'token'
    }

    def __init__(self, db_create_date=None, db_update_date=None, id=None, token_source=None, content=None, username=None, refresh_token=None, user_id=None, token=None, _configuration=None):  # noqa: E501
        """TokenAuth - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._db_create_date = None
        self._db_update_date = None
        self._id = None
        self._token_source = None
        self._content = None
        self._username = None
        self._refresh_token = None
        self._user_id = None
        self._token = None
        self.discriminator = None

        if db_create_date is not None:
            self.db_create_date = db_create_date
        if db_update_date is not None:
            self.db_update_date = db_update_date
        if id is not None:
            self.id = id
        if token_source is not None:
            self.token_source = token_source
        if content is not None:
            self.content = content
        if username is not None:
            self.username = username
        if refresh_token is not None:
            self.refresh_token = refresh_token
        if user_id is not None:
            self.user_id = user_id
        if token is not None:
            self.token = token

    @property
    def db_create_date(self):
        """Gets the db_create_date of this TokenAuth.  # noqa: E501


        :return: The db_create_date of this TokenAuth.  # noqa: E501
        :rtype: int
        """
        return self._db_create_date

    @db_create_date.setter
    def db_create_date(self, db_create_date):
        """Sets the db_create_date of this TokenAuth.


        :param db_create_date: The db_create_date of this TokenAuth.  # noqa: E501
        :type: int
        """

        self._db_create_date = db_create_date

    @property
    def db_update_date(self):
        """Gets the db_update_date of this TokenAuth.  # noqa: E501


        :return: The db_update_date of this TokenAuth.  # noqa: E501
        :rtype: int
        """
        return self._db_update_date

    @db_update_date.setter
    def db_update_date(self, db_update_date):
        """Sets the db_update_date of this TokenAuth.


        :param db_update_date: The db_update_date of this TokenAuth.  # noqa: E501
        :type: int
        """

        self._db_update_date = db_update_date

    @property
    def id(self):
        """Gets the id of this TokenAuth.  # noqa: E501

        Implementation specific ID for the token in this web service  # noqa: E501

        :return: The id of this TokenAuth.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this TokenAuth.

        Implementation specific ID for the token in this web service  # noqa: E501

        :param id: The id of this TokenAuth.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def token_source(self):
        """Gets the token_source of this TokenAuth.  # noqa: E501

        Source website for this token  # noqa: E501

        :return: The token_source of this TokenAuth.  # noqa: E501
        :rtype: str
        """
        return self._token_source

    @token_source.setter
    def token_source(self, token_source):
        """Sets the token_source of this TokenAuth.

        Source website for this token  # noqa: E501

        :param token_source: The token_source of this TokenAuth.  # noqa: E501
        :type: str
        """

        self._token_source = token_source

    @property
    def content(self):
        """Gets the content of this TokenAuth.  # noqa: E501

        Contents of the access token  # noqa: E501

        :return: The content of this TokenAuth.  # noqa: E501
        :rtype: str
        """
        return self._content

    @content.setter
    def content(self, content):
        """Sets the content of this TokenAuth.

        Contents of the access token  # noqa: E501

        :param content: The content of this TokenAuth.  # noqa: E501
        :type: str
        """

        self._content = content

    @property
    def username(self):
        """Gets the username of this TokenAuth.  # noqa: E501

        When an integrated service is not aware of the username, we store it  # noqa: E501

        :return: The username of this TokenAuth.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this TokenAuth.

        When an integrated service is not aware of the username, we store it  # noqa: E501

        :param username: The username of this TokenAuth.  # noqa: E501
        :type: str
        """

        self._username = username

    @property
    def refresh_token(self):
        """Gets the refresh_token of this TokenAuth.  # noqa: E501


        :return: The refresh_token of this TokenAuth.  # noqa: E501
        :rtype: str
        """
        return self._refresh_token

    @refresh_token.setter
    def refresh_token(self, refresh_token):
        """Sets the refresh_token of this TokenAuth.


        :param refresh_token: The refresh_token of this TokenAuth.  # noqa: E501
        :type: str
        """

        self._refresh_token = refresh_token

    @property
    def user_id(self):
        """Gets the user_id of this TokenAuth.  # noqa: E501


        :return: The user_id of this TokenAuth.  # noqa: E501
        :rtype: int
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this TokenAuth.


        :param user_id: The user_id of this TokenAuth.  # noqa: E501
        :type: int
        """

        self._user_id = user_id

    @property
    def token(self):
        """Gets the token of this TokenAuth.  # noqa: E501

        Contents of the access token  # noqa: E501

        :return: The token of this TokenAuth.  # noqa: E501
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """Sets the token of this TokenAuth.

        Contents of the access token  # noqa: E501

        :param token: The token of this TokenAuth.  # noqa: E501
        :type: str
        """

        self._token = token

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TokenAuth, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TokenAuth):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TokenAuth):
            return True

        return self.to_dict() != other.to_dict()
