# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Tool(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'aliases': 'list[str]',
        'author': 'str',
        'checker_url': 'str',
        'contains': 'list[str]',
        'description': 'str',
        'has_checker': 'bool',
        'id': 'str',
        'meta_version': 'str',
        'organization': 'str',
        'signed': 'bool',
        'toolclass': 'ToolClass',
        'toolname': 'str',
        'url': 'str',
        'verified': 'bool',
        'verified_source': 'str',
        'versions': 'list[ToolVersion]'
    }

    attribute_map = {
        'aliases': 'aliases',
        'author': 'author',
        'checker_url': 'checker_url',
        'contains': 'contains',
        'description': 'description',
        'has_checker': 'has_checker',
        'id': 'id',
        'meta_version': 'meta_version',
        'organization': 'organization',
        'signed': 'signed',
        'toolclass': 'toolclass',
        'toolname': 'toolname',
        'url': 'url',
        'verified': 'verified',
        'verified_source': 'verified_source',
        'versions': 'versions'
    }

    def __init__(self, aliases=None, author=None, checker_url=None, contains=None, description=None, has_checker=None, id=None, meta_version=None, organization=None, signed=None, toolclass=None, toolname=None, url=None, verified=None, verified_source=None, versions=None, _configuration=None):  # noqa: E501
        """Tool - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._aliases = None
        self._author = None
        self._checker_url = None
        self._contains = None
        self._description = None
        self._has_checker = None
        self._id = None
        self._meta_version = None
        self._organization = None
        self._signed = None
        self._toolclass = None
        self._toolname = None
        self._url = None
        self._verified = None
        self._verified_source = None
        self._versions = None
        self.discriminator = None

        if aliases is not None:
            self.aliases = aliases
        self.author = author
        if checker_url is not None:
            self.checker_url = checker_url
        if contains is not None:
            self.contains = contains
        if description is not None:
            self.description = description
        if has_checker is not None:
            self.has_checker = has_checker
        self.id = id
        if meta_version is not None:
            self.meta_version = meta_version
        self.organization = organization
        if signed is not None:
            self.signed = signed
        self.toolclass = toolclass
        if toolname is not None:
            self.toolname = toolname
        self.url = url
        if verified is not None:
            self.verified = verified
        if verified_source is not None:
            self.verified_source = verified_source
        self.versions = versions

    @property
    def aliases(self):
        """Gets the aliases of this Tool.  # noqa: E501

        OPTIONAL A list of strings that can be used to identify this tool. This can be used to expose alternative ids (such as GUIDs) for a tool for registries. Can be used to match tools across registries.  # noqa: E501

        :return: The aliases of this Tool.  # noqa: E501
        :rtype: list[str]
        """
        return self._aliases

    @aliases.setter
    def aliases(self, aliases):
        """Sets the aliases of this Tool.

        OPTIONAL A list of strings that can be used to identify this tool. This can be used to expose alternative ids (such as GUIDs) for a tool for registries. Can be used to match tools across registries.  # noqa: E501

        :param aliases: The aliases of this Tool.  # noqa: E501
        :type: list[str]
        """

        self._aliases = aliases

    @property
    def author(self):
        """Gets the author of this Tool.  # noqa: E501

        Contact information for the author of this tool entry in the registry. (More complex authorship information is handled by the descriptor)  # noqa: E501

        :return: The author of this Tool.  # noqa: E501
        :rtype: str
        """
        return self._author

    @author.setter
    def author(self, author):
        """Sets the author of this Tool.

        Contact information for the author of this tool entry in the registry. (More complex authorship information is handled by the descriptor)  # noqa: E501

        :param author: The author of this Tool.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and author is None:
            raise ValueError("Invalid value for `author`, must not be `None`")  # noqa: E501

        self._author = author

    @property
    def checker_url(self):
        """Gets the checker_url of this Tool.  # noqa: E501

        Optional url to the checker tool that will exit successfully if this tool produced the expected result given test data.  # noqa: E501

        :return: The checker_url of this Tool.  # noqa: E501
        :rtype: str
        """
        return self._checker_url

    @checker_url.setter
    def checker_url(self, checker_url):
        """Sets the checker_url of this Tool.

        Optional url to the checker tool that will exit successfully if this tool produced the expected result given test data.  # noqa: E501

        :param checker_url: The checker_url of this Tool.  # noqa: E501
        :type: str
        """

        self._checker_url = checker_url

    @property
    def contains(self):
        """Gets the contains of this Tool.  # noqa: E501

        An array of IDs for the applications that are stored inside this tool  # noqa: E501

        :return: The contains of this Tool.  # noqa: E501
        :rtype: list[str]
        """
        return self._contains

    @contains.setter
    def contains(self, contains):
        """Sets the contains of this Tool.

        An array of IDs for the applications that are stored inside this tool  # noqa: E501

        :param contains: The contains of this Tool.  # noqa: E501
        :type: list[str]
        """

        self._contains = contains

    @property
    def description(self):
        """Gets the description of this Tool.  # noqa: E501

        The description of the tool.  # noqa: E501

        :return: The description of this Tool.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Tool.

        The description of the tool.  # noqa: E501

        :param description: The description of this Tool.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def has_checker(self):
        """Gets the has_checker of this Tool.  # noqa: E501

        Whether this tool has a checker tool associated with it  # noqa: E501

        :return: The has_checker of this Tool.  # noqa: E501
        :rtype: bool
        """
        return self._has_checker

    @has_checker.setter
    def has_checker(self, has_checker):
        """Sets the has_checker of this Tool.

        Whether this tool has a checker tool associated with it  # noqa: E501

        :param has_checker: The has_checker of this Tool.  # noqa: E501
        :type: bool
        """

        self._has_checker = has_checker

    @property
    def id(self):
        """Gets the id of this Tool.  # noqa: E501

        A unique identifier of the tool, scoped to this registry  # noqa: E501

        :return: The id of this Tool.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Tool.

        A unique identifier of the tool, scoped to this registry  # noqa: E501

        :param id: The id of this Tool.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def meta_version(self):
        """Gets the meta_version of this Tool.  # noqa: E501

        The version of this tool in the registry. Iterates when fields like the description, author, etc. are updated.  # noqa: E501

        :return: The meta_version of this Tool.  # noqa: E501
        :rtype: str
        """
        return self._meta_version

    @meta_version.setter
    def meta_version(self, meta_version):
        """Sets the meta_version of this Tool.

        The version of this tool in the registry. Iterates when fields like the description, author, etc. are updated.  # noqa: E501

        :param meta_version: The meta_version of this Tool.  # noqa: E501
        :type: str
        """

        self._meta_version = meta_version

    @property
    def organization(self):
        """Gets the organization of this Tool.  # noqa: E501

        The organization that published the image.  # noqa: E501

        :return: The organization of this Tool.  # noqa: E501
        :rtype: str
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        """Sets the organization of this Tool.

        The organization that published the image.  # noqa: E501

        :param organization: The organization of this Tool.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and organization is None:
            raise ValueError("Invalid value for `organization`, must not be `None`")  # noqa: E501

        self._organization = organization

    @property
    def signed(self):
        """Gets the signed of this Tool.  # noqa: E501

        Reports whether this tool has been signed.  # noqa: E501

        :return: The signed of this Tool.  # noqa: E501
        :rtype: bool
        """
        return self._signed

    @signed.setter
    def signed(self, signed):
        """Sets the signed of this Tool.

        Reports whether this tool has been signed.  # noqa: E501

        :param signed: The signed of this Tool.  # noqa: E501
        :type: bool
        """

        self._signed = signed

    @property
    def toolclass(self):
        """Gets the toolclass of this Tool.  # noqa: E501


        :return: The toolclass of this Tool.  # noqa: E501
        :rtype: ToolClass
        """
        return self._toolclass

    @toolclass.setter
    def toolclass(self, toolclass):
        """Sets the toolclass of this Tool.


        :param toolclass: The toolclass of this Tool.  # noqa: E501
        :type: ToolClass
        """
        if self._configuration.client_side_validation and toolclass is None:
            raise ValueError("Invalid value for `toolclass`, must not be `None`")  # noqa: E501

        self._toolclass = toolclass

    @property
    def toolname(self):
        """Gets the toolname of this Tool.  # noqa: E501

        The name of the tool.  # noqa: E501

        :return: The toolname of this Tool.  # noqa: E501
        :rtype: str
        """
        return self._toolname

    @toolname.setter
    def toolname(self, toolname):
        """Sets the toolname of this Tool.

        The name of the tool.  # noqa: E501

        :param toolname: The toolname of this Tool.  # noqa: E501
        :type: str
        """

        self._toolname = toolname

    @property
    def url(self):
        """Gets the url of this Tool.  # noqa: E501

        The URL for this tool in this registry  # noqa: E501

        :return: The url of this Tool.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this Tool.

        The URL for this tool in this registry  # noqa: E501

        :param url: The url of this Tool.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and url is None:
            raise ValueError("Invalid value for `url`, must not be `None`")  # noqa: E501

        self._url = url

    @property
    def verified(self):
        """Gets the verified of this Tool.  # noqa: E501

        Reports whether this tool has been verified by a specific organization or individual  # noqa: E501

        :return: The verified of this Tool.  # noqa: E501
        :rtype: bool
        """
        return self._verified

    @verified.setter
    def verified(self, verified):
        """Sets the verified of this Tool.

        Reports whether this tool has been verified by a specific organization or individual  # noqa: E501

        :param verified: The verified of this Tool.  # noqa: E501
        :type: bool
        """

        self._verified = verified

    @property
    def verified_source(self):
        """Gets the verified_source of this Tool.  # noqa: E501

        Source of metadata that can support a verified tool, such as an email or URL  # noqa: E501

        :return: The verified_source of this Tool.  # noqa: E501
        :rtype: str
        """
        return self._verified_source

    @verified_source.setter
    def verified_source(self, verified_source):
        """Sets the verified_source of this Tool.

        Source of metadata that can support a verified tool, such as an email or URL  # noqa: E501

        :param verified_source: The verified_source of this Tool.  # noqa: E501
        :type: str
        """

        self._verified_source = verified_source

    @property
    def versions(self):
        """Gets the versions of this Tool.  # noqa: E501

        A list of versions for this tool  # noqa: E501

        :return: The versions of this Tool.  # noqa: E501
        :rtype: list[ToolVersion]
        """
        return self._versions

    @versions.setter
    def versions(self, versions):
        """Sets the versions of this Tool.

        A list of versions for this tool  # noqa: E501

        :param versions: The versions of this Tool.  # noqa: E501
        :type: list[ToolVersion]
        """
        if self._configuration.client_side_validation and versions is None:
            raise ValueError("Invalid value for `versions`, must not be `None`")  # noqa: E501

        self._versions = versions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Tool, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Tool):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Tool):
            return True

        return self.to_dict() != other.to_dict()
