# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class ToolDescriptor(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'descriptor': 'str',
        'type': 'str',
        'url': 'str'
    }

    attribute_map = {
        'descriptor': 'descriptor',
        'type': 'type',
        'url': 'url'
    }

    def __init__(self, descriptor=None, type=None, url=None, _configuration=None):  # noqa: E501
        """ToolDescriptor - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._descriptor = None
        self._type = None
        self._url = None
        self.discriminator = None

        if descriptor is not None:
            self.descriptor = descriptor
        self.type = type
        if url is not None:
            self.url = url

    @property
    def descriptor(self):
        """Gets the descriptor of this ToolDescriptor.  # noqa: E501

        The descriptor that represents this version of the tool.  # noqa: E501

        :return: The descriptor of this ToolDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._descriptor

    @descriptor.setter
    def descriptor(self, descriptor):
        """Sets the descriptor of this ToolDescriptor.

        The descriptor that represents this version of the tool.  # noqa: E501

        :param descriptor: The descriptor of this ToolDescriptor.  # noqa: E501
        :type: str
        """

        self._descriptor = descriptor

    @property
    def type(self):
        """Gets the type of this ToolDescriptor.  # noqa: E501


        :return: The type of this ToolDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this ToolDescriptor.


        :param type: The type of this ToolDescriptor.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["CWL", "WDL", "NFL", "SERVICE", "GXFORMAT2"]  # noqa: E501
        if (self._configuration.client_side_validation and
                type not in allowed_values):
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def url(self):
        """Gets the url of this ToolDescriptor.  # noqa: E501

        Optional url to the underlying tool descriptor, should include version information, and can include a git hash  # noqa: E501

        :return: The url of this ToolDescriptor.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this ToolDescriptor.

        Optional url to the underlying tool descriptor, should include version information, and can include a git hash  # noqa: E501

        :param url: The url of this ToolDescriptor.  # noqa: E501
        :type: str
        """

        self._url = url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ToolDescriptor, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ToolDescriptor):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ToolDescriptor):
            return True

        return self.to_dict() != other.to_dict()
