# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class ToolFile(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'file_type': 'str',
        'path': 'str'
    }

    attribute_map = {
        'file_type': 'file_type',
        'path': 'path'
    }

    def __init__(self, file_type=None, path=None, _configuration=None):  # noqa: E501
        """ToolFile - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._file_type = None
        self._path = None
        self.discriminator = None

        if file_type is not None:
            self.file_type = file_type
        if path is not None:
            self.path = path

    @property
    def file_type(self):
        """Gets the file_type of this ToolFile.  # noqa: E501


        :return: The file_type of this ToolFile.  # noqa: E501
        :rtype: str
        """
        return self._file_type

    @file_type.setter
    def file_type(self, file_type):
        """Sets the file_type of this ToolFile.


        :param file_type: The file_type of this ToolFile.  # noqa: E501
        :type: str
        """
        allowed_values = ["TEST_FILE", "PRIMARY_DESCRIPTOR", "SECONDARY_DESCRIPTOR", "CONTAINERFILE", "OTHER"]  # noqa: E501
        if (self._configuration.client_side_validation and
                file_type not in allowed_values):
            raise ValueError(
                "Invalid value for `file_type` ({0}), must be one of {1}"  # noqa: E501
                .format(file_type, allowed_values)
            )

        self._file_type = file_type

    @property
    def path(self):
        """Gets the path of this ToolFile.  # noqa: E501

        Relative path of the file.  A descriptor's path can be used with the GA4GH .../{type}/descriptor/{relative_path} endpoint  # noqa: E501

        :return: The path of this ToolFile.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this ToolFile.

        Relative path of the file.  A descriptor's path can be used with the GA4GH .../{type}/descriptor/{relative_path} endpoint  # noqa: E501

        :param path: The path of this ToolFile.  # noqa: E501
        :type: str
        """

        self._path = path

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ToolFile, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ToolFile):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ToolFile):
            return True

        return self.to_dict() != other.to_dict()
