# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class ToolV1(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'author': 'str',
        'contains': 'list[str]',
        'description': 'str',
        'id': 'str',
        'meta_version': 'str',
        'organization': 'str',
        'signed': 'bool',
        'toolclass': 'ToolClass',
        'toolname': 'str',
        'url': 'str',
        'verified': 'bool',
        'verified_source': 'str',
        'versions': 'list[ToolVersionV1]'
    }

    attribute_map = {
        'author': 'author',
        'contains': 'contains',
        'description': 'description',
        'id': 'id',
        'meta_version': 'meta-version',
        'organization': 'organization',
        'signed': 'signed',
        'toolclass': 'toolclass',
        'toolname': 'toolname',
        'url': 'url',
        'verified': 'verified',
        'verified_source': 'verified-source',
        'versions': 'versions'
    }

    def __init__(self, author=None, contains=None, description=None, id=None, meta_version=None, organization=None, signed=None, toolclass=None, toolname=None, url=None, verified=None, verified_source=None, versions=None, _configuration=None):  # noqa: E501
        """ToolV1 - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._author = None
        self._contains = None
        self._description = None
        self._id = None
        self._meta_version = None
        self._organization = None
        self._signed = None
        self._toolclass = None
        self._toolname = None
        self._url = None
        self._verified = None
        self._verified_source = None
        self._versions = None
        self.discriminator = None

        if author is not None:
            self.author = author
        if contains is not None:
            self.contains = contains
        if description is not None:
            self.description = description
        if id is not None:
            self.id = id
        if meta_version is not None:
            self.meta_version = meta_version
        if organization is not None:
            self.organization = organization
        if signed is not None:
            self.signed = signed
        if toolclass is not None:
            self.toolclass = toolclass
        if toolname is not None:
            self.toolname = toolname
        if url is not None:
            self.url = url
        if verified is not None:
            self.verified = verified
        if verified_source is not None:
            self.verified_source = verified_source
        if versions is not None:
            self.versions = versions

    @property
    def author(self):
        """Gets the author of this ToolV1.  # noqa: E501


        :return: The author of this ToolV1.  # noqa: E501
        :rtype: str
        """
        return self._author

    @author.setter
    def author(self, author):
        """Sets the author of this ToolV1.


        :param author: The author of this ToolV1.  # noqa: E501
        :type: str
        """

        self._author = author

    @property
    def contains(self):
        """Gets the contains of this ToolV1.  # noqa: E501


        :return: The contains of this ToolV1.  # noqa: E501
        :rtype: list[str]
        """
        return self._contains

    @contains.setter
    def contains(self, contains):
        """Sets the contains of this ToolV1.


        :param contains: The contains of this ToolV1.  # noqa: E501
        :type: list[str]
        """

        self._contains = contains

    @property
    def description(self):
        """Gets the description of this ToolV1.  # noqa: E501


        :return: The description of this ToolV1.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ToolV1.


        :param description: The description of this ToolV1.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def id(self):
        """Gets the id of this ToolV1.  # noqa: E501


        :return: The id of this ToolV1.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ToolV1.


        :param id: The id of this ToolV1.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def meta_version(self):
        """Gets the meta_version of this ToolV1.  # noqa: E501


        :return: The meta_version of this ToolV1.  # noqa: E501
        :rtype: str
        """
        return self._meta_version

    @meta_version.setter
    def meta_version(self, meta_version):
        """Sets the meta_version of this ToolV1.


        :param meta_version: The meta_version of this ToolV1.  # noqa: E501
        :type: str
        """

        self._meta_version = meta_version

    @property
    def organization(self):
        """Gets the organization of this ToolV1.  # noqa: E501


        :return: The organization of this ToolV1.  # noqa: E501
        :rtype: str
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        """Sets the organization of this ToolV1.


        :param organization: The organization of this ToolV1.  # noqa: E501
        :type: str
        """

        self._organization = organization

    @property
    def signed(self):
        """Gets the signed of this ToolV1.  # noqa: E501


        :return: The signed of this ToolV1.  # noqa: E501
        :rtype: bool
        """
        return self._signed

    @signed.setter
    def signed(self, signed):
        """Sets the signed of this ToolV1.


        :param signed: The signed of this ToolV1.  # noqa: E501
        :type: bool
        """

        self._signed = signed

    @property
    def toolclass(self):
        """Gets the toolclass of this ToolV1.  # noqa: E501


        :return: The toolclass of this ToolV1.  # noqa: E501
        :rtype: ToolClass
        """
        return self._toolclass

    @toolclass.setter
    def toolclass(self, toolclass):
        """Sets the toolclass of this ToolV1.


        :param toolclass: The toolclass of this ToolV1.  # noqa: E501
        :type: ToolClass
        """

        self._toolclass = toolclass

    @property
    def toolname(self):
        """Gets the toolname of this ToolV1.  # noqa: E501


        :return: The toolname of this ToolV1.  # noqa: E501
        :rtype: str
        """
        return self._toolname

    @toolname.setter
    def toolname(self, toolname):
        """Sets the toolname of this ToolV1.


        :param toolname: The toolname of this ToolV1.  # noqa: E501
        :type: str
        """

        self._toolname = toolname

    @property
    def url(self):
        """Gets the url of this ToolV1.  # noqa: E501


        :return: The url of this ToolV1.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this ToolV1.


        :param url: The url of this ToolV1.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def verified(self):
        """Gets the verified of this ToolV1.  # noqa: E501


        :return: The verified of this ToolV1.  # noqa: E501
        :rtype: bool
        """
        return self._verified

    @verified.setter
    def verified(self, verified):
        """Sets the verified of this ToolV1.


        :param verified: The verified of this ToolV1.  # noqa: E501
        :type: bool
        """

        self._verified = verified

    @property
    def verified_source(self):
        """Gets the verified_source of this ToolV1.  # noqa: E501


        :return: The verified_source of this ToolV1.  # noqa: E501
        :rtype: str
        """
        return self._verified_source

    @verified_source.setter
    def verified_source(self, verified_source):
        """Sets the verified_source of this ToolV1.


        :param verified_source: The verified_source of this ToolV1.  # noqa: E501
        :type: str
        """

        self._verified_source = verified_source

    @property
    def versions(self):
        """Gets the versions of this ToolV1.  # noqa: E501


        :return: The versions of this ToolV1.  # noqa: E501
        :rtype: list[ToolVersionV1]
        """
        return self._versions

    @versions.setter
    def versions(self, versions):
        """Sets the versions of this ToolV1.


        :param versions: The versions of this ToolV1.  # noqa: E501
        :type: list[ToolVersionV1]
        """

        self._versions = versions

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ToolV1, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ToolV1):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ToolV1):
            return True

        return self.to_dict() != other.to_dict()
