# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class ToolVersion(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'containerfile': 'bool',
        'descriptor_type': 'list[str]',
        'id': 'str',
        'image': 'str',
        'image_name': 'str',
        'meta_version': 'str',
        'name': 'str',
        'registry_url': 'str',
        'url': 'str',
        'verified': 'bool',
        'verified_source': 'str'
    }

    attribute_map = {
        'containerfile': 'containerfile',
        'descriptor_type': 'descriptor_type',
        'id': 'id',
        'image': 'image',
        'image_name': 'image_name',
        'meta_version': 'meta_version',
        'name': 'name',
        'registry_url': 'registry_url',
        'url': 'url',
        'verified': 'verified',
        'verified_source': 'verified_source'
    }

    def __init__(self, containerfile=None, descriptor_type=None, id=None, image=None, image_name=None, meta_version=None, name=None, registry_url=None, url=None, verified=None, verified_source=None, _configuration=None):  # noqa: E501
        """ToolVersion - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._containerfile = None
        self._descriptor_type = None
        self._id = None
        self._image = None
        self._image_name = None
        self._meta_version = None
        self._name = None
        self._registry_url = None
        self._url = None
        self._verified = None
        self._verified_source = None
        self.discriminator = None

        if containerfile is not None:
            self.containerfile = containerfile
        if descriptor_type is not None:
            self.descriptor_type = descriptor_type
        self.id = id
        if image is not None:
            self.image = image
        if image_name is not None:
            self.image_name = image_name
        if meta_version is not None:
            self.meta_version = meta_version
        if name is not None:
            self.name = name
        if registry_url is not None:
            self.registry_url = registry_url
        self.url = url
        if verified is not None:
            self.verified = verified
        if verified_source is not None:
            self.verified_source = verified_source

    @property
    def containerfile(self):
        """Gets the containerfile of this ToolVersion.  # noqa: E501

        Reports if this tool has a containerfile available.  # noqa: E501

        :return: The containerfile of this ToolVersion.  # noqa: E501
        :rtype: bool
        """
        return self._containerfile

    @containerfile.setter
    def containerfile(self, containerfile):
        """Sets the containerfile of this ToolVersion.

        Reports if this tool has a containerfile available.  # noqa: E501

        :param containerfile: The containerfile of this ToolVersion.  # noqa: E501
        :type: bool
        """

        self._containerfile = containerfile

    @property
    def descriptor_type(self):
        """Gets the descriptor_type of this ToolVersion.  # noqa: E501

        The type (or types) of descriptors available.  # noqa: E501

        :return: The descriptor_type of this ToolVersion.  # noqa: E501
        :rtype: list[str]
        """
        return self._descriptor_type

    @descriptor_type.setter
    def descriptor_type(self, descriptor_type):
        """Sets the descriptor_type of this ToolVersion.

        The type (or types) of descriptors available.  # noqa: E501

        :param descriptor_type: The descriptor_type of this ToolVersion.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["CWL", "WDL", "NFL", "SERVICE", "GXFORMAT2"]  # noqa: E501
        if (self._configuration.client_side_validation and
                not set(descriptor_type).issubset(set(allowed_values))):  # noqa: E501
            raise ValueError(
                "Invalid values for `descriptor_type` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(descriptor_type) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._descriptor_type = descriptor_type

    @property
    def id(self):
        """Gets the id of this ToolVersion.  # noqa: E501

        An identifier of the version of this tool for this particular tool registry  # noqa: E501

        :return: The id of this ToolVersion.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ToolVersion.

        An identifier of the version of this tool for this particular tool registry  # noqa: E501

        :param id: The id of this ToolVersion.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def image(self):
        """Gets the image of this ToolVersion.  # noqa: E501

        The docker path to the image (and version) for this tool  # noqa: E501

        :return: The image of this ToolVersion.  # noqa: E501
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this ToolVersion.

        The docker path to the image (and version) for this tool  # noqa: E501

        :param image: The image of this ToolVersion.  # noqa: E501
        :type: str
        """

        self._image = image

    @property
    def image_name(self):
        """Gets the image_name of this ToolVersion.  # noqa: E501

        Used in conjunction with a registry_url if provided to locate images  # noqa: E501

        :return: The image_name of this ToolVersion.  # noqa: E501
        :rtype: str
        """
        return self._image_name

    @image_name.setter
    def image_name(self, image_name):
        """Sets the image_name of this ToolVersion.

        Used in conjunction with a registry_url if provided to locate images  # noqa: E501

        :param image_name: The image_name of this ToolVersion.  # noqa: E501
        :type: str
        """

        self._image_name = image_name

    @property
    def meta_version(self):
        """Gets the meta_version of this ToolVersion.  # noqa: E501

        The version of this tool version in the registry. Iterates when fields like the description, author, etc. are updated.  # noqa: E501

        :return: The meta_version of this ToolVersion.  # noqa: E501
        :rtype: str
        """
        return self._meta_version

    @meta_version.setter
    def meta_version(self, meta_version):
        """Sets the meta_version of this ToolVersion.

        The version of this tool version in the registry. Iterates when fields like the description, author, etc. are updated.  # noqa: E501

        :param meta_version: The meta_version of this ToolVersion.  # noqa: E501
        :type: str
        """

        self._meta_version = meta_version

    @property
    def name(self):
        """Gets the name of this ToolVersion.  # noqa: E501

        The name of the version.  # noqa: E501

        :return: The name of this ToolVersion.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ToolVersion.

        The name of the version.  # noqa: E501

        :param name: The name of this ToolVersion.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def registry_url(self):
        """Gets the registry_url of this ToolVersion.  # noqa: E501

        A URL to a Singularity registry is provided when a specific type of image does not use ids in the Docker format. Used along with image_name to locate a specific image.  # noqa: E501

        :return: The registry_url of this ToolVersion.  # noqa: E501
        :rtype: str
        """
        return self._registry_url

    @registry_url.setter
    def registry_url(self, registry_url):
        """Sets the registry_url of this ToolVersion.

        A URL to a Singularity registry is provided when a specific type of image does not use ids in the Docker format. Used along with image_name to locate a specific image.  # noqa: E501

        :param registry_url: The registry_url of this ToolVersion.  # noqa: E501
        :type: str
        """

        self._registry_url = registry_url

    @property
    def url(self):
        """Gets the url of this ToolVersion.  # noqa: E501

        The URL for this tool in this registry  # noqa: E501

        :return: The url of this ToolVersion.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this ToolVersion.

        The URL for this tool in this registry  # noqa: E501

        :param url: The url of this ToolVersion.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and url is None:
            raise ValueError("Invalid value for `url`, must not be `None`")  # noqa: E501

        self._url = url

    @property
    def verified(self):
        """Gets the verified of this ToolVersion.  # noqa: E501

        Reports whether this tool has been verified by a specific organization or individual  # noqa: E501

        :return: The verified of this ToolVersion.  # noqa: E501
        :rtype: bool
        """
        return self._verified

    @verified.setter
    def verified(self, verified):
        """Sets the verified of this ToolVersion.

        Reports whether this tool has been verified by a specific organization or individual  # noqa: E501

        :param verified: The verified of this ToolVersion.  # noqa: E501
        :type: bool
        """

        self._verified = verified

    @property
    def verified_source(self):
        """Gets the verified_source of this ToolVersion.  # noqa: E501

        Source of metadata that can support a verified tool, such as an email or URL  # noqa: E501

        :return: The verified_source of this ToolVersion.  # noqa: E501
        :rtype: str
        """
        return self._verified_source

    @verified_source.setter
    def verified_source(self, verified_source):
        """Sets the verified_source of this ToolVersion.

        Source of metadata that can support a verified tool, such as an email or URL  # noqa: E501

        :param verified_source: The verified_source of this ToolVersion.  # noqa: E501
        :type: str
        """

        self._verified_source = verified_source

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ToolVersion, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ToolVersion):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ToolVersion):
            return True

        return self.to_dict() != other.to_dict()
