# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class ToolVersionV1(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'descriptor_type': 'list[str]',
        'dockerfile': 'bool',
        'id': 'str',
        'image': 'str',
        'meta_version': 'str',
        'name': 'str',
        'url': 'str',
        'verified': 'bool',
        'verified_source': 'str'
    }

    attribute_map = {
        'descriptor_type': 'descriptor-type',
        'dockerfile': 'dockerfile',
        'id': 'id',
        'image': 'image',
        'meta_version': 'meta-version',
        'name': 'name',
        'url': 'url',
        'verified': 'verified',
        'verified_source': 'verified-source'
    }

    def __init__(self, descriptor_type=None, dockerfile=None, id=None, image=None, meta_version=None, name=None, url=None, verified=None, verified_source=None, _configuration=None):  # noqa: E501
        """ToolVersionV1 - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._descriptor_type = None
        self._dockerfile = None
        self._id = None
        self._image = None
        self._meta_version = None
        self._name = None
        self._url = None
        self._verified = None
        self._verified_source = None
        self.discriminator = None

        if descriptor_type is not None:
            self.descriptor_type = descriptor_type
        if dockerfile is not None:
            self.dockerfile = dockerfile
        if id is not None:
            self.id = id
        if image is not None:
            self.image = image
        if meta_version is not None:
            self.meta_version = meta_version
        if name is not None:
            self.name = name
        if url is not None:
            self.url = url
        if verified is not None:
            self.verified = verified
        if verified_source is not None:
            self.verified_source = verified_source

    @property
    def descriptor_type(self):
        """Gets the descriptor_type of this ToolVersionV1.  # noqa: E501


        :return: The descriptor_type of this ToolVersionV1.  # noqa: E501
        :rtype: list[str]
        """
        return self._descriptor_type

    @descriptor_type.setter
    def descriptor_type(self, descriptor_type):
        """Sets the descriptor_type of this ToolVersionV1.


        :param descriptor_type: The descriptor_type of this ToolVersionV1.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["CWL", "WDL"]  # noqa: E501
        if (self._configuration.client_side_validation and
                not set(descriptor_type).issubset(set(allowed_values))):  # noqa: E501
            raise ValueError(
                "Invalid values for `descriptor_type` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(descriptor_type) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._descriptor_type = descriptor_type

    @property
    def dockerfile(self):
        """Gets the dockerfile of this ToolVersionV1.  # noqa: E501


        :return: The dockerfile of this ToolVersionV1.  # noqa: E501
        :rtype: bool
        """
        return self._dockerfile

    @dockerfile.setter
    def dockerfile(self, dockerfile):
        """Sets the dockerfile of this ToolVersionV1.


        :param dockerfile: The dockerfile of this ToolVersionV1.  # noqa: E501
        :type: bool
        """

        self._dockerfile = dockerfile

    @property
    def id(self):
        """Gets the id of this ToolVersionV1.  # noqa: E501


        :return: The id of this ToolVersionV1.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ToolVersionV1.


        :param id: The id of this ToolVersionV1.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def image(self):
        """Gets the image of this ToolVersionV1.  # noqa: E501


        :return: The image of this ToolVersionV1.  # noqa: E501
        :rtype: str
        """
        return self._image

    @image.setter
    def image(self, image):
        """Sets the image of this ToolVersionV1.


        :param image: The image of this ToolVersionV1.  # noqa: E501
        :type: str
        """

        self._image = image

    @property
    def meta_version(self):
        """Gets the meta_version of this ToolVersionV1.  # noqa: E501


        :return: The meta_version of this ToolVersionV1.  # noqa: E501
        :rtype: str
        """
        return self._meta_version

    @meta_version.setter
    def meta_version(self, meta_version):
        """Sets the meta_version of this ToolVersionV1.


        :param meta_version: The meta_version of this ToolVersionV1.  # noqa: E501
        :type: str
        """

        self._meta_version = meta_version

    @property
    def name(self):
        """Gets the name of this ToolVersionV1.  # noqa: E501


        :return: The name of this ToolVersionV1.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ToolVersionV1.


        :param name: The name of this ToolVersionV1.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def url(self):
        """Gets the url of this ToolVersionV1.  # noqa: E501


        :return: The url of this ToolVersionV1.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this ToolVersionV1.


        :param url: The url of this ToolVersionV1.  # noqa: E501
        :type: str
        """

        self._url = url

    @property
    def verified(self):
        """Gets the verified of this ToolVersionV1.  # noqa: E501


        :return: The verified of this ToolVersionV1.  # noqa: E501
        :rtype: bool
        """
        return self._verified

    @verified.setter
    def verified(self, verified):
        """Sets the verified of this ToolVersionV1.


        :param verified: The verified of this ToolVersionV1.  # noqa: E501
        :type: bool
        """

        self._verified = verified

    @property
    def verified_source(self):
        """Gets the verified_source of this ToolVersionV1.  # noqa: E501


        :return: The verified_source of this ToolVersionV1.  # noqa: E501
        :rtype: str
        """
        return self._verified_source

    @verified_source.setter
    def verified_source(self, verified_source):
        """Sets the verified_source of this ToolVersionV1.


        :param verified_source: The verified_source of this ToolVersionV1.  # noqa: E501
        :type: str
        """

        self._verified_source = verified_source

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ToolVersionV1, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ToolVersionV1):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ToolVersionV1):
            return True

        return self.to_dict() != other.to_dict()
