# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class User(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'orcid': 'str',
        'privacy_policy_version': 'str',
        'tosversion': 'str',
        'user_profiles': 'dict(str, Profile)',
        'username': 'str',
        'is_admin': 'bool',
        'avatar_url': 'str',
        'name': 'str',
        'curator': 'bool',
        'setup_complete': 'bool',
        'tosacceptance_date': 'int',
        'privacy_policy_version_acceptance_date': 'int'
    }

    attribute_map = {
        'id': 'id',
        'orcid': 'orcid',
        'privacy_policy_version': 'privacyPolicyVersion',
        'tosversion': 'tosversion',
        'user_profiles': 'userProfiles',
        'username': 'username',
        'is_admin': 'isAdmin',
        'avatar_url': 'avatarUrl',
        'name': 'name',
        'curator': 'curator',
        'setup_complete': 'setupComplete',
        'tosacceptance_date': 'tosacceptanceDate',
        'privacy_policy_version_acceptance_date': 'privacyPolicyVersionAcceptanceDate'
    }

    def __init__(self, id=None, orcid=None, privacy_policy_version=None, tosversion=None, user_profiles=None, username=None, is_admin=None, avatar_url=None, name=None, curator=None, setup_complete=None, tosacceptance_date=None, privacy_policy_version_acceptance_date=None, _configuration=None):  # noqa: E501
        """User - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._id = None
        self._orcid = None
        self._privacy_policy_version = None
        self._tosversion = None
        self._user_profiles = None
        self._username = None
        self._is_admin = None
        self._avatar_url = None
        self._name = None
        self._curator = None
        self._setup_complete = None
        self._tosacceptance_date = None
        self._privacy_policy_version_acceptance_date = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if orcid is not None:
            self.orcid = orcid
        if privacy_policy_version is not None:
            self.privacy_policy_version = privacy_policy_version
        if tosversion is not None:
            self.tosversion = tosversion
        if user_profiles is not None:
            self.user_profiles = user_profiles
        if username is not None:
            self.username = username
        self.is_admin = is_admin
        if avatar_url is not None:
            self.avatar_url = avatar_url
        if name is not None:
            self.name = name
        self.curator = curator
        self.setup_complete = setup_complete
        if tosacceptance_date is not None:
            self.tosacceptance_date = tosacceptance_date
        if privacy_policy_version_acceptance_date is not None:
            self.privacy_policy_version_acceptance_date = privacy_policy_version_acceptance_date

    @property
    def id(self):
        """Gets the id of this User.  # noqa: E501

        Implementation specific ID for the container in this web service  # noqa: E501

        :return: The id of this User.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this User.

        Implementation specific ID for the container in this web service  # noqa: E501

        :param id: The id of this User.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def orcid(self):
        """Gets the orcid of this User.  # noqa: E501


        :return: The orcid of this User.  # noqa: E501
        :rtype: str
        """
        return self._orcid

    @orcid.setter
    def orcid(self, orcid):
        """Sets the orcid of this User.


        :param orcid: The orcid of this User.  # noqa: E501
        :type: str
        """

        self._orcid = orcid

    @property
    def privacy_policy_version(self):
        """Gets the privacy_policy_version of this User.  # noqa: E501

        Indicates which version of the privacy policy the user has accepted  # noqa: E501

        :return: The privacy_policy_version of this User.  # noqa: E501
        :rtype: str
        """
        return self._privacy_policy_version

    @privacy_policy_version.setter
    def privacy_policy_version(self, privacy_policy_version):
        """Sets the privacy_policy_version of this User.

        Indicates which version of the privacy policy the user has accepted  # noqa: E501

        :param privacy_policy_version: The privacy_policy_version of this User.  # noqa: E501
        :type: str
        """
        allowed_values = ["NONE", "PRIVACY_POLICY_VERSION_2_5"]  # noqa: E501
        if (self._configuration.client_side_validation and
                privacy_policy_version not in allowed_values):
            raise ValueError(
                "Invalid value for `privacy_policy_version` ({0}), must be one of {1}"  # noqa: E501
                .format(privacy_policy_version, allowed_values)
            )

        self._privacy_policy_version = privacy_policy_version

    @property
    def tosversion(self):
        """Gets the tosversion of this User.  # noqa: E501


        :return: The tosversion of this User.  # noqa: E501
        :rtype: str
        """
        return self._tosversion

    @tosversion.setter
    def tosversion(self, tosversion):
        """Sets the tosversion of this User.


        :param tosversion: The tosversion of this User.  # noqa: E501
        :type: str
        """
        allowed_values = ["NONE", "TOS_VERSION_1", "TOS_VERSION_2"]  # noqa: E501
        if (self._configuration.client_side_validation and
                tosversion not in allowed_values):
            raise ValueError(
                "Invalid value for `tosversion` ({0}), must be one of {1}"  # noqa: E501
                .format(tosversion, allowed_values)
            )

        self._tosversion = tosversion

    @property
    def user_profiles(self):
        """Gets the user_profiles of this User.  # noqa: E501

        Profile information of the user retrieved from 3rd party sites (GitHub, Google, etc)  # noqa: E501

        :return: The user_profiles of this User.  # noqa: E501
        :rtype: dict(str, Profile)
        """
        return self._user_profiles

    @user_profiles.setter
    def user_profiles(self, user_profiles):
        """Sets the user_profiles of this User.

        Profile information of the user retrieved from 3rd party sites (GitHub, Google, etc)  # noqa: E501

        :param user_profiles: The user_profiles of this User.  # noqa: E501
        :type: dict(str, Profile)
        """

        self._user_profiles = user_profiles

    @property
    def username(self):
        """Gets the username of this User.  # noqa: E501

        Username on dockstore  # noqa: E501

        :return: The username of this User.  # noqa: E501
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """Sets the username of this User.

        Username on dockstore  # noqa: E501

        :param username: The username of this User.  # noqa: E501
        :type: str
        """

        self._username = username

    @property
    def is_admin(self):
        """Gets the is_admin of this User.  # noqa: E501

        Indicates whether this user is an admin  # noqa: E501

        :return: The is_admin of this User.  # noqa: E501
        :rtype: bool
        """
        return self._is_admin

    @is_admin.setter
    def is_admin(self, is_admin):
        """Sets the is_admin of this User.

        Indicates whether this user is an admin  # noqa: E501

        :param is_admin: The is_admin of this User.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and is_admin is None:
            raise ValueError("Invalid value for `is_admin`, must not be `None`")  # noqa: E501

        self._is_admin = is_admin

    @property
    def avatar_url(self):
        """Gets the avatar_url of this User.  # noqa: E501

        URL of user avatar on GitHub/Google that can be selected by the user  # noqa: E501

        :return: The avatar_url of this User.  # noqa: E501
        :rtype: str
        """
        return self._avatar_url

    @avatar_url.setter
    def avatar_url(self, avatar_url):
        """Sets the avatar_url of this User.

        URL of user avatar on GitHub/Google that can be selected by the user  # noqa: E501

        :param avatar_url: The avatar_url of this User.  # noqa: E501
        :type: str
        """

        self._avatar_url = avatar_url

    @property
    def name(self):
        """Gets the name of this User.  # noqa: E501


        :return: The name of this User.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this User.


        :param name: The name of this User.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def curator(self):
        """Gets the curator of this User.  # noqa: E501

        Indicates whether this user is a curator  # noqa: E501

        :return: The curator of this User.  # noqa: E501
        :rtype: bool
        """
        return self._curator

    @curator.setter
    def curator(self, curator):
        """Sets the curator of this User.

        Indicates whether this user is a curator  # noqa: E501

        :param curator: The curator of this User.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and curator is None:
            raise ValueError("Invalid value for `curator`, must not be `None`")  # noqa: E501

        self._curator = curator

    @property
    def setup_complete(self):
        """Gets the setup_complete of this User.  # noqa: E501

        Indicates whether this user has accepted their username  # noqa: E501

        :return: The setup_complete of this User.  # noqa: E501
        :rtype: bool
        """
        return self._setup_complete

    @setup_complete.setter
    def setup_complete(self, setup_complete):
        """Sets the setup_complete of this User.

        Indicates whether this user has accepted their username  # noqa: E501

        :param setup_complete: The setup_complete of this User.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and setup_complete is None:
            raise ValueError("Invalid value for `setup_complete`, must not be `None`")  # noqa: E501

        self._setup_complete = setup_complete

    @property
    def tosacceptance_date(self):
        """Gets the tosacceptance_date of this User.  # noqa: E501

        Time TOS was accepted  # noqa: E501

        :return: The tosacceptance_date of this User.  # noqa: E501
        :rtype: int
        """
        return self._tosacceptance_date

    @tosacceptance_date.setter
    def tosacceptance_date(self, tosacceptance_date):
        """Sets the tosacceptance_date of this User.

        Time TOS was accepted  # noqa: E501

        :param tosacceptance_date: The tosacceptance_date of this User.  # noqa: E501
        :type: int
        """

        self._tosacceptance_date = tosacceptance_date

    @property
    def privacy_policy_version_acceptance_date(self):
        """Gets the privacy_policy_version_acceptance_date of this User.  # noqa: E501

        Time privacy policy was accepted  # noqa: E501

        :return: The privacy_policy_version_acceptance_date of this User.  # noqa: E501
        :rtype: int
        """
        return self._privacy_policy_version_acceptance_date

    @privacy_policy_version_acceptance_date.setter
    def privacy_policy_version_acceptance_date(self, privacy_policy_version_acceptance_date):
        """Sets the privacy_policy_version_acceptance_date of this User.

        Time privacy policy was accepted  # noqa: E501

        :param privacy_policy_version_acceptance_date: The privacy_policy_version_acceptance_date of this User.  # noqa: E501
        :type: int
        """

        self._privacy_policy_version_acceptance_date = privacy_policy_version_acceptance_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(User, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, User):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, User):
            return True

        return self.to_dict() != other.to_dict()
