# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Validation(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'type': 'str',
        'valid': 'bool',
        'message': 'str'
    }

    attribute_map = {
        'id': 'id',
        'type': 'type',
        'valid': 'valid',
        'message': 'message'
    }

    def __init__(self, id=None, type=None, valid=None, message=None, _configuration=None):  # noqa: E501
        """Validation - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._id = None
        self._type = None
        self._valid = None
        self._message = None
        self.discriminator = None

        self.id = id
        self.type = type
        self.valid = valid
        self.message = message

    @property
    def id(self):
        """Gets the id of this Validation.  # noqa: E501

        Implementation specific ID for the source file in this web service  # noqa: E501

        :return: The id of this Validation.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Validation.

        Implementation specific ID for the source file in this web service  # noqa: E501

        :param id: The id of this Validation.  # noqa: E501
        :type: int
        """
        if self._configuration.client_side_validation and id is None:
            raise ValueError("Invalid value for `id`, must not be `None`")  # noqa: E501

        self._id = id

    @property
    def type(self):
        """Gets the type of this Validation.  # noqa: E501

        Enumerates the type of file  # noqa: E501

        :return: The type of this Validation.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Validation.

        Enumerates the type of file  # noqa: E501

        :param type: The type of this Validation.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and type is None:
            raise ValueError("Invalid value for `type`, must not be `None`")  # noqa: E501
        allowed_values = ["DOCKSTORE_CWL", "DOCKSTORE_WDL", "DOCKERFILE", "CWL_TEST_JSON", "WDL_TEST_JSON", "NEXTFLOW", "NEXTFLOW_CONFIG", "NEXTFLOW_TEST_PARAMS", "DOCKSTORE_YML", "DOCKSTORE_SERVICE_YML", "DOCKSTORE_SERVICE_TEST_JSON", "DOCKSTORE_SERVICE_OTHER", "DOCKSTORE_GXFORMAT2", "GXFORMAT2_TEST_FILE", "DOCKSTORE_SWL", "SWL_TEST_JSON"]  # noqa: E501
        if (self._configuration.client_side_validation and
                type not in allowed_values):
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def valid(self):
        """Gets the valid of this Validation.  # noqa: E501

        Is the file type valid  # noqa: E501

        :return: The valid of this Validation.  # noqa: E501
        :rtype: bool
        """
        return self._valid

    @valid.setter
    def valid(self, valid):
        """Sets the valid of this Validation.

        Is the file type valid  # noqa: E501

        :param valid: The valid of this Validation.  # noqa: E501
        :type: bool
        """
        if self._configuration.client_side_validation and valid is None:
            raise ValueError("Invalid value for `valid`, must not be `None`")  # noqa: E501

        self._valid = valid

    @property
    def message(self):
        """Gets the message of this Validation.  # noqa: E501

        Mapping of filepath to validation message  # noqa: E501

        :return: The message of this Validation.  # noqa: E501
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """Sets the message of this Validation.

        Mapping of filepath to validation message  # noqa: E501

        :param message: The message of this Validation.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and message is None:
            raise ValueError("Invalid value for `message`, must not be `None`")  # noqa: E501

        self._message = message

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Validation, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Validation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Validation):
            return True

        return self.to_dict() != other.to_dict()
