# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class VersionMetadata(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'description': 'str',
        'id': 'int',
        'orcid_put_code': 'str',
        'parsed_information_set': 'list[ParsedInformation]',
        'public_accessible_test_parameter_file': 'bool'
    }

    attribute_map = {
        'description': 'description',
        'id': 'id',
        'orcid_put_code': 'orcidPutCode',
        'parsed_information_set': 'parsedInformationSet',
        'public_accessible_test_parameter_file': 'publicAccessibleTestParameterFile'
    }

    def __init__(self, description=None, id=None, orcid_put_code=None, parsed_information_set=None, public_accessible_test_parameter_file=None, _configuration=None):  # noqa: E501
        """VersionMetadata - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._description = None
        self._id = None
        self._orcid_put_code = None
        self._parsed_information_set = None
        self._public_accessible_test_parameter_file = None
        self.discriminator = None

        if description is not None:
            self.description = description
        if id is not None:
            self.id = id
        if orcid_put_code is not None:
            self.orcid_put_code = orcid_put_code
        if parsed_information_set is not None:
            self.parsed_information_set = parsed_information_set
        if public_accessible_test_parameter_file is not None:
            self.public_accessible_test_parameter_file = public_accessible_test_parameter_file

    @property
    def description(self):
        """Gets the description of this VersionMetadata.  # noqa: E501

        This is a human-readable description of this container and what it is trying to accomplish, required GA4GH  # noqa: E501

        :return: The description of this VersionMetadata.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this VersionMetadata.

        This is a human-readable description of this container and what it is trying to accomplish, required GA4GH  # noqa: E501

        :param description: The description of this VersionMetadata.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def id(self):
        """Gets the id of this VersionMetadata.  # noqa: E501


        :return: The id of this VersionMetadata.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this VersionMetadata.


        :param id: The id of this VersionMetadata.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def orcid_put_code(self):
        """Gets the orcid_put_code of this VersionMetadata.  # noqa: E501

        The presence of the put code indicates the version was exported to ORCID.  # noqa: E501

        :return: The orcid_put_code of this VersionMetadata.  # noqa: E501
        :rtype: str
        """
        return self._orcid_put_code

    @orcid_put_code.setter
    def orcid_put_code(self, orcid_put_code):
        """Sets the orcid_put_code of this VersionMetadata.

        The presence of the put code indicates the version was exported to ORCID.  # noqa: E501

        :param orcid_put_code: The orcid_put_code of this VersionMetadata.  # noqa: E501
        :type: str
        """

        self._orcid_put_code = orcid_put_code

    @property
    def parsed_information_set(self):
        """Gets the parsed_information_set of this VersionMetadata.  # noqa: E501


        :return: The parsed_information_set of this VersionMetadata.  # noqa: E501
        :rtype: list[ParsedInformation]
        """
        return self._parsed_information_set

    @parsed_information_set.setter
    def parsed_information_set(self, parsed_information_set):
        """Sets the parsed_information_set of this VersionMetadata.


        :param parsed_information_set: The parsed_information_set of this VersionMetadata.  # noqa: E501
        :type: list[ParsedInformation]
        """

        self._parsed_information_set = parsed_information_set

    @property
    def public_accessible_test_parameter_file(self):
        """Gets the public_accessible_test_parameter_file of this VersionMetadata.  # noqa: E501


        :return: The public_accessible_test_parameter_file of this VersionMetadata.  # noqa: E501
        :rtype: bool
        """
        return self._public_accessible_test_parameter_file

    @public_accessible_test_parameter_file.setter
    def public_accessible_test_parameter_file(self, public_accessible_test_parameter_file):
        """Sets the public_accessible_test_parameter_file of this VersionMetadata.


        :param public_accessible_test_parameter_file: The public_accessible_test_parameter_file of this VersionMetadata.  # noqa: E501
        :type: bool
        """

        self._public_accessible_test_parameter_file = public_accessible_test_parameter_file

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(VersionMetadata, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, VersionMetadata):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, VersionMetadata):
            return True

        return self.to_dict() != other.to_dict()
