# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class Workflow(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'aliases': 'dict(str, Alias)',
        'db_create_date': 'int',
        'db_update_date': 'int',
        'forum_url': 'str',
        'has_checker': 'bool',
        'id': 'int',
        'is_checker': 'bool',
        'last_modified_date': 'int',
        'license_information': 'LicenseInformation',
        'orcid_put_code': 'str',
        'parent_entry': 'Entry',
        'topic_id': 'int',
        'author': 'str',
        'description': 'str',
        'labels': 'list[Label]',
        'users': 'list[User]',
        'starred_users': 'list[User]',
        'email': 'str',
        'default_version': 'str',
        'is_published': 'bool',
        'last_modified': 'int',
        'last_updated': 'int',
        'git_url': 'str',
        'checker_id': 'int',
        'mode': 'str',
        'concept_doi': 'str',
        'workflow_name': 'str',
        'input_file_formats': 'list[FileFormat]',
        'organization': 'str',
        'output_file_formats': 'list[FileFormat]',
        'repository': 'str',
        'source_control': 'str',
        'descriptor_type': 'str',
        'workflow_path': 'str',
        'default_test_parameter_file_path': 'str',
        'workflow_versions': 'list[WorkflowVersion]',
        'descriptor_type_subclass': 'str',
        'full_workflow_path': 'str',
        'path': 'str',
        'source_control_provider': 'str'
    }

    attribute_map = {
        'aliases': 'aliases',
        'db_create_date': 'dbCreateDate',
        'db_update_date': 'dbUpdateDate',
        'forum_url': 'forumUrl',
        'has_checker': 'has_checker',
        'id': 'id',
        'is_checker': 'isChecker',
        'last_modified_date': 'last_modified_date',
        'license_information': 'licenseInformation',
        'orcid_put_code': 'orcidPutCode',
        'parent_entry': 'parentEntry',
        'topic_id': 'topicId',
        'author': 'author',
        'description': 'description',
        'labels': 'labels',
        'users': 'users',
        'starred_users': 'starredUsers',
        'email': 'email',
        'default_version': 'defaultVersion',
        'is_published': 'is_published',
        'last_modified': 'last_modified',
        'last_updated': 'lastUpdated',
        'git_url': 'gitUrl',
        'checker_id': 'checker_id',
        'mode': 'mode',
        'concept_doi': 'conceptDoi',
        'workflow_name': 'workflowName',
        'input_file_formats': 'input_file_formats',
        'organization': 'organization',
        'output_file_formats': 'output_file_formats',
        'repository': 'repository',
        'source_control': 'sourceControl',
        'descriptor_type': 'descriptorType',
        'workflow_path': 'workflow_path',
        'default_test_parameter_file_path': 'defaultTestParameterFilePath',
        'workflow_versions': 'workflowVersions',
        'descriptor_type_subclass': 'descriptorTypeSubclass',
        'full_workflow_path': 'full_workflow_path',
        'path': 'path',
        'source_control_provider': 'source_control_provider'
    }

    discriminator_value_class_map = {
        'AppTool': 'AppTool',
        'Service': 'Service',
        'BioWorkflow': 'BioWorkflow'
    }

    def __init__(self, aliases=None, db_create_date=None, db_update_date=None, forum_url=None, has_checker=None, id=None, is_checker=None, last_modified_date=None, license_information=None, orcid_put_code=None, parent_entry=None, topic_id=None, author=None, description=None, labels=None, users=None, starred_users=None, email=None, default_version=None, is_published=None, last_modified=None, last_updated=None, git_url=None, checker_id=None, mode=None, concept_doi=None, workflow_name=None, input_file_formats=None, organization=None, output_file_formats=None, repository=None, source_control=None, descriptor_type=None, workflow_path=None, default_test_parameter_file_path=None, workflow_versions=None, descriptor_type_subclass=None, full_workflow_path=None, path=None, source_control_provider=None, _configuration=None):  # noqa: E501
        """Workflow - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._aliases = None
        self._db_create_date = None
        self._db_update_date = None
        self._forum_url = None
        self._has_checker = None
        self._id = None
        self._is_checker = None
        self._last_modified_date = None
        self._license_information = None
        self._orcid_put_code = None
        self._parent_entry = None
        self._topic_id = None
        self._author = None
        self._description = None
        self._labels = None
        self._users = None
        self._starred_users = None
        self._email = None
        self._default_version = None
        self._is_published = None
        self._last_modified = None
        self._last_updated = None
        self._git_url = None
        self._checker_id = None
        self._mode = None
        self._concept_doi = None
        self._workflow_name = None
        self._input_file_formats = None
        self._organization = None
        self._output_file_formats = None
        self._repository = None
        self._source_control = None
        self._descriptor_type = None
        self._workflow_path = None
        self._default_test_parameter_file_path = None
        self._workflow_versions = None
        self._descriptor_type_subclass = None
        self._full_workflow_path = None
        self._path = None
        self._source_control_provider = None
        self.discriminator = 'type'

        if aliases is not None:
            self.aliases = aliases
        if db_create_date is not None:
            self.db_create_date = db_create_date
        if db_update_date is not None:
            self.db_update_date = db_update_date
        if forum_url is not None:
            self.forum_url = forum_url
        if has_checker is not None:
            self.has_checker = has_checker
        if id is not None:
            self.id = id
        if is_checker is not None:
            self.is_checker = is_checker
        if last_modified_date is not None:
            self.last_modified_date = last_modified_date
        if license_information is not None:
            self.license_information = license_information
        if orcid_put_code is not None:
            self.orcid_put_code = orcid_put_code
        if parent_entry is not None:
            self.parent_entry = parent_entry
        if topic_id is not None:
            self.topic_id = topic_id
        if author is not None:
            self.author = author
        if description is not None:
            self.description = description
        if labels is not None:
            self.labels = labels
        if users is not None:
            self.users = users
        if starred_users is not None:
            self.starred_users = starred_users
        if email is not None:
            self.email = email
        if default_version is not None:
            self.default_version = default_version
        if is_published is not None:
            self.is_published = is_published
        if last_modified is not None:
            self.last_modified = last_modified
        if last_updated is not None:
            self.last_updated = last_updated
        self.git_url = git_url
        if checker_id is not None:
            self.checker_id = checker_id
        self.mode = mode
        if concept_doi is not None:
            self.concept_doi = concept_doi
        if workflow_name is not None:
            self.workflow_name = workflow_name
        if input_file_formats is not None:
            self.input_file_formats = input_file_formats
        self.organization = organization
        if output_file_formats is not None:
            self.output_file_formats = output_file_formats
        self.repository = repository
        self.source_control = source_control
        self.descriptor_type = descriptor_type
        self.workflow_path = workflow_path
        self.default_test_parameter_file_path = default_test_parameter_file_path
        if workflow_versions is not None:
            self.workflow_versions = workflow_versions
        self.descriptor_type_subclass = descriptor_type_subclass
        if full_workflow_path is not None:
            self.full_workflow_path = full_workflow_path
        if path is not None:
            self.path = path
        if source_control_provider is not None:
            self.source_control_provider = source_control_provider

    @property
    def aliases(self):
        """Gets the aliases of this Workflow.  # noqa: E501

        aliases can be used as an alternate unique id for entries  # noqa: E501

        :return: The aliases of this Workflow.  # noqa: E501
        :rtype: dict(str, Alias)
        """
        return self._aliases

    @aliases.setter
    def aliases(self, aliases):
        """Sets the aliases of this Workflow.

        aliases can be used as an alternate unique id for entries  # noqa: E501

        :param aliases: The aliases of this Workflow.  # noqa: E501
        :type: dict(str, Alias)
        """

        self._aliases = aliases

    @property
    def db_create_date(self):
        """Gets the db_create_date of this Workflow.  # noqa: E501


        :return: The db_create_date of this Workflow.  # noqa: E501
        :rtype: int
        """
        return self._db_create_date

    @db_create_date.setter
    def db_create_date(self, db_create_date):
        """Sets the db_create_date of this Workflow.


        :param db_create_date: The db_create_date of this Workflow.  # noqa: E501
        :type: int
        """

        self._db_create_date = db_create_date

    @property
    def db_update_date(self):
        """Gets the db_update_date of this Workflow.  # noqa: E501


        :return: The db_update_date of this Workflow.  # noqa: E501
        :rtype: int
        """
        return self._db_update_date

    @db_update_date.setter
    def db_update_date(self, db_update_date):
        """Sets the db_update_date of this Workflow.


        :param db_update_date: The db_update_date of this Workflow.  # noqa: E501
        :type: int
        """

        self._db_update_date = db_update_date

    @property
    def forum_url(self):
        """Gets the forum_url of this Workflow.  # noqa: E501

        This is a link to a forum or discussion board  # noqa: E501

        :return: The forum_url of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._forum_url

    @forum_url.setter
    def forum_url(self, forum_url):
        """Sets the forum_url of this Workflow.

        This is a link to a forum or discussion board  # noqa: E501

        :param forum_url: The forum_url of this Workflow.  # noqa: E501
        :type: str
        """
        if (self._configuration.client_side_validation and
                forum_url is not None and len(forum_url) > 256):
            raise ValueError("Invalid value for `forum_url`, length must be less than or equal to `256`")  # noqa: E501
        if (self._configuration.client_side_validation and
                forum_url is not None and len(forum_url) < 0):
            raise ValueError("Invalid value for `forum_url`, length must be greater than or equal to `0`")  # noqa: E501

        self._forum_url = forum_url

    @property
    def has_checker(self):
        """Gets the has_checker of this Workflow.  # noqa: E501


        :return: The has_checker of this Workflow.  # noqa: E501
        :rtype: bool
        """
        return self._has_checker

    @has_checker.setter
    def has_checker(self, has_checker):
        """Sets the has_checker of this Workflow.


        :param has_checker: The has_checker of this Workflow.  # noqa: E501
        :type: bool
        """

        self._has_checker = has_checker

    @property
    def id(self):
        """Gets the id of this Workflow.  # noqa: E501

        Implementation specific ID for the container in this web service  # noqa: E501

        :return: The id of this Workflow.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Workflow.

        Implementation specific ID for the container in this web service  # noqa: E501

        :param id: The id of this Workflow.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def is_checker(self):
        """Gets the is_checker of this Workflow.  # noqa: E501


        :return: The is_checker of this Workflow.  # noqa: E501
        :rtype: bool
        """
        return self._is_checker

    @is_checker.setter
    def is_checker(self, is_checker):
        """Sets the is_checker of this Workflow.


        :param is_checker: The is_checker of this Workflow.  # noqa: E501
        :type: bool
        """

        self._is_checker = is_checker

    @property
    def last_modified_date(self):
        """Gets the last_modified_date of this Workflow.  # noqa: E501


        :return: The last_modified_date of this Workflow.  # noqa: E501
        :rtype: int
        """
        return self._last_modified_date

    @last_modified_date.setter
    def last_modified_date(self, last_modified_date):
        """Sets the last_modified_date of this Workflow.


        :param last_modified_date: The last_modified_date of this Workflow.  # noqa: E501
        :type: int
        """

        self._last_modified_date = last_modified_date

    @property
    def license_information(self):
        """Gets the license_information of this Workflow.  # noqa: E501


        :return: The license_information of this Workflow.  # noqa: E501
        :rtype: LicenseInformation
        """
        return self._license_information

    @license_information.setter
    def license_information(self, license_information):
        """Sets the license_information of this Workflow.


        :param license_information: The license_information of this Workflow.  # noqa: E501
        :type: LicenseInformation
        """

        self._license_information = license_information

    @property
    def orcid_put_code(self):
        """Gets the orcid_put_code of this Workflow.  # noqa: E501

        The presence of the put code indicates the entry was exported to ORCID.  # noqa: E501

        :return: The orcid_put_code of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._orcid_put_code

    @orcid_put_code.setter
    def orcid_put_code(self, orcid_put_code):
        """Sets the orcid_put_code of this Workflow.

        The presence of the put code indicates the entry was exported to ORCID.  # noqa: E501

        :param orcid_put_code: The orcid_put_code of this Workflow.  # noqa: E501
        :type: str
        """

        self._orcid_put_code = orcid_put_code

    @property
    def parent_entry(self):
        """Gets the parent_entry of this Workflow.  # noqa: E501


        :return: The parent_entry of this Workflow.  # noqa: E501
        :rtype: Entry
        """
        return self._parent_entry

    @parent_entry.setter
    def parent_entry(self, parent_entry):
        """Sets the parent_entry of this Workflow.


        :param parent_entry: The parent_entry of this Workflow.  # noqa: E501
        :type: Entry
        """

        self._parent_entry = parent_entry

    @property
    def topic_id(self):
        """Gets the topic_id of this Workflow.  # noqa: E501

        The Id of the corresponding topic on Dockstore Discuss  # noqa: E501

        :return: The topic_id of this Workflow.  # noqa: E501
        :rtype: int
        """
        return self._topic_id

    @topic_id.setter
    def topic_id(self, topic_id):
        """Sets the topic_id of this Workflow.

        The Id of the corresponding topic on Dockstore Discuss  # noqa: E501

        :param topic_id: The topic_id of this Workflow.  # noqa: E501
        :type: int
        """

        self._topic_id = topic_id

    @property
    def author(self):
        """Gets the author of this Workflow.  # noqa: E501

        This is the name of the author stated in the Dockstore.cwl  # noqa: E501

        :return: The author of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._author

    @author.setter
    def author(self, author):
        """Sets the author of this Workflow.

        This is the name of the author stated in the Dockstore.cwl  # noqa: E501

        :param author: The author of this Workflow.  # noqa: E501
        :type: str
        """

        self._author = author

    @property
    def description(self):
        """Gets the description of this Workflow.  # noqa: E501

        This is a human-readable description of this container and what it is trying to accomplish, required GA4GH  # noqa: E501

        :return: The description of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Workflow.

        This is a human-readable description of this container and what it is trying to accomplish, required GA4GH  # noqa: E501

        :param description: The description of this Workflow.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def labels(self):
        """Gets the labels of this Workflow.  # noqa: E501

        Labels (i.e. meta tags) for describing the purpose and contents of containers  # noqa: E501

        :return: The labels of this Workflow.  # noqa: E501
        :rtype: list[Label]
        """
        return self._labels

    @labels.setter
    def labels(self, labels):
        """Sets the labels of this Workflow.

        Labels (i.e. meta tags) for describing the purpose and contents of containers  # noqa: E501

        :param labels: The labels of this Workflow.  # noqa: E501
        :type: list[Label]
        """

        self._labels = labels

    @property
    def users(self):
        """Gets the users of this Workflow.  # noqa: E501

        This indicates the users that have control over this entry, dockstore specific  # noqa: E501

        :return: The users of this Workflow.  # noqa: E501
        :rtype: list[User]
        """
        return self._users

    @users.setter
    def users(self, users):
        """Sets the users of this Workflow.

        This indicates the users that have control over this entry, dockstore specific  # noqa: E501

        :param users: The users of this Workflow.  # noqa: E501
        :type: list[User]
        """

        self._users = users

    @property
    def starred_users(self):
        """Gets the starred_users of this Workflow.  # noqa: E501

        This indicates the users that have starred this entry, dockstore specific  # noqa: E501

        :return: The starred_users of this Workflow.  # noqa: E501
        :rtype: list[User]
        """
        return self._starred_users

    @starred_users.setter
    def starred_users(self, starred_users):
        """Sets the starred_users of this Workflow.

        This indicates the users that have starred this entry, dockstore specific  # noqa: E501

        :param starred_users: The starred_users of this Workflow.  # noqa: E501
        :type: list[User]
        """

        self._starred_users = starred_users

    @property
    def email(self):
        """Gets the email of this Workflow.  # noqa: E501

        This is the email of the git organization  # noqa: E501

        :return: The email of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this Workflow.

        This is the email of the git organization  # noqa: E501

        :param email: The email of this Workflow.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def default_version(self):
        """Gets the default_version of this Workflow.  # noqa: E501

        This is the name of the default version of the entry  # noqa: E501

        :return: The default_version of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._default_version

    @default_version.setter
    def default_version(self, default_version):
        """Sets the default_version of this Workflow.

        This is the name of the default version of the entry  # noqa: E501

        :param default_version: The default_version of this Workflow.  # noqa: E501
        :type: str
        """

        self._default_version = default_version

    @property
    def is_published(self):
        """Gets the is_published of this Workflow.  # noqa: E501

        Implementation specific visibility in this web service  # noqa: E501

        :return: The is_published of this Workflow.  # noqa: E501
        :rtype: bool
        """
        return self._is_published

    @is_published.setter
    def is_published(self, is_published):
        """Sets the is_published of this Workflow.

        Implementation specific visibility in this web service  # noqa: E501

        :param is_published: The is_published of this Workflow.  # noqa: E501
        :type: bool
        """

        self._is_published = is_published

    @property
    def last_modified(self):
        """Gets the last_modified of this Workflow.  # noqa: E501

        Implementation specific timestamp for last modified. Tools-> For automated/manual builds: N/A. For hosted: Last time a file was updated/created (new version created). Workflows-> For remote: When refresh is hit, last time GitHub repo was changed. Hosted: Last time a new version was made.  # noqa: E501

        :return: The last_modified of this Workflow.  # noqa: E501
        :rtype: int
        """
        return self._last_modified

    @last_modified.setter
    def last_modified(self, last_modified):
        """Sets the last_modified of this Workflow.

        Implementation specific timestamp for last modified. Tools-> For automated/manual builds: N/A. For hosted: Last time a file was updated/created (new version created). Workflows-> For remote: When refresh is hit, last time GitHub repo was changed. Hosted: Last time a new version was made.  # noqa: E501

        :param last_modified: The last_modified of this Workflow.  # noqa: E501
        :type: int
        """

        self._last_modified = last_modified

    @property
    def last_updated(self):
        """Gets the last_updated of this Workflow.  # noqa: E501

        Implementation specific timestamp for last updated on webservice. Tools-> For automated builds: last time tool/namespace was refreshed Dockstore, tool info (like changing dockerfile path) updated, or default version selected. For hosted tools: when you created the tool. Workflows-> For remote: When refresh all is hit for first time. Hosted: Seems to be time created.  # noqa: E501

        :return: The last_updated of this Workflow.  # noqa: E501
        :rtype: int
        """
        return self._last_updated

    @last_updated.setter
    def last_updated(self, last_updated):
        """Sets the last_updated of this Workflow.

        Implementation specific timestamp for last updated on webservice. Tools-> For automated builds: last time tool/namespace was refreshed Dockstore, tool info (like changing dockerfile path) updated, or default version selected. For hosted tools: when you created the tool. Workflows-> For remote: When refresh all is hit for first time. Hosted: Seems to be time created.  # noqa: E501

        :param last_updated: The last_updated of this Workflow.  # noqa: E501
        :type: int
        """

        self._last_updated = last_updated

    @property
    def git_url(self):
        """Gets the git_url of this Workflow.  # noqa: E501

        This is a link to the associated repo with a descriptor, required GA4GH  # noqa: E501

        :return: The git_url of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._git_url

    @git_url.setter
    def git_url(self, git_url):
        """Sets the git_url of this Workflow.

        This is a link to the associated repo with a descriptor, required GA4GH  # noqa: E501

        :param git_url: The git_url of this Workflow.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and git_url is None:
            raise ValueError("Invalid value for `git_url`, must not be `None`")  # noqa: E501

        self._git_url = git_url

    @property
    def checker_id(self):
        """Gets the checker_id of this Workflow.  # noqa: E501

        The id of the associated checker workflow  # noqa: E501

        :return: The checker_id of this Workflow.  # noqa: E501
        :rtype: int
        """
        return self._checker_id

    @checker_id.setter
    def checker_id(self, checker_id):
        """Sets the checker_id of this Workflow.

        The id of the associated checker workflow  # noqa: E501

        :param checker_id: The checker_id of this Workflow.  # noqa: E501
        :type: int
        """

        self._checker_id = checker_id

    @property
    def mode(self):
        """Gets the mode of this Workflow.  # noqa: E501

        This indicates what mode this is in which informs how we do things like refresh, dockstore specific  # noqa: E501

        :return: The mode of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._mode

    @mode.setter
    def mode(self, mode):
        """Sets the mode of this Workflow.

        This indicates what mode this is in which informs how we do things like refresh, dockstore specific  # noqa: E501

        :param mode: The mode of this Workflow.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and mode is None:
            raise ValueError("Invalid value for `mode`, must not be `None`")  # noqa: E501
        allowed_values = ["FULL", "STUB", "HOSTED", "DOCKSTORE_YML"]  # noqa: E501
        if (self._configuration.client_side_validation and
                mode not in allowed_values):
            raise ValueError(
                "Invalid value for `mode` ({0}), must be one of {1}"  # noqa: E501
                .format(mode, allowed_values)
            )

        self._mode = mode

    @property
    def concept_doi(self):
        """Gets the concept_doi of this Workflow.  # noqa: E501

        The Digital Object Identifier (DOI) representing all of the versions of your workflow  # noqa: E501

        :return: The concept_doi of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._concept_doi

    @concept_doi.setter
    def concept_doi(self, concept_doi):
        """Sets the concept_doi of this Workflow.

        The Digital Object Identifier (DOI) representing all of the versions of your workflow  # noqa: E501

        :param concept_doi: The concept_doi of this Workflow.  # noqa: E501
        :type: str
        """

        self._concept_doi = concept_doi

    @property
    def workflow_name(self):
        """Gets the workflow_name of this Workflow.  # noqa: E501

        This is the name of the workflow, not needed when only one workflow in a repo  # noqa: E501

        :return: The workflow_name of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._workflow_name

    @workflow_name.setter
    def workflow_name(self, workflow_name):
        """Sets the workflow_name of this Workflow.

        This is the name of the workflow, not needed when only one workflow in a repo  # noqa: E501

        :param workflow_name: The workflow_name of this Workflow.  # noqa: E501
        :type: str
        """

        self._workflow_name = workflow_name

    @property
    def input_file_formats(self):
        """Gets the input_file_formats of this Workflow.  # noqa: E501

        File formats for describing the input file formats of every version of an entry  # noqa: E501

        :return: The input_file_formats of this Workflow.  # noqa: E501
        :rtype: list[FileFormat]
        """
        return self._input_file_formats

    @input_file_formats.setter
    def input_file_formats(self, input_file_formats):
        """Sets the input_file_formats of this Workflow.

        File formats for describing the input file formats of every version of an entry  # noqa: E501

        :param input_file_formats: The input_file_formats of this Workflow.  # noqa: E501
        :type: list[FileFormat]
        """

        self._input_file_formats = input_file_formats

    @property
    def organization(self):
        """Gets the organization of this Workflow.  # noqa: E501

        This is a git organization for the workflow  # noqa: E501

        :return: The organization of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        """Sets the organization of this Workflow.

        This is a git organization for the workflow  # noqa: E501

        :param organization: The organization of this Workflow.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and organization is None:
            raise ValueError("Invalid value for `organization`, must not be `None`")  # noqa: E501

        self._organization = organization

    @property
    def output_file_formats(self):
        """Gets the output_file_formats of this Workflow.  # noqa: E501

        File formats for describing the output file formats of every version of an entry  # noqa: E501

        :return: The output_file_formats of this Workflow.  # noqa: E501
        :rtype: list[FileFormat]
        """
        return self._output_file_formats

    @output_file_formats.setter
    def output_file_formats(self, output_file_formats):
        """Sets the output_file_formats of this Workflow.

        File formats for describing the output file formats of every version of an entry  # noqa: E501

        :param output_file_formats: The output_file_formats of this Workflow.  # noqa: E501
        :type: list[FileFormat]
        """

        self._output_file_formats = output_file_formats

    @property
    def repository(self):
        """Gets the repository of this Workflow.  # noqa: E501

        This is a git repository name  # noqa: E501

        :return: The repository of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._repository

    @repository.setter
    def repository(self, repository):
        """Sets the repository of this Workflow.

        This is a git repository name  # noqa: E501

        :param repository: The repository of this Workflow.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and repository is None:
            raise ValueError("Invalid value for `repository`, must not be `None`")  # noqa: E501

        self._repository = repository

    @property
    def source_control(self):
        """Gets the source_control of this Workflow.  # noqa: E501

        This is a specific source control provider like github or bitbucket or n/a?, required: GA4GH  # noqa: E501

        :return: The source_control of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._source_control

    @source_control.setter
    def source_control(self, source_control):
        """Sets the source_control of this Workflow.

        This is a specific source control provider like github or bitbucket or n/a?, required: GA4GH  # noqa: E501

        :param source_control: The source_control of this Workflow.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and source_control is None:
            raise ValueError("Invalid value for `source_control`, must not be `None`")  # noqa: E501

        self._source_control = source_control

    @property
    def descriptor_type(self):
        """Gets the descriptor_type of this Workflow.  # noqa: E501

        This is a descriptor type for the workflow, by default either CWL, WDL, NFL, or gxformat2 (Defaults to CWL).  # noqa: E501

        :return: The descriptor_type of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._descriptor_type

    @descriptor_type.setter
    def descriptor_type(self, descriptor_type):
        """Sets the descriptor_type of this Workflow.

        This is a descriptor type for the workflow, by default either CWL, WDL, NFL, or gxformat2 (Defaults to CWL).  # noqa: E501

        :param descriptor_type: The descriptor_type of this Workflow.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and descriptor_type is None:
            raise ValueError("Invalid value for `descriptor_type`, must not be `None`")  # noqa: E501
        allowed_values = ["CWL", "WDL", "NFL", "gxformat2", "service"]  # noqa: E501
        if (self._configuration.client_side_validation and
                descriptor_type not in allowed_values):
            raise ValueError(
                "Invalid value for `descriptor_type` ({0}), must be one of {1}"  # noqa: E501
                .format(descriptor_type, allowed_values)
            )

        self._descriptor_type = descriptor_type

    @property
    def workflow_path(self):
        """Gets the workflow_path of this Workflow.  # noqa: E501

        This indicates for the associated git repository, the default path to the primary descriptor document  # noqa: E501

        :return: The workflow_path of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._workflow_path

    @workflow_path.setter
    def workflow_path(self, workflow_path):
        """Sets the workflow_path of this Workflow.

        This indicates for the associated git repository, the default path to the primary descriptor document  # noqa: E501

        :param workflow_path: The workflow_path of this Workflow.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and workflow_path is None:
            raise ValueError("Invalid value for `workflow_path`, must not be `None`")  # noqa: E501

        self._workflow_path = workflow_path

    @property
    def default_test_parameter_file_path(self):
        """Gets the default_test_parameter_file_path of this Workflow.  # noqa: E501

        This indicates for the associated git repository, the default path to the test parameter file  # noqa: E501

        :return: The default_test_parameter_file_path of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._default_test_parameter_file_path

    @default_test_parameter_file_path.setter
    def default_test_parameter_file_path(self, default_test_parameter_file_path):
        """Sets the default_test_parameter_file_path of this Workflow.

        This indicates for the associated git repository, the default path to the test parameter file  # noqa: E501

        :param default_test_parameter_file_path: The default_test_parameter_file_path of this Workflow.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and default_test_parameter_file_path is None:
            raise ValueError("Invalid value for `default_test_parameter_file_path`, must not be `None`")  # noqa: E501

        self._default_test_parameter_file_path = default_test_parameter_file_path

    @property
    def workflow_versions(self):
        """Gets the workflow_versions of this Workflow.  # noqa: E501

        Implementation specific tracking of valid build workflowVersions for the docker container  # noqa: E501

        :return: The workflow_versions of this Workflow.  # noqa: E501
        :rtype: list[WorkflowVersion]
        """
        return self._workflow_versions

    @workflow_versions.setter
    def workflow_versions(self, workflow_versions):
        """Sets the workflow_versions of this Workflow.

        Implementation specific tracking of valid build workflowVersions for the docker container  # noqa: E501

        :param workflow_versions: The workflow_versions of this Workflow.  # noqa: E501
        :type: list[WorkflowVersion]
        """

        self._workflow_versions = workflow_versions

    @property
    def descriptor_type_subclass(self):
        """Gets the descriptor_type_subclass of this Workflow.  # noqa: E501

        This is a descriptor type subclass for the workflow. Currently it is only used for services.  # noqa: E501

        :return: The descriptor_type_subclass of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._descriptor_type_subclass

    @descriptor_type_subclass.setter
    def descriptor_type_subclass(self, descriptor_type_subclass):
        """Sets the descriptor_type_subclass of this Workflow.

        This is a descriptor type subclass for the workflow. Currently it is only used for services.  # noqa: E501

        :param descriptor_type_subclass: The descriptor_type_subclass of this Workflow.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and descriptor_type_subclass is None:
            raise ValueError("Invalid value for `descriptor_type_subclass`, must not be `None`")  # noqa: E501
        allowed_values = ["DOCKER_COMPOSE", "HELM", "SWARM", "KUBERNETES", "NOT_APPLICABLE"]  # noqa: E501
        if (self._configuration.client_side_validation and
                descriptor_type_subclass not in allowed_values):
            raise ValueError(
                "Invalid value for `descriptor_type_subclass` ({0}), must be one of {1}"  # noqa: E501
                .format(descriptor_type_subclass, allowed_values)
            )

        self._descriptor_type_subclass = descriptor_type_subclass

    @property
    def full_workflow_path(self):
        """Gets the full_workflow_path of this Workflow.  # noqa: E501


        :return: The full_workflow_path of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._full_workflow_path

    @full_workflow_path.setter
    def full_workflow_path(self, full_workflow_path):
        """Sets the full_workflow_path of this Workflow.


        :param full_workflow_path: The full_workflow_path of this Workflow.  # noqa: E501
        :type: str
        """

        self._full_workflow_path = full_workflow_path

    @property
    def path(self):
        """Gets the path of this Workflow.  # noqa: E501


        :return: The path of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """Sets the path of this Workflow.


        :param path: The path of this Workflow.  # noqa: E501
        :type: str
        """

        self._path = path

    @property
    def source_control_provider(self):
        """Gets the source_control_provider of this Workflow.  # noqa: E501


        :return: The source_control_provider of this Workflow.  # noqa: E501
        :rtype: str
        """
        return self._source_control_provider

    @source_control_provider.setter
    def source_control_provider(self, source_control_provider):
        """Sets the source_control_provider of this Workflow.


        :param source_control_provider: The source_control_provider of this Workflow.  # noqa: E501
        :type: str
        """

        self._source_control_provider = source_control_provider

    def get_real_child_model(self, data):
        """Returns the real base class specified by the discriminator"""
        discriminator_value = data[self.discriminator].lower()
        return self.discriminator_value_class_map.get(discriminator_value)

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Workflow, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Workflow):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Workflow):
            return True

        return self.to_dict() != other.to_dict()
