# coding: utf-8

"""
    Dockstore API

    This describes the dockstore API, a webservice that manages pairs of Docker images and associated metadata such as CWL documents and Dockerfiles used to build those images. Explore swagger.json for a Swagger 2.0 description of our API and explore openapi.yaml for OpenAPI 3.0 descriptions.  # noqa: E501

    OpenAPI spec version: 1.12.0-alpha.1-SNAPSHOT
    Contact: theglobalalliance@genomicsandhealth.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from jgreenepack.configuration import Configuration


class WorkflowVersionPathInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'full_workflow_path': 'str',
        'tag_name': 'str'
    }

    attribute_map = {
        'full_workflow_path': 'fullWorkflowPath',
        'tag_name': 'tagName'
    }

    def __init__(self, full_workflow_path=None, tag_name=None, _configuration=None):  # noqa: E501
        """WorkflowVersionPathInfo - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._full_workflow_path = None
        self._tag_name = None
        self.discriminator = None

        if full_workflow_path is not None:
            self.full_workflow_path = full_workflow_path
        if tag_name is not None:
            self.tag_name = tag_name

    @property
    def full_workflow_path(self):
        """Gets the full_workflow_path of this WorkflowVersionPathInfo.  # noqa: E501

        Dockstore path to workflow.  # noqa: E501

        :return: The full_workflow_path of this WorkflowVersionPathInfo.  # noqa: E501
        :rtype: str
        """
        return self._full_workflow_path

    @full_workflow_path.setter
    def full_workflow_path(self, full_workflow_path):
        """Sets the full_workflow_path of this WorkflowVersionPathInfo.

        Dockstore path to workflow.  # noqa: E501

        :param full_workflow_path: The full_workflow_path of this WorkflowVersionPathInfo.  # noqa: E501
        :type: str
        """

        self._full_workflow_path = full_workflow_path

    @property
    def tag_name(self):
        """Gets the tag_name of this WorkflowVersionPathInfo.  # noqa: E501

        Name of workflow version tag  # noqa: E501

        :return: The tag_name of this WorkflowVersionPathInfo.  # noqa: E501
        :rtype: str
        """
        return self._tag_name

    @tag_name.setter
    def tag_name(self, tag_name):
        """Sets the tag_name of this WorkflowVersionPathInfo.

        Name of workflow version tag  # noqa: E501

        :param tag_name: The tag_name of this WorkflowVersionPathInfo.  # noqa: E501
        :type: str
        """

        self._tag_name = tag_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(WorkflowVersionPathInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, WorkflowVersionPathInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, WorkflowVersionPathInfo):
            return True

        return self.to_dict() != other.to_dict()
