#
# Copyright 2021 Canonical Ltd.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License version 3 as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#

"""LXD environment provider."""

from .errors import LXDError, LXDInstallationError  # noqa: F401
from .installer import (  # noqa: F401
    ensure_lxd_is_ready,
    install,
    is_initialized,
    is_installed,
    is_user_permitted,
)
from .launcher import launch  # noqa: F401
from .lxc import LXC  # noqa: F401
from .lxd import LXD  # noqa: F401
from .lxd_instance import LXDInstance  # noqa: F401
from .lxd_provider import PROVIDER_BASE_TO_LXD_BASE, LXDProvider  # noqa: F401
from .remotes import configure_buildd_image_remote  # noqa: F401

__all__ = [
    "LXC",
    "LXD",
    "LXDInstance",
    "LXDError",
    "LXDInstallationError",
    "LXDProvider",
    "PROVIDER_BASE_TO_LXD_BASE",
    "install",
    "is_installed",
    "is_initialized",
    "is_user_permitted",
    "ensure_lxd_is_ready",
    "configure_buildd_image_remote",
    "launch",
]
