# Notarizer

The following tool provides a way of verifying the authenticity of docker images. By providing a digital signature that gives a strong reason to believe that the image was created by a known source and was not altered. The following signature is generated by the content of the docker image history.

## How does Notarizer work?

Notarizer signs each parent image with a private key and place that signature in a docker label `LABEL signature=...`. The signature contents are obtained through the docker history command. With this command it is possible to verify if the label exists and validate if the image has a digital signature.

## Usage

Basic commands that are available in Notarizer.

### Sign

```
python notarizer/cli.py sign -i image_name:image_tag -p private-key.pem
```

Options:
* `-i` or `--image`: the image name to verify in the format `image_name:image_tag`. This option is required with at least one image and it can be used multiple times to validate multiple images at the same time.
* `-p` or `--private-key`: represents the path where the custom private key will be placed.
* `-s` or `--signature-label`: represents the custom label name given in the signature. Defaults to `signature` if the flag is not used.

### Verify

```
python notarizer/cli.py verify -i "image_name:image_tag" -p "public-key.pub"
```

Options:
* `-i` or `--image`: the image name to verify in the format `image_name:image_tag`. This option is required with at least one image and it can be used multiple times to validate multiple images at the same time.
* `-p` or `--public-key`: represents the path where the custom public key will be placed.
* `-s` or `--signature-label`: represents the custom label name given in the signature used in the **sign** command. Defaults to `signature` if the flag is not used.

### Exit Codes
After the validation runs the following exit codes are thrown:

```
- 0  - Verification OK / Signature OK
- 1  - Generic error
- 10 - No Signature Found
- 11 - Invalid Image Signature
- 12 - Verification Failure
- 13 - No Public Key Provided
- 14 - Image Not Found
- 15 - No Private Key Provided
- 16 - Error Creating Signed Docker Image
```

If there's more than one error on the run (for instance if the verification runs for several images) the exit code will be from the first error found. Although, on the output it's provided the list of all errors found during the run.

### Generate Private and Public Key

```
openssl genpkey -algorithm RSA -out private-key.pem -aes-256-cbc -pkeyopt rsa_keygen_bits:4096
openssl rsa -in private-key.pem -pubout -out public-key.pub
```

## Contributing

1.  Fork this repository
2.  Follow project guidelines
3.  Do your stuff
4.  Open a pull request following [conventional commits](https://www.conventionalcommits.org/en/v1.0.0/)

## License

[MIT](LICENSE)