"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaRestApi = void 0;
const integrations_1 = require("./integrations");
const restapi_1 = require("./restapi");
/**
 * Defines an API Gateway REST API with AWS Lambda proxy integration.
 *
 * Use the `proxy` property to define a greedy proxy ("{proxy+}") and "ANY"
 * method from the specified path. If not defined, you will need to explicity
 * add resources and methods to the API.
 */
class LambdaRestApi extends restapi_1.RestApi {
    constructor(scope, id, props) {
        if ((props.options && props.options.defaultIntegration) || props.defaultIntegration) {
            throw new Error('Cannot specify "defaultIntegration" since Lambda integration is automatically defined');
        }
        super(scope, id, {
            defaultIntegration: new integrations_1.LambdaIntegration(props.handler),
            ...props.options,
            ...props,
        });
        if (props.proxy !== false) {
            this.root.addProxy();
            // Make sure users cannot call any other resource adding function
            this.root.addResource = addResourceThrows;
            this.root.addMethod = addMethodThrows;
            this.root.addProxy = addProxyThrows;
        }
    }
}
exports.LambdaRestApi = LambdaRestApi;
function addResourceThrows() {
    throw new Error('Cannot call \'addResource\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addMethodThrows() {
    throw new Error('Cannot call \'addMethod\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
function addProxyThrows() {
    throw new Error('Cannot call \'addProxy\' on a proxying LambdaRestApi; set \'proxy\' to false');
}
//# sourceMappingURL=data:application/json;base64,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