"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
const datadog_monitor_1 = require("./monitors/datadog-monitor");
const properties_1 = require("./monitors/properties");
const app = new core_1.App();
const stack = new core_1.Stack(app, 'CdkDatadogResourcesTestStack');
new datadog_monitor_1.DatadogMonitor(stack, 'TestMonitor', {
    datadogCredentials: {
        apiKey: process.env.DATADOG_API_KEY || 'DATADOG_API_KEY',
        applicationKey: process.env.DATADOG_APP_KEY || 'DATADOG_APP_KEY',
    },
    query: 'avg(last_1h):sum:system.cpu.system{host:host0} > 100',
    type: properties_1.MonitorType.QUERY_ALERT,
    name: 'Test Monitor',
    options: {
        thresholds: {
            critical: 100,
            warning: 80,
            oK: 90,
        },
        notifyNoData: true,
        evaluationDelay: 60,
    },
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2RrLWFwcC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9jZGstYXBwLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsd0NBQTJDO0FBQzNDLGdFQUE0RDtBQUM1RCxzREFBb0Q7QUFFcEQsTUFBTSxHQUFHLEdBQUcsSUFBSSxVQUFHLEVBQUUsQ0FBQztBQUN0QixNQUFNLEtBQUssR0FBRyxJQUFJLFlBQUssQ0FBQyxHQUFHLEVBQUUsOEJBQThCLENBQUMsQ0FBQztBQUU3RCxJQUFJLGdDQUFjLENBQUMsS0FBSyxFQUFFLGFBQWEsRUFBRTtJQUN2QyxrQkFBa0IsRUFBRTtRQUNsQixNQUFNLEVBQUUsT0FBTyxDQUFDLEdBQUcsQ0FBQyxlQUFlLElBQUksaUJBQWlCO1FBQ3hELGNBQWMsRUFBRSxPQUFPLENBQUMsR0FBRyxDQUFDLGVBQWUsSUFBSSxpQkFBaUI7S0FDakU7SUFDRCxLQUFLLEVBQUUsc0RBQXNEO0lBQzdELElBQUksRUFBRSx3QkFBVyxDQUFDLFdBQVc7SUFDN0IsSUFBSSxFQUFFLGNBQWM7SUFDcEIsT0FBTyxFQUFFO1FBQ1AsVUFBVSxFQUFFO1lBQ1YsUUFBUSxFQUFFLEdBQUc7WUFDYixPQUFPLEVBQUUsRUFBRTtZQUNYLEVBQUUsRUFBRSxFQUFFO1NBQ1A7UUFDRCxZQUFZLEVBQUUsSUFBSTtRQUNsQixlQUFlLEVBQUUsRUFBRTtLQUNwQjtDQUNGLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEFwcCwgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IERhdGFkb2dNb25pdG9yIH0gZnJvbSAnLi9tb25pdG9ycy9kYXRhZG9nLW1vbml0b3InO1xuaW1wb3J0IHsgTW9uaXRvclR5cGUgfSBmcm9tICcuL21vbml0b3JzL3Byb3BlcnRpZXMnO1xuXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBTdGFjayhhcHAsICdDZGtEYXRhZG9nUmVzb3VyY2VzVGVzdFN0YWNrJyk7XG5cbm5ldyBEYXRhZG9nTW9uaXRvcihzdGFjaywgJ1Rlc3RNb25pdG9yJywge1xuICBkYXRhZG9nQ3JlZGVudGlhbHM6IHtcbiAgICBhcGlLZXk6IHByb2Nlc3MuZW52LkRBVEFET0dfQVBJX0tFWSB8fCAnREFUQURPR19BUElfS0VZJyxcbiAgICBhcHBsaWNhdGlvbktleTogcHJvY2Vzcy5lbnYuREFUQURPR19BUFBfS0VZIHx8ICdEQVRBRE9HX0FQUF9LRVknLFxuICB9LFxuICBxdWVyeTogJ2F2ZyhsYXN0XzFoKTpzdW06c3lzdGVtLmNwdS5zeXN0ZW17aG9zdDpob3N0MH0gPiAxMDAnLFxuICB0eXBlOiBNb25pdG9yVHlwZS5RVUVSWV9BTEVSVCxcbiAgbmFtZTogJ1Rlc3QgTW9uaXRvcicsXG4gIG9wdGlvbnM6IHtcbiAgICB0aHJlc2hvbGRzOiB7XG4gICAgICBjcml0aWNhbDogMTAwLFxuICAgICAgd2FybmluZzogODAsXG4gICAgICBvSzogOTAsXG4gICAgfSxcbiAgICBub3RpZnlOb0RhdGE6IHRydWUsXG4gICAgZXZhbHVhdGlvbkRlbGF5OiA2MCxcbiAgfSxcbn0pO1xuIl19