# Generated by Django 3.0.6 on 2020-05-29 12:52

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import vote.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Application',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('text', models.TextField(blank=True, max_length=250)),
                ('avatar', models.ImageField(blank=True, null=True, upload_to=vote.models.avatar_file_name)),
                ('last_name', models.CharField(max_length=256)),
                ('first_name', models.CharField(max_length=256)),
                ('room', models.CharField(blank=True, max_length=64)),
                ('email', models.EmailField(blank=True, max_length=254)),
            ],
        ),
        migrations.CreateModel(
            name='Election',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=512)),
                ('start_date', models.DateTimeField(blank=True, null=True)),
                ('end_date', models.DateTimeField(blank=True, null=True)),
                ('max_votes_yes', models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name='Session',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=256)),
                ('meeting_link', models.CharField(blank=True, max_length=512, null=True)),
                ('start_date', models.DateTimeField(blank=True, default=django.utils.timezone.now, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='Voter',
            fields=[
                ('voter_id', models.IntegerField(primary_key=True, serialize=False)),
                ('password', models.CharField(max_length=256)),
                ('first_name', models.CharField(max_length=128)),
                ('last_name', models.CharField(max_length=128)),
                ('email', models.EmailField(max_length=254)),
                ('remind_me', models.BooleanField(default=False)),
                ('session', models.ForeignKey(default=None, on_delete=django.db.models.deletion.CASCADE, related_name='participants', to='vote.Session')),
            ],
        ),
        migrations.CreateModel(
            name='Vote',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('vote', models.CharField(choices=[('abstention', 'Abstention'), ('accept', 'Yes'), ('reject', 'No')], max_length=10)),
                ('candidate', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='votes', to='vote.Application')),
                ('election', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='votes', to='vote.Election')),
            ],
        ),
        migrations.CreateModel(
            name='OpenVote',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('election', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='open_votes', to='vote.Election')),
                ('voter', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='vote.Voter')),
            ],
        ),
        migrations.AddField(
            model_name='election',
            name='session',
            field=models.ForeignKey(default=None, on_delete=django.db.models.deletion.CASCADE, related_name='elections', to='vote.Session'),
        ),
        migrations.AddField(
            model_name='application',
            name='election',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='application', to='vote.Election'),
        ),
    ]
