# -*- coding: utf-8 -*-
import io
import os
import tempfile
from pika_marker import PikaMarker, appendPikaMarker


def test_append_to_stringio():
    buf = io.StringIO()
    appendPikaMarker(buf, name="start", additional="init", icon="😀", timestamp=123456.0)
    appendPikaMarker(buf, name="stop", additional="stopping", icon="😀", timestamp=654321.0)

    expected = '123456.0,"😀","start","init"\n654321.0,"😀","stop","stopping"\n'
    buf.seek(0)
    assert buf.read() == expected


def test_append_to_file_path():
    with tempfile.NamedTemporaryFile("r+", delete=False) as tmp:
        path = tmp.name
    try:
        appendPikaMarker(path, name="start", additional="init", icon="😀", timestamp=123456.0)
        appendPikaMarker(path, name="stop", additional="stopping", icon="😀", timestamp=654321.0)
        with open(path, "r", encoding="utf-8") as f:
            content = f.read()
        assert content == '123456.0,"😀","start","init"\n654321.0,"😀","stop","stopping"\n'
    finally:
        os.remove(path)


def test_pikamarker_write_and_close():
    with tempfile.NamedTemporaryFile("r+", delete=False) as tmp:
        file_path = tmp.name
    marker = PikaMarker(file_path)

    marker.appendMarker("start", "init", "😀", 123456.0)
    marker.appendMarker("stop", "stopping", "😀", 654321.0)
    marker.close()

    with open(file_path, "r", encoding="utf-8") as f:
        content = f.read()
    assert content == '123456.0,"😀","start","init"\n654321.0,"😀","stop","stopping"\n'
    assert marker.file is None
