# Changelog

## [Unreleased](https://github.com/hackingmaterials/rocketsled/tree/HEAD)

[Full Changelog](https://github.com/hackingmaterials/rocketsled/compare/v2019.9.12...HEAD)

**Implemented enhancements:**

- Change versioning [\#81](https://github.com/hackingmaterials/rocketsled/issues/81)
- Enforce a code style [\#78](https://github.com/hackingmaterials/rocketsled/issues/78)

**Fixed bugs:**

- Prepend hostname to the PID for queue checking [\#80](https://github.com/hackingmaterials/rocketsled/issues/80)
- Fix codacy issues [\#58](https://github.com/hackingmaterials/rocketsled/issues/58)
- "scaling" portion of code is confusing [\#53](https://github.com/hackingmaterials/rocketsled/issues/53)

**Closed issues:**

- Update help link to new forum [\#82](https://github.com/hackingmaterials/rocketsled/issues/82)
- upgrade pymongo version [\#72](https://github.com/hackingmaterials/rocketsled/issues/72)

**Merged pull requests:**

- fix some codacy issues [\#92](https://github.com/hackingmaterials/rocketsled/pull/92) ([ardunn](https://github.com/ardunn))
- formatting fixes [\#91](https://github.com/hackingmaterials/rocketsled/pull/91) ([ardunn](https://github.com/ardunn))
- fix req conflict [\#90](https://github.com/hackingmaterials/rocketsled/pull/90) ([ardunn](https://github.com/ardunn))
- Bump matplotlib from 3.1.1 to 3.2.1 [\#89](https://github.com/hackingmaterials/rocketsled/pull/89) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Pidhostame [\#88](https://github.com/hackingmaterials/rocketsled/pull/88) ([ardunn](https://github.com/ardunn))
- Bump scipy from 1.3.1 to 1.4.1 [\#87](https://github.com/hackingmaterials/rocketsled/pull/87) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump fireworks from 1.9.4 to 1.9.5 [\#86](https://github.com/hackingmaterials/rocketsled/pull/86) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump pymongo from 3.9.0 to 3.10.1 [\#84](https://github.com/hackingmaterials/rocketsled/pull/84) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump numpy from 1.16.3 to 1.17.2 [\#79](https://github.com/hackingmaterials/rocketsled/pull/79) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump scipy from 1.2.1 to 1.3.1 [\#77](https://github.com/hackingmaterials/rocketsled/pull/77) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump fireworks from 1.9.0 to 1.9.4 [\#76](https://github.com/hackingmaterials/rocketsled/pull/76) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump matplotlib from 3.0.3 to 3.1.1 [\#75](https://github.com/hackingmaterials/rocketsled/pull/75) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump pymongo from 3.7.2 to 3.9.0 [\#74](https://github.com/hackingmaterials/rocketsled/pull/74) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))
- Bump scikit-learn from 0.20.3 to 0.21.3 [\#73](https://github.com/hackingmaterials/rocketsled/pull/73) ([dependabot-preview[bot]](https://github.com/apps/dependabot-preview))

## [v2019.9.12](https://github.com/hackingmaterials/rocketsled/tree/v2019.9.12) (2019-09-11)

[Full Changelog](https://github.com/hackingmaterials/rocketsled/compare/v2019.9.11...v2019.9.12)

## [v2019.9.11](https://github.com/hackingmaterials/rocketsled/tree/v2019.9.11) (2019-09-11)

[Full Changelog](https://github.com/hackingmaterials/rocketsled/compare/v2019.6.5...v2019.9.11)

**Closed issues:**

- General comment on code and examples [\#56](https://github.com/hackingmaterials/rocketsled/issues/56)

## [v2019.6.5](https://github.com/hackingmaterials/rocketsled/tree/v2019.6.5) (2019-06-05)

[Full Changelog](https://github.com/hackingmaterials/rocketsled/compare/v2019.6.4...v2019.6.5)

## [v2019.6.4](https://github.com/hackingmaterials/rocketsled/tree/v2019.6.4) (2019-06-05)

[Full Changelog](https://github.com/hackingmaterials/rocketsled/compare/v2019.5.3...v2019.6.4)

## [v2019.5.3](https://github.com/hackingmaterials/rocketsled/tree/v2019.5.3) (2019-05-04)

[Full Changelog](https://github.com/hackingmaterials/rocketsled/compare/v2019.5.2...v2019.5.3)

## [v2019.5.2](https://github.com/hackingmaterials/rocketsled/tree/v2019.5.2) (2019-05-04)

[Full Changelog](https://github.com/hackingmaterials/rocketsled/compare/v2019.4.17...v2019.5.2)

## [v2019.4.17](https://github.com/hackingmaterials/rocketsled/tree/v2019.4.17) (2019-04-18)

[Full Changelog](https://github.com/hackingmaterials/rocketsled/compare/v2019.3.15...v2019.4.17)

**Closed issues:**

- add paper citation to rocketsled [\#42](https://github.com/hackingmaterials/rocketsled/issues/42)

## [v2019.3.15](https://github.com/hackingmaterials/rocketsled/tree/v2019.3.15) (2019-03-16)

[Full Changelog](https://github.com/hackingmaterials/rocketsled/compare/v2019.2.27...v2019.3.15)

**Closed issues:**

- Transition to unittest [\#64](https://github.com/hackingmaterials/rocketsled/issues/64)
- Comprehensive guide needs update [\#59](https://github.com/hackingmaterials/rocketsled/issues/59)
- tutorial rework [\#55](https://github.com/hackingmaterials/rocketsled/issues/55)

## [v2019.2.27](https://github.com/hackingmaterials/rocketsled/tree/v2019.2.27) (2019-02-27)

[Full Changelog](https://github.com/hackingmaterials/rocketsled/compare/v2019.2.17...v2019.2.27)

**Merged pull requests:**

- Fix typo, when all inputs are floats [\#65](https://github.com/hackingmaterials/rocketsled/pull/65) ([RemiLehe](https://github.com/RemiLehe))

## [v2019.2.17](https://github.com/hackingmaterials/rocketsled/tree/v2019.2.17) (2019-02-19)

[Full Changelog](https://github.com/hackingmaterials/rocketsled/compare/v2019.1.1...v2019.2.17)

**Merged pull requests:**

- Minor corrections to the tutorial and examples [\#63](https://github.com/hackingmaterials/rocketsled/pull/63) ([RemiLehe](https://github.com/RemiLehe))

## [v2019.1.1](https://github.com/hackingmaterials/rocketsled/tree/v2019.1.1) (2019-01-01)

[Full Changelog](https://github.com/hackingmaterials/rocketsled/compare/v2018.12.30...v2019.1.1)

## [v2018.12.30](https://github.com/hackingmaterials/rocketsled/tree/v2018.12.30) (2019-01-01)

[Full Changelog](https://github.com/hackingmaterials/rocketsled/compare/v2018.12.31...v2018.12.30)

## [v2018.12.31](https://github.com/hackingmaterials/rocketsled/tree/v2018.12.31) (2019-01-01)

[Full Changelog](https://github.com/hackingmaterials/rocketsled/compare/v2018.12.26...v2018.12.31)

**Closed issues:**

- Most type checking and metadata can be stored as central db doc [\#57](https://github.com/hackingmaterials/rocketsled/issues/57)
- don't understand check\_dims [\#50](https://github.com/hackingmaterials/rocketsled/issues/50)
- make sure all instance attributes are only set in the \_\_init\_\_ method\(\) [\#48](https://github.com/hackingmaterials/rocketsled/issues/48)

## [v2018.12.26](https://github.com/hackingmaterials/rocketsled/tree/v2018.12.26) (2018-12-27)

[Full Changelog](https://github.com/hackingmaterials/rocketsled/compare/1.1...v2018.12.26)

**Closed issues:**

- suggest rename \_x\_opt and \_y\_opt to simply \_x and \_y [\#54](https://github.com/hackingmaterials/rocketsled/issues/54)
- better documentation for example tasks [\#52](https://github.com/hackingmaterials/rocketsled/issues/52)
- add docs to return\_means [\#51](https://github.com/hackingmaterials/rocketsled/issues/51)
- why is XZ\_new one variable? [\#49](https://github.com/hackingmaterials/rocketsled/issues/49)
- rename n\_boots n\_bootstrap [\#47](https://github.com/hackingmaterials/rocketsled/issues/47)
- "Attributes" section of docstring [\#46](https://github.com/hackingmaterials/rocketsled/issues/46)
- remove random\_proba [\#45](https://github.com/hackingmaterials/rocketsled/issues/45)
- suggest rename of "space" parameter to "dimensions\_file" [\#44](https://github.com/hackingmaterials/rocketsled/issues/44)
- remove db name, host, port, and db\_extras from OptTask [\#43](https://github.com/hackingmaterials/rocketsled/issues/43)
- Batch mode may produce duplicates [\#36](https://github.com/hackingmaterials/rocketsled/issues/36)
- Add ability to disable duplicate checking and actually run optimizations in parallel [\#11](https://github.com/hackingmaterials/rocketsled/issues/11)

## [1.1](https://github.com/hackingmaterials/rocketsled/tree/1.1) (2018-07-30)

[Full Changelog](https://github.com/hackingmaterials/rocketsled/compare/1c24fadc55be95f1bb3dc9c4d271d56d980ca547...1.1)

**Closed issues:**

- Rename XZ\* to Z\* [\#40](https://github.com/hackingmaterials/rocketsled/issues/40)
- Docs should be revised  [\#39](https://github.com/hackingmaterials/rocketsled/issues/39)
- Remove hyperparameter optimization + useless optimizers [\#38](https://github.com/hackingmaterials/rocketsled/issues/38)
- Add to analyze/visualize \(and \_predict?\) Ability to rank pareto solutions [\#35](https://github.com/hackingmaterials/rocketsled/issues/35)
- Mutli-objective optimizations only seem to maximize [\#34](https://github.com/hackingmaterials/rocketsled/issues/34)
- Convert dtypes to namedtuple [\#32](https://github.com/hackingmaterials/rocketsled/issues/32)
- Python 3 bson issue [\#31](https://github.com/hackingmaterials/rocketsled/issues/31)
- Add ability to use x only as an index, or unique tag, not as learning features [\#30](https://github.com/hackingmaterials/rocketsled/issues/30)
- Figure out a good way to scale data for optimizers... [\#29](https://github.com/hackingmaterials/rocketsled/issues/29)
- Fix LCB for acquisition function [\#28](https://github.com/hackingmaterials/rocketsled/issues/28)
- Add logging/verbosity [\#27](https://github.com/hackingmaterials/rocketsled/issues/27)
- Add Other optimization algorithms [\#26](https://github.com/hackingmaterials/rocketsled/issues/26)
- Speed improvements [\#25](https://github.com/hackingmaterials/rocketsled/issues/25)
- Figure out parallel bootstrapping [\#24](https://github.com/hackingmaterials/rocketsled/issues/24)
- Choose a good number of default bootstraps [\#23](https://github.com/hackingmaterials/rocketsled/issues/23)
- Change random\_interval to a probability [\#22](https://github.com/hackingmaterials/rocketsled/issues/22)
- Write tests for parallel duplicates [\#21](https://github.com/hackingmaterials/rocketsled/issues/21)
- Make better docs/tutorials [\#20](https://github.com/hackingmaterials/rocketsled/issues/20)
- Stop rs\_examples/benchmarks being its own package [\#19](https://github.com/hackingmaterials/rocketsled/issues/19)
- Decide on a way to store models persistently [\#18](https://github.com/hackingmaterials/rocketsled/issues/18)
- Make an auto-setup [\#17](https://github.com/hackingmaterials/rocketsled/issues/17)
- Add tags to each mongo doc? [\#16](https://github.com/hackingmaterials/rocketsled/issues/16)
- Various probabilistic functions for sampling spaces [\#15](https://github.com/hackingmaterials/rocketsled/issues/15)
- Add uncertainty estimation + more advanced methods of prediction [\#14](https://github.com/hackingmaterials/rocketsled/issues/14)
- Decide on whether hyperparameter optimization is actually useful [\#13](https://github.com/hackingmaterials/rocketsled/issues/13)
- Multi objective optimization [\#12](https://github.com/hackingmaterials/rocketsled/issues/12)
- examples should not use default FireWorks database [\#6](https://github.com/hackingmaterials/rocketsled/issues/6)
- docstring style should be Google [\#5](https://github.com/hackingmaterials/rocketsled/issues/5)
- close issues when done! [\#4](https://github.com/hackingmaterials/rocketsled/issues/4)
- rename root dir [\#3](https://github.com/hackingmaterials/rocketsled/issues/3)
- remove launcher\_\* dirs from github [\#2](https://github.com/hackingmaterials/rocketsled/issues/2)
- remove .idea from github repo [\#1](https://github.com/hackingmaterials/rocketsled/issues/1)

**Merged pull requests:**

- Fix LCB and add hyper-parameters to acq functions [\#41](https://github.com/hackingmaterials/rocketsled/pull/41) ([spacedome](https://github.com/spacedome))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
