# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['django_guid', 'django_guid.integrations', 'django_guid.integrations.celery']

package_data = \
{'': ['*']}

install_requires = \
['django>=3.1.1,<4.0.0']

setup_kwargs = {
    'name': 'django-guid',
    'version': '3.1.0',
    'description': 'Middleware that enables single request-response cycle tracing by injecting a unique ID into project logs',
    'long_description': "Django GUID\n===========\n\n\n.. image:: https://img.shields.io/pypi/v/django-guid.svg\n    :target: https://pypi.org/pypi/django-guid\n\n.. image:: https://img.shields.io/badge/python-3.6+-blue.svg\n    :target: https://pypi.python.org/pypi/django-guid#downloads\n\n.. image:: https://img.shields.io/badge/django-2.2%20|%203.0%20|%203.1%20-blue.svg\n    :target: https://pypi.python.org/pypi/django-guid\n\n.. image:: https://img.shields.io/badge/ASGI-supported-brightgreen.svg\n    :target: https://img.shields.io/badge/ASGI-supported-brightgreen.svg\n\n.. image:: https://img.shields.io/badge/WSGI-supported-brightgreen.svg\n    :target: https://img.shields.io/badge/WSGI-supported-brightgreen.svg\n\n.. image:: https://readthedocs.org/projects/django-guid/badge/?version=latest\n    :target: https://django-guid.readthedocs.io/en/latest/?badge=latest\n\n.. image:: https://codecov.io/gh/snok/django-guid/branch/master/graph/badge.svg\n    :target: https://codecov.io/gh/snok/django-guid\n\n.. image:: https://img.shields.io/badge/code%20style-black-000000.svg\n    :target: https://github.com/psf/black\n\n.. image:: https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white\n    :target: https://github.com/pre-commit/pre-commit\n\n\n\n--------------\n\n\nDjango GUID attaches a unique correlation ID/request ID to all your log outputs for every request.\nIn other words, all logs connected to a request now has a unique ID attached to it, making debugging simple.\n\nWhich version of Django GUID you should use depends on your Django version and whether you run ``ASGI`` or ``WSGI`` servers.\nTo determine which Django-GUID version you should use, please see the table below.\n\n+---------------------+--------------------------+\n|   Django version    |   Django-GUID version    |\n+=====================+==========================+\n| 3.1.1 or above      |  3.x.x - ASGI and WSGI   |\n+---------------------+--------------------------+\n| 3.0.0 - 3.1.0       |  2.x.x - Only WSGI       |\n+---------------------+--------------------------+\n| 2.2.x               |  2.x.x - Only WSGI       |\n+---------------------+--------------------------+\n\nDjango GUID >= 3.0.0 uses ``ContextVar`` to store and access the GUID. Previous versions stored the GUID to an object,\nmaking it accessible by using the ID of the current thread. (Version 2 of Django GUID is supported until Django2.2 LTS has passed.)\n\n--------------\n\n\n**Resources**:\n\n* Free software: BSD License\n* Documentation: https://django-guid.readthedocs.io\n* Homepage: https://github.com/snok/django-guid\n\n--------------\n\n\n**Examples**\n\nLog output with a GUID:\n\n.. code-block::\n\n    INFO ... [773fa6885e03493498077a273d1b7f2d] project.views This is a DRF view log, and should have a GUID.\n    WARNING ... [773fa6885e03493498077a273d1b7f2d] project.services.file Some warning in a function\n    INFO ... [0d1c3919e46e4cd2b2f4ac9a187a8ea1] project.views This is a DRF view log, and should have a GUID.\n    INFO ... [99d44111e9174c5a9494275aa7f28858] project.views This is a DRF view log, and should have a GUID.\n    WARNING ... [0d1c3919e46e4cd2b2f4ac9a187a8ea1] project.services.file Some warning in a function\n    WARNING ... [99d44111e9174c5a9494275aa7f28858] project.services.file Some warning in a function\n\n\nLog output without a GUID:\n\n.. code-block::\n\n    INFO ... project.views This is a DRF view log, and should have a GUID.\n    WARNING ... project.services.file Some warning in a function\n    INFO ... project.views This is a DRF view log, and should have a GUID.\n    INFO ... project.views This is a DRF view log, and should have a GUID.\n    WARNING ... project.services.file Some warning in a function\n    WARNING ... project.services.file Some warning in a function\n\n\nSee the `documentation <https://django-guid.readthedocs.io>`_ for more examples.\n\n************\nInstallation\n************\n\nInstall using pip:\n\n.. code-block:: bash\n\n    pip install django-guid\n\n\n********\nSettings\n********\n\nPackage settings are added in your ``settings.py``:\n\n.. code-block:: python\n\n    DJANGO_GUID = {\n        'GUID_HEADER_NAME': 'Correlation-ID',\n        'VALIDATE_GUID': True,\n        'RETURN_HEADER': True,\n        'EXPOSE_HEADER': True,\n        'INTEGRATIONS': [],\n        'IGNORE_URLS': [],\n        'UUID_LENGTH': 32,\n    }\n\n\n\n**Optional Parameters**\n\n* :code:`GUID_HEADER_NAME`\n        The name of the GUID to look for in a header in an incoming request. Remember that it's case insensitive.\n\n    Default: Correlation-ID\n\n* :code:`VALIDATE_GUID`\n        Whether the :code:`GUID_HEADER_NAME` should be validated or not.\n        If the GUID sent to through the header is not a valid GUID (:code:`uuid.uuid4`).\n\n    Default: True\n\n* :code:`RETURN_HEADER`\n        Whether to return the GUID (Correlation-ID) as a header in the response or not.\n        It will have the same name as the :code:`GUID_HEADER_NAME` setting.\n\n    Default: True\n\n* :code:`EXPOSE_HEADER`\n        Whether to return :code:`Access-Control-Expose-Headers` for the GUID header if\n        :code:`RETURN_HEADER` is :code:`True`, has no effect if :code:`RETURN_HEADER` is :code:`False`.\n        This is allows the JavaScript Fetch API to access the header when CORS is enabled.\n\n    Default: True\n\n* :code:`INTEGRATIONS`\n        Whether to enable any custom or available integrations with :code:`django_guid`.\n        As an example, using :code:`SentryIntegration()` as an integration would set Sentry's :code:`transaction_id` to\n        match the GUID used by the middleware.\n\n    Default: []\n\n* :code:`IGNORE_URLS`\n        URL endpoints where the middleware will be disabled. You can put your health check endpoints here.\n\n    Default: []\n\n* :code:`UUID_LENGTH`\n        Lets you optionally trim the length of the package generated UUIDs.\n\n    Default: 32\n\n*************\nConfiguration\n*************\n\nOnce settings have set up, add the following to your projects' ``settings.py``:\n\n1. Installed Apps\n=================\n\nAdd :code:`django_guid` to your :code:`INSTALLED_APPS`:\n\n.. code-block:: python\n\n    INSTALLED_APPS = [\n        ...\n        'django_guid',\n    ]\n\n\n2. Middleware\n=============\n\nAdd the :code:`django_guid.middleware.guid_middleware` to your ``MIDDLEWARE``:\n\n.. code-block:: python\n\n    MIDDLEWARE = [\n        'django_guid.middleware.guid_middleware',\n        ...\n     ]\n\n\nIt is recommended that you add the middleware at the top, so that the remaining middleware loggers include the requests GUID.\n\n3. Logging Configuration\n========================\n\nAdd :code:`django_guid.log_filters.CorrelationId` as a filter in your ``LOGGING`` configuration:\n\n.. code-block:: python\n\n    LOGGING = {\n        ...\n        'filters': {\n            'correlation_id': {\n                '()': 'django_guid.log_filters.CorrelationId'\n            }\n        }\n    }\n\nPut that filter in your handler:\n\n.. code-block:: python\n\n    LOGGING = {\n        ...\n        'handlers': {\n            'console': {\n                'class': 'logging.StreamHandler',\n                'formatter': 'medium',\n                'filters': ['correlation_id'],\n            }\n        }\n    }\n\nAnd make sure to add the new ``correlation_id`` filter to one or all of your formatters:\n\n.. code-block:: python\n\n    LOGGING = {\n        ...\n        'formatters': {\n            'medium': {\n                'format': '%(levelname)s %(asctime)s [%(correlation_id)s] %(name)s %(message)s'\n            }\n        }\n    }\n\n\nIf these settings were confusing, please have a look in the demo projects'\n`settings.py <https://github.com/snok/django-guid/blob/master/demoproj/settings.py>`_ file for a complete example.\n\n4. Django GUID Logger (Optional)\n================================\n\nIf you wish to see the Django GUID middleware outputs, you may configure a logger for the module.\nSimply add django_guid to your loggers in the project, like in the example below:\n\n.. code-block:: python\n\n    LOGGING = {\n        ...\n        'loggers': {\n            'django_guid': {\n                'handlers': ['console', 'logstash'],\n                'level': 'WARNING',\n                'propagate': False,\n            }\n        }\n    }\n\nThis is especially useful when implementing the package, if you plan to pass existing GUIDs to the middleware, as misconfigured GUIDs will not raise exceptions, but will generate warning logs.\n",
    'author': 'Jonas Krüger Svensson',
    'author_email': 'jonas-ks@hotmail.com',
    'maintainer': 'Sondre Lillebø Gundersen',
    'maintainer_email': 'sondrelg@live.no',
    'url': 'https://github.com/snok/django-guid',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
