# Generated by Django 3.1.4 on 2021-06-18 13:47

from django.db import migrations, models


def char2bool(apps, schema_editor):
    election = apps.get_model('vote', 'election')
    for row in election.objects.all():
        row.result_unpublished = not bool(int(row.result_published))
        row.save(update_fields=['result_unpublished'])


def bool2char(apps, schema_editor):
    election = apps.get_model('vote', 'election')
    for row in election.objects.all():
        row.result_published = str(int(not row.result_unpublished))
        row.save(update_fields=['result_published'])


class Migration(migrations.Migration):
    dependencies = [
        ('vote', '0026_voter_invalid_email'),
    ]

    operations = [
        migrations.AddField(
            model_name='election',
            name='result_unpublished',
            field=models.BooleanField(default=True),
        ),
        migrations.RunPython(char2bool, reverse_code=bool2char),
        migrations.RemoveField(
            model_name='election',
            name='result_published'
        )
    ]
