# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pyrlottie']

package_data = \
{'': ['*'],
 'pyrlottie': ['_darwin_x86_64/*', 'linux_x86_64/*', 'windows_amd64/*']}

install_requires = \
['Pillow>=8.3.2,<9', 'attrs>=21.2.0,<22', 'numpy>=1.21.2,<2']

setup_kwargs = {
    'name': 'pyrlottie',
    'version': '2021.1',
    'description': 'Convert .tgs and .lottie to .webp or .gif using rlottie.',
    'long_description': '[![GitHub top language](https://img.shields.io/github/languages/top/FHPythonUtils/PyRlottie.svg?style=for-the-badge)](../../)\n[![Repository size](https://img.shields.io/github/repo-size/FHPythonUtils/PyRlottie.svg?style=for-the-badge)](../../)\n[![Issues](https://img.shields.io/github/issues/FHPythonUtils/PyRlottie.svg?style=for-the-badge)](../../issues)\n[![License](https://img.shields.io/github/license/FHPythonUtils/PyRlottie.svg?style=for-the-badge)](/LICENSE.md)\n[![Commit activity](https://img.shields.io/github/commit-activity/m/FHPythonUtils/PyRlottie.svg?style=for-the-badge)](../../commits/master)\n[![Last commit](https://img.shields.io/github/last-commit/FHPythonUtils/PyRlottie.svg?style=for-the-badge)](../../commits/master)\n[![PyPI Downloads](https://img.shields.io/pypi/dm/pyrlottie.svg?style=for-the-badge)](https://pypistats.org/packages/pyrlottie)\n[![PyPI Total Downloads](https://img.shields.io/badge/dynamic/json?style=for-the-badge&label=total%20downloads&query=%24.total_downloads&url=https%3A%2F%2Fapi.pepy.tech%2Fapi%2Fprojects%2Fpyrlottie)](https://pepy.tech/project/pyrlottie)\n[![PyPI Version](https://img.shields.io/pypi/v/pyrlottie.svg?style=for-the-badge)](https://pypi.org/project/pyrlottie)\n\n<!-- omit in TOC -->\n# PyRlottie\n\n<img src="readme-assets/icons/name.png" alt="Project Icon" width="750">\n\nConvert .tgs and .lottie to .webp or .gif using rlottie.\n\n- [Formats](#formats)\n- [Basic Usage](#basic-usage)\n- [Documentation](#documentation)\n- [Supported Environments (64bit)](#supported-environments-64bit)\n- [Install With PIP](#install-with-pip)\n\t- [WSL](#wsl)\n- [Language information](#language-information)\n\t- [Built for](#built-for)\n- [Install Python on Windows](#install-python-on-windows)\n\t- [Chocolatey](#chocolatey)\n\t- [Download](#download)\n- [Install Python on Linux](#install-python-on-linux)\n\t- [Apt](#apt)\n- [How to run](#how-to-run)\n\t- [With VSCode](#with-vscode)\n\t- [From the Terminal](#from-the-terminal)\n- [Download Project](#download-project)\n\t- [Clone](#clone)\n\t\t- [Using The Command Line](#using-the-command-line)\n\t\t- [Using GitHub Desktop](#using-github-desktop)\n\t- [Download Zip File](#download-zip-file)\n- [Community Files](#community-files)\n\t- [Licence](#licence)\n\t- [Changelog](#changelog)\n\t- [Code of Conduct](#code-of-conduct)\n\t- [Contributing](#contributing)\n\t- [Security](#security)\n\t- [Support](#support)\n\t- [Rationale](#rationale)\n\n## Formats\n\nconvMultLottie, convSingleLottie\n| Format | Animated |\n| ------ | -------- |\n| .gif   | ✔        |\n| .webp  | ✔        |\n\nconvMultLottieFrames,\nconvMultLottieTransparentFrames,\nconvSingleLottieFrames,\nconvSingleLottieTransparentFrames,\n| Format | Animated |\n| ------ | -------- |\n| .gif   | ✔        |\n| .webp  | ✔        |\n| .apng  | ✔        |\n| .png   | :x:      |\n| .jpg   | :x:      |\n| etc... | ...      |\n\nhttps://pillow.readthedocs.io/en/stable/handbook/image-file-formats.html\n\n## Basic Usage\n\nConvert multiple tgs files to webp\n\n```py\n# convMultLottie\nprint(\n\trun(\n\t\tconvMultLottie(\n\t\t\t[\n\t\t\t\tFileMap(LottieFile(f"test_data/file_43{i}.tgs"), {f"test_data/file_43{i}.webp"})\n\t\t\t\tfor i in range(4, 10)\n\t\t\t]\n\t\t)\n\t)\n)\n```\n\nConvert multiple tgs files to transparent frames dictionary of lottie file paths\nto LottieFrames. The list of pillow images can be accessed with .frames for each\nlottie file path\n\n```py\nframes = run(\n\tconvMultLottieTransparentFrames(\n\t\t[LottieFile(f"test_data/file_43{i}.tgs") for i in range(4, 10)], 1\n\t)\n)["test_data/file_434.tgs"].frames\n\n```\n\n## Documentation\nSee the [Docs](/DOCS/) for more information.\n\n## Supported Environments (64bit)\n\n| Environment | Supported |\n| ----------- | --------- |\n|linux_x86_64 | ✔         |\n|linux_aarch64| :x:       |\n|windows_amd64| ✔         |\n|darwin_x86_64| :x:       |\n|darwin_arm64 | :x:       |\n\nFor a full list of machine architecures for Linux see https://stackoverflow.com/questions/45125516/possible-values-for-uname-m\n\n## Install With PIP\n\n```cmd\npip install pyrlottie\n```\n\n### WSL\nNeed to preserve execute bits\n\n```cmd\nmkdir pip-tmp\nTMPDIR=\'./pip-tmp\' pip install pyrlottie && rmdir pip-tmp\n```\n\nhttps://github.com/pypa/pip/issues/7666\nhttps://github.com/pypa/pip/issues/6364\n\nHead to https://pypi.org/project/pyrlottie/ for more info\n\n## Language information\n### Built for\nThis program has been written for Python 3 and has been tested with\nPython version 3.9.0 <https://www.python.org/downloads/release/python-380/>.\n\n## Install Python on Windows\n### Chocolatey\n\n```powershell\nchoco install python\n```\n\n### Download\nTo install Python, go to <https://www.python.org/> and download the latest\nversion.\n\n## Install Python on Linux\n### Apt\n\n```bash\nsudo apt install python3.9\n```\n\n## How to run\n### With VSCode\n\n1. Open the .py file in vscode\n2. Ensure a python 3.9 interpreter is selected (Ctrl+Shift+P > Python:Select\nInterpreter > Python 3.9)\n3. Run by pressing Ctrl+F5 (if you are prompted to install any modules, accept)\n\n### From the Terminal\n\n```bash\n./[file].py\n```\n\n## Download Project\n### Clone\n#### Using The Command Line\n\n1. Press the Clone or download button in the top right\n2. Copy the URL (link)\n3. Open the command line and change directory to where you wish to\nclone to\n4. Type \'git clone\' followed by URL in step 2\n\n\t```bash\n\tgit clone https://github.com/FHPythonUtils/PyRlottie\n\t```\n\nMore information can be found at\n<https://help.github.com/en/articles/cloning-a-repository>\n\n#### Using GitHub Desktop\n\n1. Press the Clone or download button in the top right\n2. Click open in desktop\n3. Choose the path for where you want and click Clone\n\nMore information can be found at\n<https://help.github.com/en/desktop/contributing-to-projects/cloning-a-repository-from-github-to-github-desktop>\n\n### Download Zip File\n\n1. Download this GitHub repository\n2. Extract the zip archive\n3. Copy/ move to the desired location\n\n## Community Files\n### Licence\nMIT License\nCopyright (c) FredHappyface\n(See the [LICENSE](/LICENSE.md) for more information.)\n\n### Changelog\nSee the [Changelog](/CHANGELOG.md) for more information.\n\n### Code of Conduct\nOnline communities include people from many backgrounds. The *Project*\ncontributors are committed to providing a friendly, safe and welcoming\nenvironment for all. Please see the\n[Code of Conduct](https://github.com/FHPythonUtils/.github/blob/master/CODE_OF_CONDUCT.md)\n for more information.\n\n### Contributing\nContributions are welcome, please see the\n[Contributing Guidelines](https://github.com/FHPythonUtils/.github/blob/master/CONTRIBUTING.md)\nfor more information.\n\n### Security\nThank you for improving the security of the project, please see the\n[Security Policy](https://github.com/FHPythonUtils/.github/blob/master/SECURITY.md)\nfor more information.\n\n### Support\nThank you for using this project, I hope it is of use to you. Please be aware that\nthose involved with the project often do so for fun along with other commitments\n(such as work, family, etc). Please see the\n[Support Policy](https://github.com/FHPythonUtils/.github/blob/master/SUPPORT.md)\nfor more information.\n\n### Rationale\nThe rationale acts as a guide to various processes regarding projects such as\nthe versioning scheme and the programming styles used. Please see the\n[Rationale](https://github.com/FHPythonUtils/.github/blob/master/RATIONALE.md)\nfor more information.\n',
    'author': 'FredHappyface',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/FHPythonUtils/PyRlottie',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<3.11',
}


setup(**setup_kwargs)
