# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from . import utilities, tables

class Audit(pulumi.CustomResource):
    description: pulumi.Output[str]
    """
    Human-friendly description of the audit device.
    """
    options: pulumi.Output[dict]
    """
    Configuration options to pass to the audit device itself.
    """
    path: pulumi.Output[str]
    """
    The path to mount the audit device. This defaults to the type.
    """
    type: pulumi.Output[str]
    """
    Type of the audit device, such as 'file'.
    """
    def __init__(__self__, resource_name, opts=None, description=None, options=None, path=None, type=None, __props__=None, __name__=None, __opts__=None):
        """
        ## Example Usage (file audit device)

        ```python
        import pulumi
        import pulumi_vault as vault

        test = vault.Audit("test",
            options={
                "file_path": "C:/temp/audit.txt",
            },
            type="file")
        ```

        ## Example Usage (socket audit device)

        ```python
        import pulumi
        import pulumi_vault as vault

        test = vault.Audit("test",
            options={
                "address": "127.0.0.1:8000",
                "description": "application x socket",
                "socket_type": "tcp",
            },
            path="app_socket",
            type="socket")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Human-friendly description of the audit device.
        :param pulumi.Input[dict] options: Configuration options to pass to the audit device itself.
        :param pulumi.Input[str] path: The path to mount the audit device. This defaults to the type.
        :param pulumi.Input[str] type: Type of the audit device, such as 'file'.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            if options is None:
                raise TypeError("Missing required property 'options'")
            __props__['options'] = options
            __props__['path'] = path
            if type is None:
                raise TypeError("Missing required property 'type'")
            __props__['type'] = type
        super(Audit, __self__).__init__(
            'vault:index/audit:Audit',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, description=None, options=None, path=None, type=None):
        """
        Get an existing Audit resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Human-friendly description of the audit device.
        :param pulumi.Input[dict] options: Configuration options to pass to the audit device itself.
        :param pulumi.Input[str] path: The path to mount the audit device. This defaults to the type.
        :param pulumi.Input[str] type: Type of the audit device, such as 'file'.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["description"] = description
        __props__["options"] = options
        __props__["path"] = path
        __props__["type"] = type
        return Audit(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

