# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class AuthBackendLogin(pulumi.CustomResource):
    accessor: pulumi.Output[str]
    """
    The token's accessor.
    """
    auth_type: pulumi.Output[str]
    """
    The authentication type used to generate this token.
    """
    backend: pulumi.Output[str]
    """
    The unique name of the AWS auth backend. Defaults to
    'aws'.
    """
    client_token: pulumi.Output[str]
    """
    The token returned by Vault.
    """
    iam_http_request_method: pulumi.Output[str]
    """
    The HTTP method used in the signed IAM
    request.
    """
    iam_request_body: pulumi.Output[str]
    """
    The base64-encoded body of the signed
    request.
    """
    iam_request_headers: pulumi.Output[str]
    """
    The base64-encoded, JSON serialized
    representation of the GetCallerIdentity HTTP request headers.
    """
    iam_request_url: pulumi.Output[str]
    """
    The base64-encoded HTTP URL used in the signed
    request.
    """
    identity: pulumi.Output[str]
    """
    The base64-encoded EC2 instance identity document to
    authenticate with. Can be retrieved from the EC2 metadata server.
    """
    lease_duration: pulumi.Output[float]
    """
    The duration in seconds the token will be valid, relative
    to the time in `lease_start_time`.
    """
    lease_start_time: pulumi.Output[str]
    """
    Time at which the lease was read, using the clock of the system where Terraform was running
    """
    metadata: pulumi.Output[dict]
    """
    A map of information returned by the Vault server about the
    authentication used to generate this token.
    """
    nonce: pulumi.Output[str]
    """
    The unique nonce to be used for login requests. Can be
    set to a user-specified value, or will contain the server-generated value
    once a token is issued. EC2 instances can only acquire a single token until
    the whitelist is tidied again unless they keep track of this nonce.
    """
    pkcs7: pulumi.Output[str]
    """
    The PKCS#7 signature of the identity document to
    authenticate with, with all newline characters removed. Can be retrieved from
    the EC2 metadata server.
    """
    policies: pulumi.Output[list]
    """
    The Vault policies assigned to this token.
    """
    renewable: pulumi.Output[bool]
    """
    Set to true if the token can be extended through renewal.
    """
    role: pulumi.Output[str]
    """
    The name of the AWS auth backend role to create tokens
    against.
    """
    signature: pulumi.Output[str]
    """
    The base64-encoded SHA256 RSA signature of the
    instance identity document to authenticate with, with all newline characters
    removed. Can be retrieved from the EC2 metadata server.
    """
    def __init__(__self__, resource_name, opts=None, backend=None, iam_http_request_method=None, iam_request_body=None, iam_request_headers=None, iam_request_url=None, identity=None, nonce=None, pkcs7=None, role=None, signature=None, __props__=None, __name__=None, __opts__=None):
        """
        Logs into a Vault server using an AWS auth backend. Login can be
        accomplished using a signed identity request from IAM or using ec2
        instance metadata. For more information, see the [Vault
        documentation](https://www.vaultproject.io/docs/auth/aws.html).

        ## Example Usage



        ```python
        import pulumi
        import pulumi_vault as vault

        aws = vault.AuthBackend("aws", type="aws")
        example_auth_backend_client = vault.aws.AuthBackendClient("exampleAuthBackendClient",
            access_key="123456789012",
            backend=aws.path,
            secret_key="AWSSECRETKEYGOESHERE")
        example_auth_backend_role = vault.aws.AuthBackendRole("exampleAuthBackendRole",
            auth_type="ec2",
            backend=aws.path,
            bound_account_id="123456789012",
            bound_ami_id="ami-8c1be5f6",
            bound_iam_instance_profile_arn="arn:aws:iam::123456789012:instance-profile/MyProfile",
            bound_subnet_id="vpc-133128f1",
            bound_vpc_id="vpc-b61106d4",
            max_ttl=120,
            role="test-role",
            token_policies=[
                "default",
                "dev",
                "prod",
            ],
            ttl=60)
        example_auth_backend_login = vault.aws.AuthBackendLogin("exampleAuthBackendLogin",
            backend=vault_auth_backend["example"]["path"],
            identity="BASE64ENCODEDIDENTITYDOCUMENT",
            role=example_auth_backend_role.role,
            signature="BASE64ENCODEDSHA256IDENTITYDOCUMENTSIGNATURE")
        ```


        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The unique name of the AWS auth backend. Defaults to
               'aws'.
        :param pulumi.Input[str] iam_http_request_method: The HTTP method used in the signed IAM
               request.
        :param pulumi.Input[str] iam_request_body: The base64-encoded body of the signed
               request.
        :param pulumi.Input[str] iam_request_headers: The base64-encoded, JSON serialized
               representation of the GetCallerIdentity HTTP request headers.
        :param pulumi.Input[str] iam_request_url: The base64-encoded HTTP URL used in the signed
               request.
        :param pulumi.Input[str] identity: The base64-encoded EC2 instance identity document to
               authenticate with. Can be retrieved from the EC2 metadata server.
        :param pulumi.Input[str] nonce: The unique nonce to be used for login requests. Can be
               set to a user-specified value, or will contain the server-generated value
               once a token is issued. EC2 instances can only acquire a single token until
               the whitelist is tidied again unless they keep track of this nonce.
        :param pulumi.Input[str] pkcs7: The PKCS#7 signature of the identity document to
               authenticate with, with all newline characters removed. Can be retrieved from
               the EC2 metadata server.
        :param pulumi.Input[str] role: The name of the AWS auth backend role to create tokens
               against.
        :param pulumi.Input[str] signature: The base64-encoded SHA256 RSA signature of the
               instance identity document to authenticate with, with all newline characters
               removed. Can be retrieved from the EC2 metadata server.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['backend'] = backend
            __props__['iam_http_request_method'] = iam_http_request_method
            __props__['iam_request_body'] = iam_request_body
            __props__['iam_request_headers'] = iam_request_headers
            __props__['iam_request_url'] = iam_request_url
            __props__['identity'] = identity
            __props__['nonce'] = nonce
            __props__['pkcs7'] = pkcs7
            __props__['role'] = role
            __props__['signature'] = signature
            __props__['accessor'] = None
            __props__['auth_type'] = None
            __props__['client_token'] = None
            __props__['lease_duration'] = None
            __props__['lease_start_time'] = None
            __props__['metadata'] = None
            __props__['policies'] = None
            __props__['renewable'] = None
        super(AuthBackendLogin, __self__).__init__(
            'vault:aws/authBackendLogin:AuthBackendLogin',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, accessor=None, auth_type=None, backend=None, client_token=None, iam_http_request_method=None, iam_request_body=None, iam_request_headers=None, iam_request_url=None, identity=None, lease_duration=None, lease_start_time=None, metadata=None, nonce=None, pkcs7=None, policies=None, renewable=None, role=None, signature=None):
        """
        Get an existing AuthBackendLogin resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessor: The token's accessor.
        :param pulumi.Input[str] auth_type: The authentication type used to generate this token.
        :param pulumi.Input[str] backend: The unique name of the AWS auth backend. Defaults to
               'aws'.
        :param pulumi.Input[str] client_token: The token returned by Vault.
        :param pulumi.Input[str] iam_http_request_method: The HTTP method used in the signed IAM
               request.
        :param pulumi.Input[str] iam_request_body: The base64-encoded body of the signed
               request.
        :param pulumi.Input[str] iam_request_headers: The base64-encoded, JSON serialized
               representation of the GetCallerIdentity HTTP request headers.
        :param pulumi.Input[str] iam_request_url: The base64-encoded HTTP URL used in the signed
               request.
        :param pulumi.Input[str] identity: The base64-encoded EC2 instance identity document to
               authenticate with. Can be retrieved from the EC2 metadata server.
        :param pulumi.Input[float] lease_duration: The duration in seconds the token will be valid, relative
               to the time in `lease_start_time`.
        :param pulumi.Input[str] lease_start_time: Time at which the lease was read, using the clock of the system where Terraform was running
        :param pulumi.Input[dict] metadata: A map of information returned by the Vault server about the
               authentication used to generate this token.
        :param pulumi.Input[str] nonce: The unique nonce to be used for login requests. Can be
               set to a user-specified value, or will contain the server-generated value
               once a token is issued. EC2 instances can only acquire a single token until
               the whitelist is tidied again unless they keep track of this nonce.
        :param pulumi.Input[str] pkcs7: The PKCS#7 signature of the identity document to
               authenticate with, with all newline characters removed. Can be retrieved from
               the EC2 metadata server.
        :param pulumi.Input[list] policies: The Vault policies assigned to this token.
        :param pulumi.Input[bool] renewable: Set to true if the token can be extended through renewal.
        :param pulumi.Input[str] role: The name of the AWS auth backend role to create tokens
               against.
        :param pulumi.Input[str] signature: The base64-encoded SHA256 RSA signature of the
               instance identity document to authenticate with, with all newline characters
               removed. Can be retrieved from the EC2 metadata server.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["accessor"] = accessor
        __props__["auth_type"] = auth_type
        __props__["backend"] = backend
        __props__["client_token"] = client_token
        __props__["iam_http_request_method"] = iam_http_request_method
        __props__["iam_request_body"] = iam_request_body
        __props__["iam_request_headers"] = iam_request_headers
        __props__["iam_request_url"] = iam_request_url
        __props__["identity"] = identity
        __props__["lease_duration"] = lease_duration
        __props__["lease_start_time"] = lease_start_time
        __props__["metadata"] = metadata
        __props__["nonce"] = nonce
        __props__["pkcs7"] = pkcs7
        __props__["policies"] = policies
        __props__["renewable"] = renewable
        __props__["role"] = role
        __props__["signature"] = signature
        return AuthBackendLogin(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

