# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import json
import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables

class SecretBackendConnection(pulumi.CustomResource):
    allowed_roles: pulumi.Output[list]
    """
    A list of roles that are allowed to use this
    connection.
    """
    backend: pulumi.Output[str]
    """
    The unique name of the Vault mount to configure.
    """
    cassandra: pulumi.Output[dict]
    """
    A nested block containing configuration options for Cassandra connections.

      * `connectTimeout` (`float`) - The number of seconds to use as a connection
        timeout.
      * `hosts` (`list`) - The hosts to connect to.
      * `insecure_tls` (`bool`) - Whether to skip verification of the server
        certificate when using TLS.
      * `password` (`str`) - The password to be used in the connection.
      * `pem_bundle` (`str`) - Concatenated PEM blocks configuring the certificate
        chain.
      * `pemJson` (`str`) - A JSON structure configuring the certificate chain.
      * `port` (`float`) - The default port to connect to if no port is specified as
        part of the host.
      * `protocolVersion` (`float`) - The CQL protocol version to use.
      * `tls` (`bool`) - Whether to use TLS when connecting to Cassandra.
      * `username` (`str`) - The username to be used in the connection.
    """
    data: pulumi.Output[dict]
    """
    A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
    """
    elasticsearch: pulumi.Output[dict]
    """
    A nested block containing configuration options for Elasticsearch connections.

      * `password` (`str`) - The password to be used in the connection.
      * `url` (`str`) - The URL for Elasticsearch's API. https requires certificate
        by trusted CA if used.
      * `username` (`str`) - The username to be used in the connection.
    """
    hana: pulumi.Output[dict]
    """
    A nested block containing configuration options for SAP HanaDB connections.

      * `connectionUrl` (`str`) - A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
      * `maxConnectionLifetime` (`float`) - The maximum number of seconds to keep
        a connection alive for.
      * `maxIdleConnections` (`float`) - The maximum number of idle connections to
        maintain.
      * `maxOpenConnections` (`float`) - The maximum number of open connections to
        use.
    """
    mongodb: pulumi.Output[dict]
    """
    A nested block containing configuration options for MongoDB connections.

      * `connectionUrl` (`str`) - A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
      * `maxConnectionLifetime` (`float`) - The maximum number of seconds to keep
        a connection alive for.
      * `maxIdleConnections` (`float`) - The maximum number of idle connections to
        maintain.
      * `maxOpenConnections` (`float`) - The maximum number of open connections to
        use.
    """
    mssql: pulumi.Output[dict]
    """
    A nested block containing configuration options for MSSQL connections.

      * `connectionUrl` (`str`) - A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
      * `maxConnectionLifetime` (`float`) - The maximum number of seconds to keep
        a connection alive for.
      * `maxIdleConnections` (`float`) - The maximum number of idle connections to
        maintain.
      * `maxOpenConnections` (`float`) - The maximum number of open connections to
        use.
    """
    mysql: pulumi.Output[dict]
    """
    A nested block containing configuration options for MySQL connections.

      * `connectionUrl` (`str`) - A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
      * `maxConnectionLifetime` (`float`) - The maximum number of seconds to keep
        a connection alive for.
      * `maxIdleConnections` (`float`) - The maximum number of idle connections to
        maintain.
      * `maxOpenConnections` (`float`) - The maximum number of open connections to
        use.
    """
    mysql_aurora: pulumi.Output[dict]
    """
    A nested block containing configuration options for Aurora MySQL connections.

      * `connectionUrl` (`str`) - A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
      * `maxConnectionLifetime` (`float`) - The maximum number of seconds to keep
        a connection alive for.
      * `maxIdleConnections` (`float`) - The maximum number of idle connections to
        maintain.
      * `maxOpenConnections` (`float`) - The maximum number of open connections to
        use.
    """
    mysql_legacy: pulumi.Output[dict]
    """
    A nested block containing configuration options for legacy MySQL connections.

      * `connectionUrl` (`str`) - A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
      * `maxConnectionLifetime` (`float`) - The maximum number of seconds to keep
        a connection alive for.
      * `maxIdleConnections` (`float`) - The maximum number of idle connections to
        maintain.
      * `maxOpenConnections` (`float`) - The maximum number of open connections to
        use.
    """
    mysql_rds: pulumi.Output[dict]
    """
    A nested block containing configuration options for RDS MySQL connections.

      * `connectionUrl` (`str`) - A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
      * `maxConnectionLifetime` (`float`) - The maximum number of seconds to keep
        a connection alive for.
      * `maxIdleConnections` (`float`) - The maximum number of idle connections to
        maintain.
      * `maxOpenConnections` (`float`) - The maximum number of open connections to
        use.
    """
    name: pulumi.Output[str]
    """
    A unique name to give the database connection.
    """
    oracle: pulumi.Output[dict]
    """
    A nested block containing configuration options for Oracle connections.

      * `connectionUrl` (`str`) - A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
      * `maxConnectionLifetime` (`float`) - The maximum number of seconds to keep
        a connection alive for.
      * `maxIdleConnections` (`float`) - The maximum number of idle connections to
        maintain.
      * `maxOpenConnections` (`float`) - The maximum number of open connections to
        use.
    """
    postgresql: pulumi.Output[dict]
    """
    A nested block containing configuration options for PostgreSQL connections.

      * `connectionUrl` (`str`) - A URL containing connection information. See
        the [Vault
        docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
        for an example.
      * `maxConnectionLifetime` (`float`) - The maximum number of seconds to keep
        a connection alive for.
      * `maxIdleConnections` (`float`) - The maximum number of idle connections to
        maintain.
      * `maxOpenConnections` (`float`) - The maximum number of open connections to
        use.
    """
    root_rotation_statements: pulumi.Output[list]
    """
    A list of database statements to be executed to rotate the root user's credentials.
    """
    verify_connection: pulumi.Output[bool]
    """
    Whether the connection should be verified on
    initial configuration or not.
    """
    def __init__(__self__, resource_name, opts=None, allowed_roles=None, backend=None, cassandra=None, data=None, elasticsearch=None, hana=None, mongodb=None, mssql=None, mysql=None, mysql_aurora=None, mysql_legacy=None, mysql_rds=None, name=None, oracle=None, postgresql=None, root_rotation_statements=None, verify_connection=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a SecretBackendConnection resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param pulumi.Input[str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[dict] cassandra: A nested block containing configuration options for Cassandra connections.
        :param pulumi.Input[dict] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param pulumi.Input[dict] elasticsearch: A nested block containing configuration options for Elasticsearch connections.
        :param pulumi.Input[dict] hana: A nested block containing configuration options for SAP HanaDB connections.
        :param pulumi.Input[dict] mongodb: A nested block containing configuration options for MongoDB connections.
        :param pulumi.Input[dict] mssql: A nested block containing configuration options for MSSQL connections.
        :param pulumi.Input[dict] mysql: A nested block containing configuration options for MySQL connections.
        :param pulumi.Input[dict] mysql_aurora: A nested block containing configuration options for Aurora MySQL connections.
        :param pulumi.Input[dict] mysql_legacy: A nested block containing configuration options for legacy MySQL connections.
        :param pulumi.Input[dict] mysql_rds: A nested block containing configuration options for RDS MySQL connections.
        :param pulumi.Input[str] name: A unique name to give the database connection.
        :param pulumi.Input[dict] oracle: A nested block containing configuration options for Oracle connections.
        :param pulumi.Input[dict] postgresql: A nested block containing configuration options for PostgreSQL connections.
        :param pulumi.Input[list] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param pulumi.Input[bool] verify_connection: Whether the connection should be verified on
               initial configuration or not.

        The **cassandra** object supports the following:

          * `connectTimeout` (`pulumi.Input[float]`) - The number of seconds to use as a connection
            timeout.
          * `hosts` (`pulumi.Input[list]`) - The hosts to connect to.
          * `insecure_tls` (`pulumi.Input[bool]`) - Whether to skip verification of the server
            certificate when using TLS.
          * `password` (`pulumi.Input[str]`) - The password to be used in the connection.
          * `pem_bundle` (`pulumi.Input[str]`) - Concatenated PEM blocks configuring the certificate
            chain.
          * `pemJson` (`pulumi.Input[str]`) - A JSON structure configuring the certificate chain.
          * `port` (`pulumi.Input[float]`) - The default port to connect to if no port is specified as
            part of the host.
          * `protocolVersion` (`pulumi.Input[float]`) - The CQL protocol version to use.
          * `tls` (`pulumi.Input[bool]`) - Whether to use TLS when connecting to Cassandra.
          * `username` (`pulumi.Input[str]`) - The username to be used in the connection.

        The **elasticsearch** object supports the following:

          * `password` (`pulumi.Input[str]`) - The password to be used in the connection.
          * `url` (`pulumi.Input[str]`) - The URL for Elasticsearch's API. https requires certificate
            by trusted CA if used.
          * `username` (`pulumi.Input[str]`) - The username to be used in the connection.

        The **hana** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.

        The **mongodb** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.

        The **mssql** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.

        The **mysql** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.

        The **mysql_aurora** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.

        The **mysql_legacy** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.

        The **mysql_rds** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.

        The **oracle** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.

        The **postgresql** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['allowed_roles'] = allowed_roles
            if backend is None:
                raise TypeError("Missing required property 'backend'")
            __props__['backend'] = backend
            __props__['cassandra'] = cassandra
            __props__['data'] = data
            __props__['elasticsearch'] = elasticsearch
            __props__['hana'] = hana
            __props__['mongodb'] = mongodb
            __props__['mssql'] = mssql
            __props__['mysql'] = mysql
            __props__['mysql_aurora'] = mysql_aurora
            __props__['mysql_legacy'] = mysql_legacy
            __props__['mysql_rds'] = mysql_rds
            __props__['name'] = name
            __props__['oracle'] = oracle
            __props__['postgresql'] = postgresql
            __props__['root_rotation_statements'] = root_rotation_statements
            __props__['verify_connection'] = verify_connection
        super(SecretBackendConnection, __self__).__init__(
            'vault:database/secretBackendConnection:SecretBackendConnection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, allowed_roles=None, backend=None, cassandra=None, data=None, elasticsearch=None, hana=None, mongodb=None, mssql=None, mysql=None, mysql_aurora=None, mysql_legacy=None, mysql_rds=None, name=None, oracle=None, postgresql=None, root_rotation_statements=None, verify_connection=None):
        """
        Get an existing SecretBackendConnection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[list] allowed_roles: A list of roles that are allowed to use this
               connection.
        :param pulumi.Input[str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[dict] cassandra: A nested block containing configuration options for Cassandra connections.
        :param pulumi.Input[dict] data: A map of sensitive data to pass to the endpoint. Useful for templated connection strings.
        :param pulumi.Input[dict] elasticsearch: A nested block containing configuration options for Elasticsearch connections.
        :param pulumi.Input[dict] hana: A nested block containing configuration options for SAP HanaDB connections.
        :param pulumi.Input[dict] mongodb: A nested block containing configuration options for MongoDB connections.
        :param pulumi.Input[dict] mssql: A nested block containing configuration options for MSSQL connections.
        :param pulumi.Input[dict] mysql: A nested block containing configuration options for MySQL connections.
        :param pulumi.Input[dict] mysql_aurora: A nested block containing configuration options for Aurora MySQL connections.
        :param pulumi.Input[dict] mysql_legacy: A nested block containing configuration options for legacy MySQL connections.
        :param pulumi.Input[dict] mysql_rds: A nested block containing configuration options for RDS MySQL connections.
        :param pulumi.Input[str] name: A unique name to give the database connection.
        :param pulumi.Input[dict] oracle: A nested block containing configuration options for Oracle connections.
        :param pulumi.Input[dict] postgresql: A nested block containing configuration options for PostgreSQL connections.
        :param pulumi.Input[list] root_rotation_statements: A list of database statements to be executed to rotate the root user's credentials.
        :param pulumi.Input[bool] verify_connection: Whether the connection should be verified on
               initial configuration or not.

        The **cassandra** object supports the following:

          * `connectTimeout` (`pulumi.Input[float]`) - The number of seconds to use as a connection
            timeout.
          * `hosts` (`pulumi.Input[list]`) - The hosts to connect to.
          * `insecure_tls` (`pulumi.Input[bool]`) - Whether to skip verification of the server
            certificate when using TLS.
          * `password` (`pulumi.Input[str]`) - The password to be used in the connection.
          * `pem_bundle` (`pulumi.Input[str]`) - Concatenated PEM blocks configuring the certificate
            chain.
          * `pemJson` (`pulumi.Input[str]`) - A JSON structure configuring the certificate chain.
          * `port` (`pulumi.Input[float]`) - The default port to connect to if no port is specified as
            part of the host.
          * `protocolVersion` (`pulumi.Input[float]`) - The CQL protocol version to use.
          * `tls` (`pulumi.Input[bool]`) - Whether to use TLS when connecting to Cassandra.
          * `username` (`pulumi.Input[str]`) - The username to be used in the connection.

        The **elasticsearch** object supports the following:

          * `password` (`pulumi.Input[str]`) - The password to be used in the connection.
          * `url` (`pulumi.Input[str]`) - The URL for Elasticsearch's API. https requires certificate
            by trusted CA if used.
          * `username` (`pulumi.Input[str]`) - The username to be used in the connection.

        The **hana** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.

        The **mongodb** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.

        The **mssql** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.

        The **mysql** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.

        The **mysql_aurora** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.

        The **mysql_legacy** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.

        The **mysql_rds** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.

        The **oracle** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.

        The **postgresql** object supports the following:

          * `connectionUrl` (`pulumi.Input[str]`) - A URL containing connection information. See
            the [Vault
            docs](https://www.vaultproject.io/api-docs/secret/databases/oracle.html#sample-payload)
            for an example.
          * `maxConnectionLifetime` (`pulumi.Input[float]`) - The maximum number of seconds to keep
            a connection alive for.
          * `maxIdleConnections` (`pulumi.Input[float]`) - The maximum number of idle connections to
            maintain.
          * `maxOpenConnections` (`pulumi.Input[float]`) - The maximum number of open connections to
            use.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["allowed_roles"] = allowed_roles
        __props__["backend"] = backend
        __props__["cassandra"] = cassandra
        __props__["data"] = data
        __props__["elasticsearch"] = elasticsearch
        __props__["hana"] = hana
        __props__["mongodb"] = mongodb
        __props__["mssql"] = mssql
        __props__["mysql"] = mysql
        __props__["mysql_aurora"] = mysql_aurora
        __props__["mysql_legacy"] = mysql_legacy
        __props__["mysql_rds"] = mysql_rds
        __props__["name"] = name
        __props__["oracle"] = oracle
        __props__["postgresql"] = postgresql
        __props__["root_rotation_statements"] = root_rotation_statements
        __props__["verify_connection"] = verify_connection
        return SecretBackendConnection(resource_name, opts=opts, __props__=__props__)
    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

