# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['KafkaTopicArgs', 'KafkaTopic']

@pulumi.input_type
class KafkaTopicArgs:
    def __init__(__self__, *,
                 cleanup_policy: pulumi.Input[str],
                 cluster_id: pulumi.Input[str],
                 max_message_size: pulumi.Input[int],
                 partitions: pulumi.Input[int],
                 retention_size: pulumi.Input[int],
                 retention_time: pulumi.Input[int],
                 topic_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a KafkaTopic resource.
        :param pulumi.Input[str] cleanup_policy: Cleanup policy will be used in the topic(compact or delete)
        :param pulumi.Input[str] cluster_id: ID of the cluster the topic will be deployed in
        :param pulumi.Input[int] max_message_size: Max message size in the topic
        :param pulumi.Input[int] partitions: The number of partitions the topic will have
        :param pulumi.Input[int] retention_size: Retention size of the messages in the topic
        :param pulumi.Input[int] retention_time: Retention time of messages in the topic
        :param pulumi.Input[str] topic_name: Name of the topic
        """
        pulumi.set(__self__, "cleanup_policy", cleanup_policy)
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "max_message_size", max_message_size)
        pulumi.set(__self__, "partitions", partitions)
        pulumi.set(__self__, "retention_size", retention_size)
        pulumi.set(__self__, "retention_time", retention_time)
        pulumi.set(__self__, "topic_name", topic_name)

    @property
    @pulumi.getter(name="cleanupPolicy")
    def cleanup_policy(self) -> pulumi.Input[str]:
        """
        Cleanup policy will be used in the topic(compact or delete)
        """
        return pulumi.get(self, "cleanup_policy")

    @cleanup_policy.setter
    def cleanup_policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "cleanup_policy", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        ID of the cluster the topic will be deployed in
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="maxMessageSize")
    def max_message_size(self) -> pulumi.Input[int]:
        """
        Max message size in the topic
        """
        return pulumi.get(self, "max_message_size")

    @max_message_size.setter
    def max_message_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "max_message_size", value)

    @property
    @pulumi.getter
    def partitions(self) -> pulumi.Input[int]:
        """
        The number of partitions the topic will have
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: pulumi.Input[int]):
        pulumi.set(self, "partitions", value)

    @property
    @pulumi.getter(name="retentionSize")
    def retention_size(self) -> pulumi.Input[int]:
        """
        Retention size of the messages in the topic
        """
        return pulumi.get(self, "retention_size")

    @retention_size.setter
    def retention_size(self, value: pulumi.Input[int]):
        pulumi.set(self, "retention_size", value)

    @property
    @pulumi.getter(name="retentionTime")
    def retention_time(self) -> pulumi.Input[int]:
        """
        Retention time of messages in the topic
        """
        return pulumi.get(self, "retention_time")

    @retention_time.setter
    def retention_time(self, value: pulumi.Input[int]):
        pulumi.set(self, "retention_time", value)

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> pulumi.Input[str]:
        """
        Name of the topic
        """
        return pulumi.get(self, "topic_name")

    @topic_name.setter
    def topic_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_name", value)


@pulumi.input_type
class _KafkaTopicState:
    def __init__(__self__, *,
                 cleanup_policy: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[int]] = None,
                 max_message_size: Optional[pulumi.Input[int]] = None,
                 multizone: Optional[pulumi.Input[bool]] = None,
                 partitions: Optional[pulumi.Input[int]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rest_endpoint: Optional[pulumi.Input[str]] = None,
                 retention_size: Optional[pulumi.Input[int]] = None,
                 retention_time: Optional[pulumi.Input[int]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tcp_endpoint: Optional[pulumi.Input[str]] = None,
                 topic_id: Optional[pulumi.Input[str]] = None,
                 topic_name: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering KafkaTopic resources.
        :param pulumi.Input[str] cleanup_policy: Cleanup policy will be used in the topic(compact or delete)
        :param pulumi.Input[str] cluster_id: ID of the cluster the topic will be deployed in
        :param pulumi.Input[int] creation_time: Creation time of the topic
        :param pulumi.Input[int] max_message_size: Max message size in the topic
        :param pulumi.Input[bool] multizone: Whether multizone replication is enabled
        :param pulumi.Input[int] partitions: The number of partitions the topic will have
        :param pulumi.Input[str] password: Password to be used in authenticating to the cluster
        :param pulumi.Input[str] region: Region of the kafka topic
        :param pulumi.Input[str] rest_endpoint: REST Endpoint of the kafka topic
        :param pulumi.Input[int] retention_size: Retention size of the messages in the topic
        :param pulumi.Input[int] retention_time: Retention time of messages in the topic
        :param pulumi.Input[str] state: State of the kafka topic (active or deleted)
        :param pulumi.Input[str] tcp_endpoint: TCP Endpoint of the kafka topic
        :param pulumi.Input[str] topic_id: Unique Cluster ID for created topic
        :param pulumi.Input[str] topic_name: Name of the topic
        :param pulumi.Input[str] username: Base64 encoded username to be used in authenticating to the cluster
        """
        if cleanup_policy is not None:
            pulumi.set(__self__, "cleanup_policy", cleanup_policy)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if max_message_size is not None:
            pulumi.set(__self__, "max_message_size", max_message_size)
        if multizone is not None:
            pulumi.set(__self__, "multizone", multizone)
        if partitions is not None:
            pulumi.set(__self__, "partitions", partitions)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rest_endpoint is not None:
            pulumi.set(__self__, "rest_endpoint", rest_endpoint)
        if retention_size is not None:
            pulumi.set(__self__, "retention_size", retention_size)
        if retention_time is not None:
            pulumi.set(__self__, "retention_time", retention_time)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tcp_endpoint is not None:
            pulumi.set(__self__, "tcp_endpoint", tcp_endpoint)
        if topic_id is not None:
            pulumi.set(__self__, "topic_id", topic_id)
        if topic_name is not None:
            pulumi.set(__self__, "topic_name", topic_name)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="cleanupPolicy")
    def cleanup_policy(self) -> Optional[pulumi.Input[str]]:
        """
        Cleanup policy will be used in the topic(compact or delete)
        """
        return pulumi.get(self, "cleanup_policy")

    @cleanup_policy.setter
    def cleanup_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cleanup_policy", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the cluster the topic will be deployed in
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[int]]:
        """
        Creation time of the topic
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="maxMessageSize")
    def max_message_size(self) -> Optional[pulumi.Input[int]]:
        """
        Max message size in the topic
        """
        return pulumi.get(self, "max_message_size")

    @max_message_size.setter
    def max_message_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_message_size", value)

    @property
    @pulumi.getter
    def multizone(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether multizone replication is enabled
        """
        return pulumi.get(self, "multizone")

    @multizone.setter
    def multizone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multizone", value)

    @property
    @pulumi.getter
    def partitions(self) -> Optional[pulumi.Input[int]]:
        """
        The number of partitions the topic will have
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "partitions", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password to be used in authenticating to the cluster
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region of the kafka topic
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        REST Endpoint of the kafka topic
        """
        return pulumi.get(self, "rest_endpoint")

    @rest_endpoint.setter
    def rest_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rest_endpoint", value)

    @property
    @pulumi.getter(name="retentionSize")
    def retention_size(self) -> Optional[pulumi.Input[int]]:
        """
        Retention size of the messages in the topic
        """
        return pulumi.get(self, "retention_size")

    @retention_size.setter
    def retention_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_size", value)

    @property
    @pulumi.getter(name="retentionTime")
    def retention_time(self) -> Optional[pulumi.Input[int]]:
        """
        Retention time of messages in the topic
        """
        return pulumi.get(self, "retention_time")

    @retention_time.setter
    def retention_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "retention_time", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the kafka topic (active or deleted)
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="tcpEndpoint")
    def tcp_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        TCP Endpoint of the kafka topic
        """
        return pulumi.get(self, "tcp_endpoint")

    @tcp_endpoint.setter
    def tcp_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tcp_endpoint", value)

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique Cluster ID for created topic
        """
        return pulumi.get(self, "topic_id")

    @topic_id.setter
    def topic_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_id", value)

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the topic
        """
        return pulumi.get(self, "topic_name")

    @topic_name.setter
    def topic_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_name", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Base64 encoded username to be used in authenticating to the cluster
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


class KafkaTopic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cleanup_policy: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 max_message_size: Optional[pulumi.Input[int]] = None,
                 partitions: Optional[pulumi.Input[int]] = None,
                 retention_size: Optional[pulumi.Input[int]] = None,
                 retention_time: Optional[pulumi.Input[int]] = None,
                 topic_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import upstash_pulumi as upstash

        # Not necessary if the topic belongs to an already created cluster.
        example_kafka_cluster = upstash.KafkaCluster("exampleKafkaCluster",
            cluster_name="Terraform_Upstash_Cluster",
            region="eu-west-1",
            multizone=False)
        example_kafka_topic = upstash.KafkaTopic("exampleKafkaTopic",
            topic_name="TerraformTopic",
            partitions=1,
            retention_time=625135,
            retention_size=725124,
            max_message_size=829213,
            cleanup_policy="delete",
            cluster_id=resource["upstash_kafka_cluster"]["exampleKafkaCluster"]["cluster_id"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cleanup_policy: Cleanup policy will be used in the topic(compact or delete)
        :param pulumi.Input[str] cluster_id: ID of the cluster the topic will be deployed in
        :param pulumi.Input[int] max_message_size: Max message size in the topic
        :param pulumi.Input[int] partitions: The number of partitions the topic will have
        :param pulumi.Input[int] retention_size: Retention size of the messages in the topic
        :param pulumi.Input[int] retention_time: Retention time of messages in the topic
        :param pulumi.Input[str] topic_name: Name of the topic
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KafkaTopicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import upstash_pulumi as upstash

        # Not necessary if the topic belongs to an already created cluster.
        example_kafka_cluster = upstash.KafkaCluster("exampleKafkaCluster",
            cluster_name="Terraform_Upstash_Cluster",
            region="eu-west-1",
            multizone=False)
        example_kafka_topic = upstash.KafkaTopic("exampleKafkaTopic",
            topic_name="TerraformTopic",
            partitions=1,
            retention_time=625135,
            retention_size=725124,
            max_message_size=829213,
            cleanup_policy="delete",
            cluster_id=resource["upstash_kafka_cluster"]["exampleKafkaCluster"]["cluster_id"])
        ```

        :param str resource_name: The name of the resource.
        :param KafkaTopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KafkaTopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cleanup_policy: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 max_message_size: Optional[pulumi.Input[int]] = None,
                 partitions: Optional[pulumi.Input[int]] = None,
                 retention_size: Optional[pulumi.Input[int]] = None,
                 retention_time: Optional[pulumi.Input[int]] = None,
                 topic_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KafkaTopicArgs.__new__(KafkaTopicArgs)

            if cleanup_policy is None and not opts.urn:
                raise TypeError("Missing required property 'cleanup_policy'")
            __props__.__dict__["cleanup_policy"] = cleanup_policy
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if max_message_size is None and not opts.urn:
                raise TypeError("Missing required property 'max_message_size'")
            __props__.__dict__["max_message_size"] = max_message_size
            if partitions is None and not opts.urn:
                raise TypeError("Missing required property 'partitions'")
            __props__.__dict__["partitions"] = partitions
            if retention_size is None and not opts.urn:
                raise TypeError("Missing required property 'retention_size'")
            __props__.__dict__["retention_size"] = retention_size
            if retention_time is None and not opts.urn:
                raise TypeError("Missing required property 'retention_time'")
            __props__.__dict__["retention_time"] = retention_time
            if topic_name is None and not opts.urn:
                raise TypeError("Missing required property 'topic_name'")
            __props__.__dict__["topic_name"] = topic_name
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["multizone"] = None
            __props__.__dict__["password"] = None
            __props__.__dict__["region"] = None
            __props__.__dict__["rest_endpoint"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["tcp_endpoint"] = None
            __props__.__dict__["topic_id"] = None
            __props__.__dict__["username"] = None
        super(KafkaTopic, __self__).__init__(
            'upstash:index/kafkaTopic:KafkaTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cleanup_policy: Optional[pulumi.Input[str]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            creation_time: Optional[pulumi.Input[int]] = None,
            max_message_size: Optional[pulumi.Input[int]] = None,
            multizone: Optional[pulumi.Input[bool]] = None,
            partitions: Optional[pulumi.Input[int]] = None,
            password: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            rest_endpoint: Optional[pulumi.Input[str]] = None,
            retention_size: Optional[pulumi.Input[int]] = None,
            retention_time: Optional[pulumi.Input[int]] = None,
            state: Optional[pulumi.Input[str]] = None,
            tcp_endpoint: Optional[pulumi.Input[str]] = None,
            topic_id: Optional[pulumi.Input[str]] = None,
            topic_name: Optional[pulumi.Input[str]] = None,
            username: Optional[pulumi.Input[str]] = None) -> 'KafkaTopic':
        """
        Get an existing KafkaTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cleanup_policy: Cleanup policy will be used in the topic(compact or delete)
        :param pulumi.Input[str] cluster_id: ID of the cluster the topic will be deployed in
        :param pulumi.Input[int] creation_time: Creation time of the topic
        :param pulumi.Input[int] max_message_size: Max message size in the topic
        :param pulumi.Input[bool] multizone: Whether multizone replication is enabled
        :param pulumi.Input[int] partitions: The number of partitions the topic will have
        :param pulumi.Input[str] password: Password to be used in authenticating to the cluster
        :param pulumi.Input[str] region: Region of the kafka topic
        :param pulumi.Input[str] rest_endpoint: REST Endpoint of the kafka topic
        :param pulumi.Input[int] retention_size: Retention size of the messages in the topic
        :param pulumi.Input[int] retention_time: Retention time of messages in the topic
        :param pulumi.Input[str] state: State of the kafka topic (active or deleted)
        :param pulumi.Input[str] tcp_endpoint: TCP Endpoint of the kafka topic
        :param pulumi.Input[str] topic_id: Unique Cluster ID for created topic
        :param pulumi.Input[str] topic_name: Name of the topic
        :param pulumi.Input[str] username: Base64 encoded username to be used in authenticating to the cluster
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KafkaTopicState.__new__(_KafkaTopicState)

        __props__.__dict__["cleanup_policy"] = cleanup_policy
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["max_message_size"] = max_message_size
        __props__.__dict__["multizone"] = multizone
        __props__.__dict__["partitions"] = partitions
        __props__.__dict__["password"] = password
        __props__.__dict__["region"] = region
        __props__.__dict__["rest_endpoint"] = rest_endpoint
        __props__.__dict__["retention_size"] = retention_size
        __props__.__dict__["retention_time"] = retention_time
        __props__.__dict__["state"] = state
        __props__.__dict__["tcp_endpoint"] = tcp_endpoint
        __props__.__dict__["topic_id"] = topic_id
        __props__.__dict__["topic_name"] = topic_name
        __props__.__dict__["username"] = username
        return KafkaTopic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cleanupPolicy")
    def cleanup_policy(self) -> pulumi.Output[str]:
        """
        Cleanup policy will be used in the topic(compact or delete)
        """
        return pulumi.get(self, "cleanup_policy")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        ID of the cluster the topic will be deployed in
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[int]:
        """
        Creation time of the topic
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="maxMessageSize")
    def max_message_size(self) -> pulumi.Output[int]:
        """
        Max message size in the topic
        """
        return pulumi.get(self, "max_message_size")

    @property
    @pulumi.getter
    def multizone(self) -> pulumi.Output[bool]:
        """
        Whether multizone replication is enabled
        """
        return pulumi.get(self, "multizone")

    @property
    @pulumi.getter
    def partitions(self) -> pulumi.Output[int]:
        """
        The number of partitions the topic will have
        """
        return pulumi.get(self, "partitions")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Password to be used in authenticating to the cluster
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Region of the kafka topic
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="restEndpoint")
    def rest_endpoint(self) -> pulumi.Output[str]:
        """
        REST Endpoint of the kafka topic
        """
        return pulumi.get(self, "rest_endpoint")

    @property
    @pulumi.getter(name="retentionSize")
    def retention_size(self) -> pulumi.Output[int]:
        """
        Retention size of the messages in the topic
        """
        return pulumi.get(self, "retention_size")

    @property
    @pulumi.getter(name="retentionTime")
    def retention_time(self) -> pulumi.Output[int]:
        """
        Retention time of messages in the topic
        """
        return pulumi.get(self, "retention_time")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the kafka topic (active or deleted)
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="tcpEndpoint")
    def tcp_endpoint(self) -> pulumi.Output[str]:
        """
        TCP Endpoint of the kafka topic
        """
        return pulumi.get(self, "tcp_endpoint")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> pulumi.Output[str]:
        """
        Unique Cluster ID for created topic
        """
        return pulumi.get(self, "topic_id")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> pulumi.Output[str]:
        """
        Name of the topic
        """
        return pulumi.get(self, "topic_name")

    @property
    @pulumi.getter
    def username(self) -> pulumi.Output[str]:
        """
        Base64 encoded username to be used in authenticating to the cluster
        """
        return pulumi.get(self, "username")

