# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['RedisDatabaseArgs', 'RedisDatabase']

@pulumi.input_type
class RedisDatabaseArgs:
    def __init__(__self__, *,
                 database_name: pulumi.Input[str],
                 region: pulumi.Input[str],
                 consistent: Optional[pulumi.Input[bool]] = None,
                 multizone: Optional[pulumi.Input[bool]] = None,
                 tls: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a RedisDatabase resource.
        :param pulumi.Input[str] database_name: Name of the database
        :param pulumi.Input[str] region: region of the database. Possible values are: "global", "eu-west-1", "us-east-1", "us-west-1", "ap-northeast-1" ,
               "eu-central1"
        :param pulumi.Input[bool] consistent: When enabled, all writes are synchronously persisted to the disk.
        :param pulumi.Input[bool] multizone: When enabled, database becomes highly available and is deployed in multiple zones. (If changed to false from true,
               results in deletion and recreation of the resource)
        :param pulumi.Input[bool] tls: When enabled, data is encrypted in transit. (If changed to false from true, results in deletion and recreation of the
               resource)
        """
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "region", region)
        if consistent is not None:
            warnings.warn("""Consistent option is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""consistent is deprecated: Consistent option is deprecated.""")
        if consistent is not None:
            pulumi.set(__self__, "consistent", consistent)
        if multizone is not None:
            pulumi.set(__self__, "multizone", multizone)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[str]:
        """
        Name of the database
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[str]:
        """
        region of the database. Possible values are: "global", "eu-west-1", "us-east-1", "us-west-1", "ap-northeast-1" ,
        "eu-central1"
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def consistent(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, all writes are synchronously persisted to the disk.
        """
        return pulumi.get(self, "consistent")

    @consistent.setter
    def consistent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "consistent", value)

    @property
    @pulumi.getter
    def multizone(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, database becomes highly available and is deployed in multiple zones. (If changed to false from true,
        results in deletion and recreation of the resource)
        """
        return pulumi.get(self, "multizone")

    @multizone.setter
    def multizone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multizone", value)

    @property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, data is encrypted in transit. (If changed to false from true, results in deletion and recreation of the
        resource)
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tls", value)


@pulumi.input_type
class _RedisDatabaseState:
    def __init__(__self__, *,
                 consistent: Optional[pulumi.Input[bool]] = None,
                 creation_time: Optional[pulumi.Input[int]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 db_daily_bandwidth_limit: Optional[pulumi.Input[int]] = None,
                 db_disk_threshold: Optional[pulumi.Input[int]] = None,
                 db_max_clients: Optional[pulumi.Input[int]] = None,
                 db_max_commands_per_second: Optional[pulumi.Input[int]] = None,
                 db_max_entry_size: Optional[pulumi.Input[int]] = None,
                 db_max_request_size: Optional[pulumi.Input[int]] = None,
                 db_memory_threshold: Optional[pulumi.Input[int]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 multizone: Optional[pulumi.Input[bool]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 read_only_rest_token: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 rest_token: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 tls: Optional[pulumi.Input[bool]] = None,
                 user_email: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RedisDatabase resources.
        :param pulumi.Input[bool] consistent: When enabled, all writes are synchronously persisted to the disk.
        :param pulumi.Input[int] creation_time: Creation time of the database
        :param pulumi.Input[str] database_id: Unique Database ID for created database
        :param pulumi.Input[str] database_name: Name of the database
        :param pulumi.Input[str] database_type: Type of the database
        :param pulumi.Input[int] db_daily_bandwidth_limit: Daily bandwidth limit for the database
        :param pulumi.Input[int] db_disk_threshold: Disk threshold for the database
        :param pulumi.Input[int] db_max_clients: Max clients for the database
        :param pulumi.Input[int] db_max_commands_per_second: Max commands per second for the database
        :param pulumi.Input[int] db_max_entry_size: Max entry size for the database
        :param pulumi.Input[int] db_max_request_size: Max request size for the database
        :param pulumi.Input[int] db_memory_threshold: Memory threshold for the database
        :param pulumi.Input[str] endpoint: Database URL for connection
        :param pulumi.Input[bool] multizone: When enabled, database becomes highly available and is deployed in multiple zones. (If changed to false from true,
               results in deletion and recreation of the resource)
        :param pulumi.Input[str] password: Password of the database
        :param pulumi.Input[int] port: Port of the endpoint
        :param pulumi.Input[str] read_only_rest_token: Rest Token for the database.
        :param pulumi.Input[str] region: region of the database. Possible values are: "global", "eu-west-1", "us-east-1", "us-west-1", "ap-northeast-1" ,
               "eu-central1"
        :param pulumi.Input[str] rest_token: Rest Token for the database.
        :param pulumi.Input[str] state: State of the database
        :param pulumi.Input[bool] tls: When enabled, data is encrypted in transit. (If changed to false from true, results in deletion and recreation of the
               resource)
        :param pulumi.Input[str] user_email: User email for the database
        """
        if consistent is not None:
            warnings.warn("""Consistent option is deprecated.""", DeprecationWarning)
            pulumi.log.warn("""consistent is deprecated: Consistent option is deprecated.""")
        if consistent is not None:
            pulumi.set(__self__, "consistent", consistent)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if db_daily_bandwidth_limit is not None:
            pulumi.set(__self__, "db_daily_bandwidth_limit", db_daily_bandwidth_limit)
        if db_disk_threshold is not None:
            pulumi.set(__self__, "db_disk_threshold", db_disk_threshold)
        if db_max_clients is not None:
            pulumi.set(__self__, "db_max_clients", db_max_clients)
        if db_max_commands_per_second is not None:
            pulumi.set(__self__, "db_max_commands_per_second", db_max_commands_per_second)
        if db_max_entry_size is not None:
            pulumi.set(__self__, "db_max_entry_size", db_max_entry_size)
        if db_max_request_size is not None:
            pulumi.set(__self__, "db_max_request_size", db_max_request_size)
        if db_memory_threshold is not None:
            pulumi.set(__self__, "db_memory_threshold", db_memory_threshold)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if multizone is not None:
            pulumi.set(__self__, "multizone", multizone)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if read_only_rest_token is not None:
            pulumi.set(__self__, "read_only_rest_token", read_only_rest_token)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rest_token is not None:
            pulumi.set(__self__, "rest_token", rest_token)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if user_email is not None:
            pulumi.set(__self__, "user_email", user_email)

    @property
    @pulumi.getter
    def consistent(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, all writes are synchronously persisted to the disk.
        """
        return pulumi.get(self, "consistent")

    @consistent.setter
    def consistent(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "consistent", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[int]]:
        """
        Creation time of the database
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique Database ID for created database
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the database
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the database
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter(name="dbDailyBandwidthLimit")
    def db_daily_bandwidth_limit(self) -> Optional[pulumi.Input[int]]:
        """
        Daily bandwidth limit for the database
        """
        return pulumi.get(self, "db_daily_bandwidth_limit")

    @db_daily_bandwidth_limit.setter
    def db_daily_bandwidth_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_daily_bandwidth_limit", value)

    @property
    @pulumi.getter(name="dbDiskThreshold")
    def db_disk_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Disk threshold for the database
        """
        return pulumi.get(self, "db_disk_threshold")

    @db_disk_threshold.setter
    def db_disk_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_disk_threshold", value)

    @property
    @pulumi.getter(name="dbMaxClients")
    def db_max_clients(self) -> Optional[pulumi.Input[int]]:
        """
        Max clients for the database
        """
        return pulumi.get(self, "db_max_clients")

    @db_max_clients.setter
    def db_max_clients(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_max_clients", value)

    @property
    @pulumi.getter(name="dbMaxCommandsPerSecond")
    def db_max_commands_per_second(self) -> Optional[pulumi.Input[int]]:
        """
        Max commands per second for the database
        """
        return pulumi.get(self, "db_max_commands_per_second")

    @db_max_commands_per_second.setter
    def db_max_commands_per_second(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_max_commands_per_second", value)

    @property
    @pulumi.getter(name="dbMaxEntrySize")
    def db_max_entry_size(self) -> Optional[pulumi.Input[int]]:
        """
        Max entry size for the database
        """
        return pulumi.get(self, "db_max_entry_size")

    @db_max_entry_size.setter
    def db_max_entry_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_max_entry_size", value)

    @property
    @pulumi.getter(name="dbMaxRequestSize")
    def db_max_request_size(self) -> Optional[pulumi.Input[int]]:
        """
        Max request size for the database
        """
        return pulumi.get(self, "db_max_request_size")

    @db_max_request_size.setter
    def db_max_request_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_max_request_size", value)

    @property
    @pulumi.getter(name="dbMemoryThreshold")
    def db_memory_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Memory threshold for the database
        """
        return pulumi.get(self, "db_memory_threshold")

    @db_memory_threshold.setter
    def db_memory_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "db_memory_threshold", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        Database URL for connection
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter
    def multizone(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, database becomes highly available and is deployed in multiple zones. (If changed to false from true,
        results in deletion and recreation of the resource)
        """
        return pulumi.get(self, "multizone")

    @multizone.setter
    def multizone(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "multizone", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password of the database
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Port of the endpoint
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="readOnlyRestToken")
    def read_only_rest_token(self) -> Optional[pulumi.Input[str]]:
        """
        Rest Token for the database.
        """
        return pulumi.get(self, "read_only_rest_token")

    @read_only_rest_token.setter
    def read_only_rest_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "read_only_rest_token", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        region of the database. Possible values are: "global", "eu-west-1", "us-east-1", "us-west-1", "ap-northeast-1" ,
        "eu-central1"
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="restToken")
    def rest_token(self) -> Optional[pulumi.Input[str]]:
        """
        Rest Token for the database.
        """
        return pulumi.get(self, "rest_token")

    @rest_token.setter
    def rest_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rest_token", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the database
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def tls(self) -> Optional[pulumi.Input[bool]]:
        """
        When enabled, data is encrypted in transit. (If changed to false from true, results in deletion and recreation of the
        resource)
        """
        return pulumi.get(self, "tls")

    @tls.setter
    def tls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tls", value)

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> Optional[pulumi.Input[str]]:
        """
        User email for the database
        """
        return pulumi.get(self, "user_email")

    @user_email.setter
    def user_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_email", value)


class RedisDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consistent: Optional[pulumi.Input[bool]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 multizone: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tls: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import upstash_pulumi as upstash

        example_db = upstash.RedisDatabase("exampleDB",
            database_name="Terraform DB6",
            multizone=True,
            region="eu-west-1",
            tls=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] consistent: When enabled, all writes are synchronously persisted to the disk.
        :param pulumi.Input[str] database_name: Name of the database
        :param pulumi.Input[bool] multizone: When enabled, database becomes highly available and is deployed in multiple zones. (If changed to false from true,
               results in deletion and recreation of the resource)
        :param pulumi.Input[str] region: region of the database. Possible values are: "global", "eu-west-1", "us-east-1", "us-west-1", "ap-northeast-1" ,
               "eu-central1"
        :param pulumi.Input[bool] tls: When enabled, data is encrypted in transit. (If changed to false from true, results in deletion and recreation of the
               resource)
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RedisDatabaseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import upstash_pulumi as upstash

        example_db = upstash.RedisDatabase("exampleDB",
            database_name="Terraform DB6",
            multizone=True,
            region="eu-west-1",
            tls=True)
        ```

        :param str resource_name: The name of the resource.
        :param RedisDatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RedisDatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 consistent: Optional[pulumi.Input[bool]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 multizone: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 tls: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RedisDatabaseArgs.__new__(RedisDatabaseArgs)

            if consistent is not None and not opts.urn:
                warnings.warn("""Consistent option is deprecated.""", DeprecationWarning)
                pulumi.log.warn("""consistent is deprecated: Consistent option is deprecated.""")
            __props__.__dict__["consistent"] = consistent
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["multizone"] = multizone
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["tls"] = tls
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["database_id"] = None
            __props__.__dict__["database_type"] = None
            __props__.__dict__["db_daily_bandwidth_limit"] = None
            __props__.__dict__["db_disk_threshold"] = None
            __props__.__dict__["db_max_clients"] = None
            __props__.__dict__["db_max_commands_per_second"] = None
            __props__.__dict__["db_max_entry_size"] = None
            __props__.__dict__["db_max_request_size"] = None
            __props__.__dict__["db_memory_threshold"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["password"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["read_only_rest_token"] = None
            __props__.__dict__["rest_token"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["user_email"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RedisDatabase, __self__).__init__(
            'upstash:index/redisDatabase:RedisDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            consistent: Optional[pulumi.Input[bool]] = None,
            creation_time: Optional[pulumi.Input[int]] = None,
            database_id: Optional[pulumi.Input[str]] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            database_type: Optional[pulumi.Input[str]] = None,
            db_daily_bandwidth_limit: Optional[pulumi.Input[int]] = None,
            db_disk_threshold: Optional[pulumi.Input[int]] = None,
            db_max_clients: Optional[pulumi.Input[int]] = None,
            db_max_commands_per_second: Optional[pulumi.Input[int]] = None,
            db_max_entry_size: Optional[pulumi.Input[int]] = None,
            db_max_request_size: Optional[pulumi.Input[int]] = None,
            db_memory_threshold: Optional[pulumi.Input[int]] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            multizone: Optional[pulumi.Input[bool]] = None,
            password: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            read_only_rest_token: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            rest_token: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            tls: Optional[pulumi.Input[bool]] = None,
            user_email: Optional[pulumi.Input[str]] = None) -> 'RedisDatabase':
        """
        Get an existing RedisDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] consistent: When enabled, all writes are synchronously persisted to the disk.
        :param pulumi.Input[int] creation_time: Creation time of the database
        :param pulumi.Input[str] database_id: Unique Database ID for created database
        :param pulumi.Input[str] database_name: Name of the database
        :param pulumi.Input[str] database_type: Type of the database
        :param pulumi.Input[int] db_daily_bandwidth_limit: Daily bandwidth limit for the database
        :param pulumi.Input[int] db_disk_threshold: Disk threshold for the database
        :param pulumi.Input[int] db_max_clients: Max clients for the database
        :param pulumi.Input[int] db_max_commands_per_second: Max commands per second for the database
        :param pulumi.Input[int] db_max_entry_size: Max entry size for the database
        :param pulumi.Input[int] db_max_request_size: Max request size for the database
        :param pulumi.Input[int] db_memory_threshold: Memory threshold for the database
        :param pulumi.Input[str] endpoint: Database URL for connection
        :param pulumi.Input[bool] multizone: When enabled, database becomes highly available and is deployed in multiple zones. (If changed to false from true,
               results in deletion and recreation of the resource)
        :param pulumi.Input[str] password: Password of the database
        :param pulumi.Input[int] port: Port of the endpoint
        :param pulumi.Input[str] read_only_rest_token: Rest Token for the database.
        :param pulumi.Input[str] region: region of the database. Possible values are: "global", "eu-west-1", "us-east-1", "us-west-1", "ap-northeast-1" ,
               "eu-central1"
        :param pulumi.Input[str] rest_token: Rest Token for the database.
        :param pulumi.Input[str] state: State of the database
        :param pulumi.Input[bool] tls: When enabled, data is encrypted in transit. (If changed to false from true, results in deletion and recreation of the
               resource)
        :param pulumi.Input[str] user_email: User email for the database
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RedisDatabaseState.__new__(_RedisDatabaseState)

        __props__.__dict__["consistent"] = consistent
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["database_type"] = database_type
        __props__.__dict__["db_daily_bandwidth_limit"] = db_daily_bandwidth_limit
        __props__.__dict__["db_disk_threshold"] = db_disk_threshold
        __props__.__dict__["db_max_clients"] = db_max_clients
        __props__.__dict__["db_max_commands_per_second"] = db_max_commands_per_second
        __props__.__dict__["db_max_entry_size"] = db_max_entry_size
        __props__.__dict__["db_max_request_size"] = db_max_request_size
        __props__.__dict__["db_memory_threshold"] = db_memory_threshold
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["multizone"] = multizone
        __props__.__dict__["password"] = password
        __props__.__dict__["port"] = port
        __props__.__dict__["read_only_rest_token"] = read_only_rest_token
        __props__.__dict__["region"] = region
        __props__.__dict__["rest_token"] = rest_token
        __props__.__dict__["state"] = state
        __props__.__dict__["tls"] = tls
        __props__.__dict__["user_email"] = user_email
        return RedisDatabase(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def consistent(self) -> pulumi.Output[Optional[bool]]:
        """
        When enabled, all writes are synchronously persisted to the disk.
        """
        return pulumi.get(self, "consistent")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[int]:
        """
        Creation time of the database
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[str]:
        """
        Unique Database ID for created database
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[str]:
        """
        Name of the database
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Output[str]:
        """
        Type of the database
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="dbDailyBandwidthLimit")
    def db_daily_bandwidth_limit(self) -> pulumi.Output[int]:
        """
        Daily bandwidth limit for the database
        """
        return pulumi.get(self, "db_daily_bandwidth_limit")

    @property
    @pulumi.getter(name="dbDiskThreshold")
    def db_disk_threshold(self) -> pulumi.Output[int]:
        """
        Disk threshold for the database
        """
        return pulumi.get(self, "db_disk_threshold")

    @property
    @pulumi.getter(name="dbMaxClients")
    def db_max_clients(self) -> pulumi.Output[int]:
        """
        Max clients for the database
        """
        return pulumi.get(self, "db_max_clients")

    @property
    @pulumi.getter(name="dbMaxCommandsPerSecond")
    def db_max_commands_per_second(self) -> pulumi.Output[int]:
        """
        Max commands per second for the database
        """
        return pulumi.get(self, "db_max_commands_per_second")

    @property
    @pulumi.getter(name="dbMaxEntrySize")
    def db_max_entry_size(self) -> pulumi.Output[int]:
        """
        Max entry size for the database
        """
        return pulumi.get(self, "db_max_entry_size")

    @property
    @pulumi.getter(name="dbMaxRequestSize")
    def db_max_request_size(self) -> pulumi.Output[int]:
        """
        Max request size for the database
        """
        return pulumi.get(self, "db_max_request_size")

    @property
    @pulumi.getter(name="dbMemoryThreshold")
    def db_memory_threshold(self) -> pulumi.Output[int]:
        """
        Memory threshold for the database
        """
        return pulumi.get(self, "db_memory_threshold")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        Database URL for connection
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter
    def multizone(self) -> pulumi.Output[Optional[bool]]:
        """
        When enabled, database becomes highly available and is deployed in multiple zones. (If changed to false from true,
        results in deletion and recreation of the resource)
        """
        return pulumi.get(self, "multizone")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Password of the database
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Port of the endpoint
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="readOnlyRestToken")
    def read_only_rest_token(self) -> pulumi.Output[str]:
        """
        Rest Token for the database.
        """
        return pulumi.get(self, "read_only_rest_token")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        region of the database. Possible values are: "global", "eu-west-1", "us-east-1", "us-west-1", "ap-northeast-1" ,
        "eu-central1"
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="restToken")
    def rest_token(self) -> pulumi.Output[str]:
        """
        Rest Token for the database.
        """
        return pulumi.get(self, "rest_token")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the database
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def tls(self) -> pulumi.Output[Optional[bool]]:
        """
        When enabled, data is encrypted in transit. (If changed to false from true, results in deletion and recreation of the
        resource)
        """
        return pulumi.get(self, "tls")

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> pulumi.Output[str]:
        """
        User email for the database
        """
        return pulumi.get(self, "user_email")

