#! /usr/bin/env python
# -*- coding: utf-8 -*-
#
# Interpreter version: brython (http://brython.info) (like python3)
#
"""
Interface which handles the show/hide button for Author picker.
"""
#
# Imports =====================================================================
from browser import document


# Variables ===================================================================
AUTHOR_EL = document["whole_author"]
SWITCHER_EL = document["author_switcher"]


# Functions & classes =========================================================
def show_author(ev=None):
    AUTHOR_EL.style.display = "block"

    SWITCHER_EL.checked = True
    SWITCHER_EL.bind("change", hide_author)


def hide_author(ev=None):
    AUTHOR_EL.style.display = "none"

    SWITCHER_EL.checked = False
    SWITCHER_EL.bind("change", show_author)


hide_author()
SWITCHER_EL.bind("change", show_author)
