#! /usr/bin/env python
# -*- coding: utf-8 -*-
#
# Interpreter version: brython (http://brython.info) (like python3)
#
"""
Generic and specific Error box handlers.
"""
#
# Imports =====================================================================
from browser import document


# Functions & classes =========================================================
class ErrorBox(object):
    """
    Generic class for showing the errors in nice red box.
    """
    def __init__(self, tag_id, whole_tag_id):
        self.tag = document[tag_id]
        self.whole_tag = document[whole_tag_id]

    def show(self, msg):
        self.tag.innerHTML = msg
        self.whole_tag.style.display = "block"

    def hide(self):
        self.whole_tag.style.display = "none"

    def reset(self):
        self.hide()
        self.tag.innerHTML = ""


UrlBoxError = ErrorBox("urlbox_error", "whole_urlbox_error")
ISSNBoxError = ErrorBox("issnbox_error", "whole_issnbox_error")
