#! /usr/bin/env python
# -*- coding: utf-8 -*-
#
# Interpreter version: brython (http://brython.info) (like python3)
#
# Imports =====================================================================
from browser import document

from .overlay_controller import BlackOverlay


# Functions & classes =========================================================
class LogView(object):
    """
    This class allows logging of states of the application AND generates a
    simple GUI for browsing this logs.
    """
    _value = []
    el = document["log_placeholder"]
    show_button = document["show_log"]

    overlay = BlackOverlay()

    @classmethod
    def _render(cls):
        cls.el.text = cls.get()

    @classmethod
    def add(cls, msg):
        """
        Add new `msg` to the log.
        """
        cls._value.append(msg)
        cls._render()

    @classmethod
    def get(cls):
        """
        Get all the log messages.
        """
        return "\n---\n".join(cls._value)

    @classmethod
    def show(cls, msg=None):
        """
        Show the log interface on the page.
        """
        if msg:
            cls.add(msg)

        cls.overlay.show()
        cls.overlay.el.bind("click", lambda x: cls.hide())

        cls.el.style.display = "block"
        cls.bind()

    @classmethod
    def hide(cls):
        """
        Hide the log interface.
        """
        cls.el.style.display = "none"
        cls.overlay.hide()
        cls.bind()

    @classmethod
    def bind(cls):
        """
        Bind the buttons to the callbacks.
        """
        cls.show_button.bind("click", lambda ev: cls.show())

LogView.bind()
