#! /usr/bin/env python
# -*- coding: utf-8 -*-
#
# Interpreter version: brython (http://brython.info) (like python3)
#
# Imports =====================================================================
from browser import document


# Functions & classes =========================================================
class BlackOverlay(object):
    """
    This class is used to controll semi-transparent black layer shown at
    background of certain dialogs.
    """
    def __init__(self):
        self.el = document["black_overlay"]
        self.body_el = document.get(selector="body")[0]

    def show(self):
        self.el.style.display = "block"
        self.body_el.style.overflow = "hidden"

    def hide(self):
        self.el.style.display = "none"
        self.body_el.style.overflow = "visible"


class HelpOverlay(object):
    """
    This class binds all ``<a class="glyphicon-question-sign">`` elements, so
    they will on click show iframe overlay with linked page.

    This is used for quick help.
    """
    el = document["help_overlay"]
    black_overlay = BlackOverlay()

    @classmethod
    def show(cls, url):
        cls.el.html = "<iframe src='%s' class='help_iframe'></iframe>" % url

        cls.black_overlay.show()
        cls.el.style.display = "block"
        cls.black_overlay.el.bind("click", lambda x: cls.hide())

    @classmethod
    def hide(cls):
        cls.black_overlay.hide()
        cls.el.style.display = "none"

    @classmethod
    def bind(cls):
        def ev_handler(ev):
            ev.preventDefault()
            ev.stopPropagation()
            cls.show(ev.currentTarget.href)

        for link in document.get(selector="a.glyphicon-question-sign"):
            link.bind("click", ev_handler)


HelpOverlay.bind()
