#! /usr/bin/env python
# -*- coding: utf-8 -*-
#
# Interpreter version: brython (http://brython.info) (like python3)
#
# Imports =====================================================================


# Functions & classes =========================================================
class PlaceholderHandler(object):
    """
    This class acts as handler for the background text, which is shown by
    bootstrap to blank elements.

    In case that there is multiple values in you typeahead tag, you may use
    this to show additional mesasge alerting the user to the possibility to
    choose from multiple values.
    """
    _dropdown_text = " Klikněte pro výběr."

    @staticmethod
    def set_placeholder_text(input_el, text):
        input_el.placeholder = text

    @staticmethod
    def get_placeholder_text(input_el):
        return input_el.placeholder

    @classmethod
    def set_placeholder_dropdown(cls, input_el):
        """
        Set the element to show the multiple choice text.
        """
        text = cls.get_placeholder_text(input_el)
        cls.set_placeholder_text(
            input_el=input_el,
            text=text + cls._dropdown_text
        )

    @classmethod
    def reset_placeholder_dropdown(cls, input_el):
        """
        Reset the element back to default.
        """
        text = cls.get_placeholder_text(input_el)
        cls.set_placeholder_text(
            input_el=input_el,
            text=text.replace(cls._dropdown_text, "")
        )
