#! /usr/bin/env python
# -*- coding: utf-8 -*-
#
# Interpreter version: brython (http://brython.info) (like python3)
#
# Imports =====================================================================
from browser import ajax


# Functions & classes =========================================================
def make_request(url, data, on_complete):
    """
    Make AJAX request to `url` with given POST `data`. Call `on_complete`
    callback when complete.

    Args:
        url (str): URL.
        data (dict): Dictionary with POST data.
        on_complete (ref): Reference to function / method which will be called
            when the request is done.
    """
    req = ajax.ajax()
    req.bind('complete', on_complete)
    req.open('POST', url, True)
    req.set_header('content-type', 'application/x-www-form-urlencoded')
    req.send(data)


def func_on_enter(func):
    """
    Register the `func` as a callback reacting only to ENTER.

    Note:
        This function doesn't bind the key to the element, just creates sort of
        filter, which ignores all other events.
    """
    def function_after_enter_pressed(ev):
        ev.stopPropagation()

        # if the key was `enter` ..
        if ev.keyCode == 13:
            func(ev)

    return function_after_enter_pressed
