#! /usr/bin/env python
# -*- coding: utf-8 -*-
#
# Interpreter version: brython (http://brython.info) (like python3)
#
"""
This module is used to set / get values from/to Rules section on the HTML page.
"""
#
# Imports =====================================================================
from browser import document

from descriptors import RadioDescriptor
from descriptors import StandardElDescriptor


# Functions & classes =========================================================
class RulesView(object):
    """
    View object for manipulation with rules on the HTML page.
    """
    budget = RadioDescriptor("budget_radio", val_type=int)
    gentle_fetch = RadioDescriptor("gentle_fetch_radio", val_type=str)
    local_traps = RadioDescriptor("local_traps_radio")
    calendars = RadioDescriptor("calendars_radio")
    youtube = RadioDescriptor("youtube_radio")
    global_reject = RadioDescriptor("global_reject_radio")
    javascript = RadioDescriptor("javascript_radio")
    frequency = StandardElDescriptor(document["freq"])

    def __init__(self):
        self._property_names = [
            "budget",
            "gentle_fetch",
            "local_traps",
            "calendars",
            "youtube",
            "global_reject",
            "javascript",
            "frequency",
        ]

    def get_dict(self):
        """
        Convert all rules to dict and return them.
        """
        out = {
            property_name: getattr(self, property_name)
            for property_name in self._property_names
        }

        if "frequency" in out:
            out["frequency"] = int(out["frequency"])

        return out

    def set_dict(self, incomming):
        """
        Set all rules from the `incomming` dictionary.
        """
        for key, val in incomming.items():
            if val and key in self._property_names:
                setattr(self, key, val)


RulesViewController = RulesView()
