# Generated by Django 2.0.8 on 2018-08-15 13:12

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('djasana', '0005_adds_custom_field_settings_rich_text_project_status'),
    ]

    operations = [
        migrations.CreateModel(
            name='CustomField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('remote_id', models.BigIntegerField(db_index=True, help_text='The id of this object in Asana.', unique=True)),
                ('name', models.CharField(max_length=1024, verbose_name='name')),
                ('description', models.CharField(blank=True, max_length=1024, null=True)),
                ('enum_options', models.CharField(blank=True, max_length=1024, null=True)),
                ('type', models.CharField(choices=[('enum', 'enum'), ('number', 'number'), ('text', 'text')], max_length=24)),
                ('precision', models.SmallIntegerField(blank=True, choices=[(0, 0), (1, 1), (2, 2), (3, 3), (4, 4), (5, 5)], null=True)),
            ],
            options={
                'ordering': ('name',),
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='CustomFieldSettings',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('remote_id', models.BigIntegerField(db_index=True, help_text='The id of this object in Asana.', unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('is_important', models.BooleanField(default=False)),
                ('custom_field', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djasana.CustomField', to_field='remote_id')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='task',
            name='custom_fields',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.RemoveField(
            model_name='project',
            name='custom_field_settings',
        ),
        migrations.AlterField(
            model_name='webhook',
            name='secret',
            field=models.CharField(max_length=64, validators=[django.core.validators.MinLengthValidator(32)]),
        ),
        migrations.AddField(
            model_name='customfieldsettings',
            name='project',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djasana.Project', to_field='remote_id'),
        ),
        migrations.AddField(
            model_name='customfieldsettings',
            name='workspace',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='djasana.Workspace', to_field='remote_id'),
        ),
        migrations.AddField(
            model_name='project',
            name='custom_field_settings',
            field=models.ManyToManyField(related_name='custom_field_settings', through='djasana.CustomFieldSettings', to='djasana.CustomField'),
        ),
    ]
