import click
from gumshoe.classes import habits
from gumshoe.models import models

@click.command()
@click.argument("name", nargs=-1, required=True)
@click.option('--confirmation', prompt='Do you really want to remove this habit [y/n]',
              help='Confirmation that you want to remove your habit.')
def cli(name, confirmation):
    """The remove command removes a habits and all its associated activities. Please specify the name of the habit you
    wish to remove. You can use the gumshoe show command to list all habits to get the habits name."""

    name = ' '.join(name)
    db = models.HabitModel()
    new_habit = habits.Habit(name, "", "")
    habit = db.check_habit_exists(new_habit)
    if confirmation == "y":
        if len(habit) == 0:
            click.echo("This habit doe not exists, use the show command "
                       "to list all habits.")
        else:
            if db.remove_habit(habit[0]):
                click.echo("Habit removed successfully!")
            else:
                click.echo("Seems there has been a system error, please check the log file.")
    else:
        click.echo("Habit removed cancelled!")