# Generated by Django 2.2.18 on 2021-02-26 00:53

from django.db import migrations
import polaris.models


def encrypt_channel_seeds(apps, _):
    Transaction = apps.get_model("polaris", "Transaction")
    channel_seed_txs = Transaction.objects.filter(channel_seed__isnull=False).all()
    for tx in channel_seed_txs:
        tx.channel_seed = polaris.models.EncryptedTextField.encrypt(tx.channel_seed)
        tx.save()


def decrypt_channel_seeds(apps, _):
    Transaction = apps.get_model("polaris", "Transaction")
    channel_seed_txs = Transaction.objects.filter(channel_seed__isnull=False).all()
    for tx in channel_seed_txs:
        tx.channel_seed = polaris.models.EncryptedTextField.decrypt(tx.channel_seed)
        tx.save()


class Migration(migrations.Migration):

    dependencies = [
        ("polaris", "0004_auto_20201120_1541"),
    ]

    operations = [
        migrations.RunPython(encrypt_channel_seeds, decrypt_channel_seeds),
        migrations.AlterField(
            model_name="transaction",
            name="channel_seed",
            field=polaris.models.EncryptedTextField(blank=True, null=True),
        ),
    ]
