import logging
from pathlib import Path

import pooch

__all__ = ["example_filepath"]

pooch.get_logger().setLevel(logging.ERROR)

goodboy = pooch.create(
    path=pooch.os_cache("hmmer"),
    base_url="https://iseq-py.s3.amazonaws.com/",
    registry={
        "2OG-FeII_Oxy_3-nt.hmm.gz": "96b2643ce07425d51b4d3a6b967d6d4aaf0a2bc2d351cf871c978697c9789d56",
        "2OG-FeII_Oxy_3-nt_glocal.fasta.gz": "483b1459b58bcbc67c04ec90197ba7e79d491c9c65aa88126ac10646bfbf438c",
        "2OG-FeII_Oxy_3-nt_local.fasta.gz": "3deef057c1eb956dc63f1c596d04ce8a639f79a7379e0bd873f55ca6e4e8d3e3",
        "2OG-FeII_Oxy_3-nt_uniglocal.fasta.gz": "19785f9e28c9e5da86d041a9bd7f0feaf72299e50634ede69df6bf15429416ca",
        "2OG-FeII_Oxy_3-nt_unilocal.fasta.gz": "bb5a0d3b47cdb96e8fa53d5c2228dc55bfe35e24725b0b7f732eafd3262a0fe0",
        "2OG-FeII_Oxy_3-rna_unilocal.fasta.gz": "e97db92d8748ab0b4d81a7caff0f68fbbd426b5e31cd2e0f916eaeb2da030be4",
        "2OG-FeII_Oxy_3-sample1_local.fasta.gz": "9ff240443c96232cbd0cdd75e8c73ed25244324f04580b67e8cdc4f06414c816",
        "2OG-FeII_Oxy_3.hmm.gz": "a20fe24a69539f036730637b16519e74133b7cfa644e2bf88152719c96e4c4cd",
        "2OG-FeII_Oxy_3_glocal.fasta.gz": "a06437a65e0affa727e23d439d4b8c73f641f8f869ad134c3845878ab55f30e4",
        "2OG-FeII_Oxy_3_local.fasta.gz": "63fd3b9e7edc6338c2b1ac335378b34e49b2e24b2927e12b4e1f839d364d1fa3",
        "2OG-FeII_Oxy_3_uniglocal.fasta.gz": "d8d5b3cb9709a7a4dee9187d7d3760b65cd9cc2dcf9364943f45eb2ff8761a10",
        "2OG-FeII_Oxy_3_unilocal.fasta.gz": "6a1948e7a6c1157eb68142835a7b3d98ac50aa8ad27a5059648fd5258e94989b",
        "A0ALD9.fasta.gz": "93921b6ce7655941b43934ccf85a92a890ca9774ea3a0056018bd8453eb2188b",
        "A0ALD9_dna_huge.fasta.gz": "e39f99266664aa58c01ad6f26bc2fe4c43c4b37aa56b1316bb6ad5788325efa0",
        "AE014075.1_cds_amino.fasta.gz": "7b60c132d53c3c5ad715e96b87d55300355465582e3e1bee362d6f5108c328b2",
        "AE014075.1_cds_nucl.fasta.gz": "c0cc1b76d2e7c420a0b275f759e154d3c0978a7bb01897a680ba429ae5125bd4",
        "AE014075.1_domtblout.txt.gz": "4ceff444fcc6312ce7c621c8a0358d58d98cef66f3cc34066eadf609b31cc39c",
        "AE014075.1_output.gff.gz": "fb8e80c231304dbef2f7c3fe7f2e4409d03e909952cd1026c1cac68e3d38fc5e",
        "AE014075.1_subset_nucl.fasta.gz": "8e00d4c555da3451479313ab1f385eaf3c848ae5a3e3aab5cd4f515a5a68494d",
        "AE014075.1_subset_oamino.fasta.gz": "5cd4179c89364d4747973c564c3960cd3358b4d6c500748103ab90405a987b11",
        "AE014075.1_subset_ocodon.fasta.gz": "3616cdf9b344f3b52ecbec93d022539f5d86ae13a6e9866becdf6b6b217a477d",
        "AE014075.1_subset_output.gff.gz": "c1e93296d49f47cf1ba1a2f5b19ff30937bb30f6ef66df742e66122fce6be00e",
        "GALNBKIG_00914_ont_01_plus_strand.fasta.gz": "c7953d14f2291b2fe7310ad02570e9a5609b27839c0afd31647da683334fc88d",
        "GALNBKIG_cut.fasta.gz": "1b4f275924a30acc6f8481eb1084c937f71bfcd85a8d40094efbf02df1f0991b",
        "PF00113.hmm.gz": "fcf03f4e5277c58f775a262079d14447eb39482908f1fa73ed95fd99319f2ef2",
        "PF00113_A0ALD9_dna_huge_amino1776.fasta.gz": "f593bf6694af2e6417cc326ca343e19ea6772ca1df60d664ef59ab00c8a5cb8e",
        "PF00113_A0ALD9_dna_huge_codon1776.fasta.gz": "7219bd899962342fd2912948af1e72185a01ad5b35b258fb75aab70dc721101f",
        "PF00113_A0ALD9_dna_huge_output1776.gff.gz": "925dd44f6b5b1ebf9b7072b681b62b16d010a892adaec999c2210af98ae97c3b",
        "PF00113_GALNBKIG_00914_ont_01_plus_strand_oamino.fasta.gz": "cb4c09947bb45815a31dd4a3b2068d2848f6daa2b7db3e72720ad7c57b5bb2ad",
        "PF00113_GALNBKIG_00914_ont_01_plus_strand_oamino_window.fasta.gz": "bce7f1d9ef724ea7afb526e846dae8181cb31bb5bcc3f57c965d5b3d1303c396",
        "PF00113_GALNBKIG_00914_ont_01_plus_strand_ocodon.fasta.gz": "a46d9ef0f0af04dc65c4ddc9af65ee8e9dabb3d8fe4b660940d7fa2c647b5803",
        "PF00113_GALNBKIG_00914_ont_01_plus_strand_ocodon_window.fasta.gz": "9a25956fed74bceb671fe7631e018733166eedc309d109451faf79f8c38b0dd9",
        "PF00113_GALNBKIG_00914_ont_01_plus_strand_output.gff.gz": "b0b6087d057a228e5d1088559f7cda46f01d53d13a2579361c0ab45c757cb109",
        "PF00113_GALNBKIG_00914_ont_01_plus_strand_output_window.gff.gz": "8cc1ca4be42a21613277ffc2d906dcccc5026fce707871424cde8006b68bb399",
        "PF03373.hmm.gz": "2775ba118be324eb098769bf8650c6fd80a2652ae9cc651624174c5e152ba219",
        "PF03373_GALNBKIG_cut.amino.fasta.gz": "a5aeb7b444ba2d0d1267417dac763f6b7463a36109ec63cb839a0507c8b31c7d",
        "PF03373_GALNBKIG_cut.codon.fasta.gz": "9524c25aab3996edc483187213bb0d1350b8601bcfae3a8929fe800f30183e5a",
        "PF03373_GALNBKIG_cut.gff.gz": "a859d8f675cb6f2e204c927db103be56c9081a518d029a1d867a0b49d8e95ba9",
        "PF03373_rna_most_likely.fasta.gz": "f351c4aab4f3cf646390407acbbae01df73205e67075cb47ab12a5fbdd087130",
        "PF03373_rna_oamino.fasta.gz": "109092a8b80e22b86b7625ad7fa64efe35bc3c4244d45529e6dd49b08bc3505f",
        "PF03373_rna_output.gff.gz": "c6c8c206f5276e39e696a32b2a006e90ea636d23ba5f372a5877eb3090545965",
        "PF07476.11.hmm.gz": "d30d7071487a96709ad350a678b82e78a9a3be59dd78e4b40ee0b0cbd359a98a",
        "PF15449.6.hmm.gz": "aef7e0f005eabc7b96e7f5209f43d76cc4bb4b5588a985023db511656d9ec0e3",
        "Pfam-A.33.1_10.hmm.alt.gz": "fedf0756398e209f9a5d797194d9248ff4219f7c913896bd96e3395abda7f3c5",
        "Pfam-A.33.1_10.hmm.alt.idx.gz": "09bc35f66ae507c254cac60c279e715cac0d93b6a9457b5184fa97da15b74e4b",
        "Pfam-A.33.1_10.hmm.gz": "b18d95c437c5633f579bb714adc97a9632c714a6c834797ddef332e4e95fb1cd",
        "Pfam-A.33.1_10.hmm.meta.gz": "42ffbe9590d1bbda01e0d0779fbc6989de09f41b05877365ac05b7fe8e1b9cca",
        "Pfam-A.33.1_10.hmm.null.gz": "6cb1973f8f4df1a763892dcd35bf8f9ad2cd8cc56c33ff96a3f1e8da3897b4fd",
        "Pfam-A.33.1_10.hmm.null.idx.gz": "15e7789c769a8affeaafa0aab44e637a5a1673416cfb03949053b13a77b49f8e",
        "Pfam-A.33.1_small.hmm.gz": "3a0b47eb6ed42fc06cd198cbe346c386b77219196ac83ca03b18a793cd5e5e0f",
        "Pfam-A.hmm.gz": "957a1ebdbc7a8ce888c6d1be1aca7270a7d51fb6c906cc706b7d9bcce2acccf3",
        "Pfam-A_24.hmm.gz": "e6382ef2d496c5185f1013e6806efee2aa6c9ab37258b3cb28c4775d6597a18e",
        "Pfam-A_24.hmm.h3f.gz": "efa8bc154715b86828b7df35eacf50f832edfc87f33f50547194c49b3c5b061c",
        "Pfam-A_24.hmm.h3i.gz": "3bd5be942083ed38c6ed606fb97a8f080772b9048dca08cee60bc7041e2669fe",
        "Pfam-A_24.hmm.h3m.gz": "88268d4080860d1d4f5cc4ee84d20815306ec20d5919e3e39eaae424dd12f22a",
        "Pfam-A_24.hmm.h3m.ssi.gz": "a5badbdc9a34135ba78a1ae9722aabcb3296ebceb23c865466e22b80d9092714",
        "Pfam-A_24.hmm.h3p.gz": "97de8619ce9943ca38ea8dfb7678a46d9e6bc3060791f704a1cf2bf123d61145",
        "Pfam-A_4.hmm.gz": "e863eb35b480ac0a2f08acc21dd5095e07562e1831cb0c14064b1f6c05911b25",
        "Pfam-A_4.hmm.ssi.gz": "d9fe10e6ae718cac587de9651936c2ec3b1933fe1b5860b82bbe0169e2a22dad",
        "Pfam-A_hmmer3.3_viterbi_scores.txt.gz": "e3686f7634eff81036317a7ca79a3f2b4e6c42fb0fe9f417d85112f81a41a39f",
        "Pfam-A_iseq_viterbi_scores.txt.gz": "0c1d686aa05e3dd2346d3f5b6f265f4aaf0343fcfb9e39e5adcd723551171edd",
        "amino1.fasta.gz": "de6bf1a8a7795d76927380b0942369f2a168826d10e5849cfb8d265201541c58",
        "database1.hmm.gz": "f47676990757f2a3e4626fa0790fb0a018f4cc6c56a3275569afe813586a08d7",
        "domtblout.txt.gz": "a1f949ee2220b442bec3b0f3f52c15993a83815dffaf9aabb64984097e4f5a2c",
        "duplicate.gff.gz": "ba0bea5c4ecd76501467ad44922a39b189f87fd180d7980e759b512e01a33034",
        "ecori.hmm.gz": "a3bab7e06ee8512a02227485ea90aef7a617d4c9ad14178ee1b7bdf4bc180c76",
        "hmmer3_2OG-FeII_Oxy_3-nt_glocal.fasta.viterbi.gz": "037bb54c9ad2c4ce20ee74261ebfef63bc8b5d09f2e2e625a46fa22c5ec8609c",
        "hmmer3_2OG-FeII_Oxy_3-nt_local.fasta.viterbi.gz": "143532d43f0d64c7a971e3cd2b820c7f3404597ad6fe1b7160880781ad43cd6b",
        "hmmer3_2OG-FeII_Oxy_3-nt_uniglocal.fasta.viterbi.gz": "f77b8fe3c233d901ca736431f7d76bc17fe6147ff8ec4a5e5be7ec0704545997",
        "hmmer3_2OG-FeII_Oxy_3-nt_unilocal.fasta.viterbi.gz": "a65c95c6bf3b0795239607ef55e79a0e0d3556b0f962364b3093476fc510c9a6",
        "hmmer3_2OG-FeII_Oxy_3_glocal.fasta.viterbi.gz": "3f804088bdcd86779f74eac89dc5a10dbd40cb9cf06816a565ddea2c5698f371",
        "hmmer3_2OG-FeII_Oxy_3_local.fasta.viterbi.gz": "0a7591b5f041835eb702ecdf667956d71f181f1ebcb44c6e9e0bffda7207d97e",
        "hmmer3_2OG-FeII_Oxy_3_uniglocal.fasta.viterbi.gz": "cbf34f3fe346bc25501a107d346586104fcd7f2ea3b24768a6909d9470188759",
        "hmmer3_2OG-FeII_Oxy_3_unilocal.fasta.viterbi.gz": "b4c51842042c85abbe3a21cf0ff00df952645b38f15a5986010229de405d1b6f",
        "iseq_2OG-FeII_Oxy_3-nt_glocal.fasta.viterbi.gz": "452b4dd6c263417cb0829a3bfdfdb631617b5e9eb44ec7580feb6ab09bbd1508",
        "iseq_2OG-FeII_Oxy_3-nt_local.fasta.viterbi.gz": "62220ef2aca4ab68c073ebd1f143e6dc4aeb72583111a5508fd37541ec476a19",
        "iseq_2OG-FeII_Oxy_3-nt_uniglocal.fasta.viterbi.gz": "ae2a69836a57566d770374decd3c463e72a80b5a35948c78b18e32a0bc3d3eeb",
        "iseq_2OG-FeII_Oxy_3-nt_unilocal.fasta.viterbi.gz": "4085de6fa190e5ab042e8efcd827d1ca24584c0727a775d01fab68c1d7d8786b",
        "iseq_2OG-FeII_Oxy_3_glocal.fasta.viterbi.gz": "02cf613cd2150735d9af98b83c0cac6639f613cb8571f79649365b153e147ae2",
        "iseq_2OG-FeII_Oxy_3_local.fasta.viterbi.gz": "8720220ecbc9fb6b63ef46dd0a6e1f53787d563bc73bfe5a2e4eb415d9e7ca24",
        "iseq_2OG-FeII_Oxy_3_uniglocal.fasta.viterbi.gz": "0d4a24a1c16d55c3ddbb28baa0097bbbb87bb94cc6bd8ad99e13243e129aec29",
        "iseq_2OG-FeII_Oxy_3_unilocal.fasta.viterbi.gz": "0a9ef2d8e7c3363e53d6ac736a22c4874d0ee5d98aa62287b8512b1607316625",
        "large_rna_seq.fasta.gz": "a8cf2605b139ff572c6ea526062ec36b6c1496792b12e198e0143098d21fb29e",
        "large_rna_seq_amino0.fasta.gz": "75c2b359e8ddac5e7042d1d4680849f105b134ca1c14de4eec933fbc782d70c4",
        "large_rna_seq_amino48.fasta.gz": "452273c811b4bfadc176a0712feb45005ad7a1319be0de0ba5138fca8c6e39b8",
        "large_rna_seq_codon0.fasta.gz": "74e144dc60339d85ff0d3ce8a5455c155431d3c58bb0acf80b4ff8c108961b67",
        "large_rna_seq_codon48.fasta.gz": "27824a37b429c5e1fc115e0ca8577ae830fe4668e8717549652856c279982172",
        "large_rna_seq_output0.gff.gz": "9e8f118efa539ad6f034d764a9c31d6a9d5d1ed749f8e95405a7f8d58a70362d",
        "large_rna_seq_output48.gff.gz": "4649ef0bed6aa42be2849ce912cb3a7303761d0cc1669131304e9a1d97bd5b64",
        "minifam.hmm.gz": "f644728609c4a71691c641e43d4c8498d809ed0b81ae17e43635ef8acea8aa78",
        "minifam.hmm.ssi.gz": "cf1e90ae75bb1e1894a79625684f15d3541837ca8018531abef5a35276cfc4f0",
        "oamino_pfam24.fasta.gz": "cd42607aedc62b96e82a4184637f1421d3e8f001a3be3d8e263b6608fe75de16",
        "oamino_pfam24_cut_ga.fasta.gz": "7c130184dc855ebeb26e81a87ab889a41d2080ff441dd85ee66824e1dcf305eb",
        "oamino_pfam4.fasta.gz": "0f2d9e631f734579e00aa51e60457354abe3efe720a8d917fb89eb0c782483ce",
        "ocodon_pfam24.fasta.gz": "cc34ec4f27b4dbf04a4bc6b2490a4a3342e7772facfa54ec6d3384941ac2ea8f",
        "ocodon_pfam24_cut_ga.fasta.gz": "3309d0c3b22c7efe6776d7858fc4222b18dc0f0306a2b5631ea56d950f08c0ad",
        "ocodon_pfam4.fasta.gz": "7f430b4fd8fc875c1f9e3c4ba783c55506f65ee2711f4f4619e30b214991ffec",
        "output1.gff.gz": "e7cd00b5dd90237a950c28d351860ad52a75350f73dc3a6bb76925bae7bf7777",
        "output1_evalue.gff.gz": "54fd563b0d5364ff71e1657a55e5acff88a270cae3966b7f85ea7fe251bc4080",
        "output_pfam24.gff.gz": "6c2c093da4fb7d74d8ba514565653619326ec1b96963eb56721a533ccf15412b",
        "output_pfam24_cut_ga.gff.gz": "049a96bed94a4556e0fa0d9f535e064a2215ac3a56fbc02f55b843edff431c86",
        "output_pfam4.gff.gz": "7add90f4be8461358d53310d8ff3d5d95656f59bb3030fbda6d5a1ee972d1e10",
        "pfam_small_GALNBKIG_00914_oamino.fasta.gz": "bcfb44208520509e06a1b8850385968520bb5f924af7db7c753073378a7bdfcb",
        "pfam_small_GALNBKIG_00914_ocodon.fasta.gz": "b8b633ee6ead37cbf6cf5aa9461f2418fa3f381a8b3b6ee25d28d30349d012bc",
        "pfam_small_GALNBKIG_00914_output.gff.gz": "3bbcab04b8e30ebc86b7462b44349d5f7cc30046cabf4dd20cb22a555248376d",
        "problematic1.fasta.gz": "6da979dc33317f9b6d9276a4da3689236868b095b3d5c4c7517e0f8bef9a275a",
        "problematic1.hmm.gz": "db6fe361c6608bca1bee777c95cc46b3284f50e4ad55b98fd31867e8e4e82930",
        "tblout.txt.gz": "42d84e68d25b75cbe3d547125d3d8916c5f63894524b4af8eea5674f0181f941",
    },
)


def example_filepath(filename: str) -> Path:
    return Path(goodboy.fetch(filename + ".gz", processor=pooch.Decompress()))
