"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ddb = require("@aws-cdk/aws-dynamodb");
const sfn = require("@aws-cdk/aws-stepfunctions");
const cdk = require("@aws-cdk/core");
const tasks = require("../../lib");
let stack;
let table;
beforeEach(() => {
    // GIVEN
    stack = new cdk.Stack();
    table = new ddb.Table(stack, 'my-table', {
        tableName: 'my-table',
        partitionKey: {
            name: 'name',
            type: ddb.AttributeType.STRING,
        },
    });
});
test('UpdateItem task', () => {
    // WHEN
    const task = new tasks.DynamoUpdateItem(stack, 'UpdateItem', {
        key: { SOME_KEY: tasks.DynamoAttributeValue.fromString('1234') },
        table,
        conditionExpression: 'ForumName <> :f and Subject <> :s',
        expressionAttributeNames: { OTHER_KEY: '#OK' },
        expressionAttributeValues: {
            ':val': tasks.DynamoAttributeValue.numberFromString(sfn.JsonPath.stringAt('$.Item.TotalCount.N')),
        },
        returnConsumedCapacity: tasks.DynamoConsumedCapacity.TOTAL,
        returnItemCollectionMetrics: tasks.DynamoItemCollectionMetrics.SIZE,
        returnValues: tasks.DynamoReturnValues.ALL_NEW,
        updateExpression: 'SET TotalCount = TotalCount + :val',
    });
    // THEN
    expect(stack.resolve(task.toStateJson())).toEqual({
        Type: 'Task',
        Resource: {
            'Fn::Join': [
                '',
                [
                    'arn:',
                    {
                        Ref: 'AWS::Partition',
                    },
                    ':states:::dynamodb:updateItem',
                ],
            ],
        },
        End: true,
        Parameters: {
            Key: { SOME_KEY: { S: '1234' } },
            TableName: {
                Ref: 'mytable0324D45C',
            },
            ConditionExpression: 'ForumName <> :f and Subject <> :s',
            ExpressionAttributeNames: { OTHER_KEY: '#OK' },
            ExpressionAttributeValues: { ':val': { 'N.$': '$.Item.TotalCount.N' } },
            ReturnConsumedCapacity: 'TOTAL',
            ReturnItemCollectionMetrics: 'SIZE',
            ReturnValues: 'ALL_NEW',
            UpdateExpression: 'SET TotalCount = TotalCount + :val',
        },
    });
});
//# sourceMappingURL=data:application/json;base64,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