"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Route53domains = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * (experimental) Statement provider for service [route53domains](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53domains.html).
 *
 * @experimental
 */
class Route53domains extends shared_1.PolicyStatement {
    /**
     * (experimental) Statement provider for service [route53domains](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53domains.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement.
     * @experimental
     */
    constructor(sid) {
        super(sid);
        /**
         * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
         *
         * @experimental
         */
        this.servicePrefix = 'route53domains';
        /**
         * @experimental
         */
        this.accessLevelList = {
            Write: [
                'AcceptDomainTransferFromAnotherAwsAccount',
                'CancelDomainTransferToAnotherAwsAccount',
                'DisableDomainAutoRenew',
                'DisableDomainTransferLock',
                'EnableDomainAutoRenew',
                'EnableDomainTransferLock',
                'RegisterDomain',
                'RejectDomainTransferFromAnotherAwsAccount',
                'RenewDomain',
                'ResendContactReachabilityEmail',
                'RetrieveDomainAuthCode',
                'TransferDomain',
                'TransferDomainToAnotherAwsAccount',
                'UpdateDomainContact',
                'UpdateDomainContactPrivacy',
                'UpdateDomainNameservers'
            ],
            Read: [
                'CheckDomainAvailability',
                'CheckDomainTransferability',
                'GetContactReachabilityStatus',
                'GetDomainDetail',
                'GetDomainSuggestions',
                'GetOperationDetail',
                'ViewBilling'
            ],
            Tagging: [
                'DeleteTagsForDomain',
                'UpdateTagsForDomain'
            ],
            List: [
                'ListDomains',
                'ListOperations',
                'ListTagsForDomain'
            ]
        };
    }
    /**
     * (experimental) Grants permission to accept the transfer of a domain from another AWS account to the current AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_AcceptDomainTransferFromAnotherAwsAccount.html
     *
     * @experimental
     */
    toAcceptDomainTransferFromAnotherAwsAccount() {
        return this.to('AcceptDomainTransferFromAnotherAwsAccount');
    }
    /**
     * (experimental) Grants permission to cancel the transfer of a domain from the current AWS account to another AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CancelDomainTransferToAnotherAwsAccount.html
     *
     * @experimental
     */
    toCancelDomainTransferToAnotherAwsAccount() {
        return this.to('CancelDomainTransferToAnotherAwsAccount');
    }
    /**
     * (experimental) Grants permission to check the availability of one domain name.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CheckDomainAvailability.html
     *
     * @experimental
     */
    toCheckDomainAvailability() {
        return this.to('CheckDomainAvailability');
    }
    /**
     * (experimental) Grants permission to check whether a domain name can be transferred to Amazon Route 53.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_CheckDomainTransferability.html
     *
     * @experimental
     */
    toCheckDomainTransferability() {
        return this.to('CheckDomainTransferability');
    }
    /**
     * (experimental) Grants permission to delete the specified tags for a domain.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DeleteTagsForDomain.html
     *
     * @experimental
     */
    toDeleteTagsForDomain() {
        return this.to('DeleteTagsForDomain');
    }
    /**
     * (experimental) Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html
     *
     * @experimental
     */
    toDisableDomainAutoRenew() {
        return this.to('DisableDomainAutoRenew');
    }
    /**
     * (experimental) Grants permission to remove the transfer lock on the domain (specifically the clientTransferProhibited status) to allow domain transfers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainTransferLock.html
     *
     * @experimental
     */
    toDisableDomainTransferLock() {
        return this.to('DisableDomainTransferLock');
    }
    /**
     * (experimental) Grants permission to configure Amazon Route 53 to automatically renew the specified domain before the domain registration expires.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_DisableDomainAutoRenew.html
     *
     * @experimental
     */
    toEnableDomainAutoRenew() {
        return this.to('EnableDomainAutoRenew');
    }
    /**
     * (experimental) Grants permission to set the transfer lock on the domain (specifically the clientTransferProhibited status) to prevent domain transfers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_EnableDomainTransferLock.html
     *
     * @experimental
     */
    toEnableDomainTransferLock() {
        return this.to('EnableDomainTransferLock');
    }
    /**
     * (experimental) For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, grants permission to get information about whether the registrant contact has responded.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetContactReachabilityStatus.html
     *
     * @experimental
     */
    toGetContactReachabilityStatus() {
        return this.to('GetContactReachabilityStatus');
    }
    /**
     * (experimental) Grants permission to get detailed information about a domain.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainDetail.html
     *
     * @experimental
     */
    toGetDomainDetail() {
        return this.to('GetDomainDetail');
    }
    /**
     * (experimental) Grants permission to get a list of suggested domain names given a string, which can either be a domain name or simply a word or phrase (without spaces).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetDomainSuggestions.html
     *
     * @experimental
     */
    toGetDomainSuggestions() {
        return this.to('GetDomainSuggestions');
    }
    /**
     * (experimental) Grants permission to get the current status of an operation that is not completed.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_GetOperationDetail.html
     *
     * @experimental
     */
    toGetOperationDetail() {
        return this.to('GetOperationDetail');
    }
    /**
     * (experimental) Grants permission to list all the domain names registered with Amazon Route 53 for the current AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListDomains.html
     *
     * @experimental
     */
    toListDomains() {
        return this.to('ListDomains');
    }
    /**
     * (experimental) Grants permission to list the operation IDs of operations that are not yet complete.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListOperations.html
     *
     * @experimental
     */
    toListOperations() {
        return this.to('ListOperations');
    }
    /**
     * (experimental) Grants permission to list all the tags that are associated with the specified domain.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ListTagsForDomain.html
     *
     * @experimental
     */
    toListTagsForDomain() {
        return this.to('ListTagsForDomain');
    }
    /**
     * (experimental) Grants permission to register domains.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RegisterDomain.html
     *
     * @experimental
     */
    toRegisterDomain() {
        return this.to('RegisterDomain');
    }
    /**
     * (experimental) Grants permission to reject the transfer of a domain from another AWS account to the current AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RejectDomainTransferFromAnotherAwsAccount.html
     *
     * @experimental
     */
    toRejectDomainTransferFromAnotherAwsAccount() {
        return this.to('RejectDomainTransferFromAnotherAwsAccount');
    }
    /**
     * (experimental) Grants permission to renew domains for the specified number of years.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RenewDomain.html
     *
     * @experimental
     */
    toRenewDomain() {
        return this.to('RenewDomain');
    }
    /**
     * (experimental) For operations that require confirmation that the email address for the registrant contact is valid, such as registering a new domain, grants permission to resend the confirmation email to the current email address for the registrant contact.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ResendContactReachabilityEmail.html
     *
     * @experimental
     */
    toResendContactReachabilityEmail() {
        return this.to('ResendContactReachabilityEmail');
    }
    /**
     * (experimental) Grants permission to get the AuthCode for the domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_RetrieveDomainAuthCode.html
     *
     * @experimental
     */
    toRetrieveDomainAuthCode() {
        return this.to('RetrieveDomainAuthCode');
    }
    /**
     * (experimental) Grants permission to transfer a domain from another registrar to Amazon Route 53.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomain.html
     *
     * @experimental
     */
    toTransferDomain() {
        return this.to('TransferDomain');
    }
    /**
     * (experimental) Grants permission to transfer a domain from the current AWS account to another AWS account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_TransferDomainToAnotherAwsAccount.html
     *
     * @experimental
     */
    toTransferDomainToAnotherAwsAccount() {
        return this.to('TransferDomainToAnotherAwsAccount');
    }
    /**
     * (experimental) Grants permission to update the contact information for domain.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContact.html
     *
     * @experimental
     */
    toUpdateDomainContact() {
        return this.to('UpdateDomainContact');
    }
    /**
     * (experimental) Grants permission to update the domain contact privacy setting.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainContactPrivacy.html
     *
     * @experimental
     */
    toUpdateDomainContactPrivacy() {
        return this.to('UpdateDomainContactPrivacy');
    }
    /**
     * (experimental) Grants permission to replace the current set of name servers for a domain with the specified set of name servers.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainNameservers.html
     *
     * @experimental
     */
    toUpdateDomainNameservers() {
        return this.to('UpdateDomainNameservers');
    }
    /**
     * (experimental) Grants permission to add or update tags for a specified domain.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateTagsForDomain.html
     *
     * @experimental
     */
    toUpdateTagsForDomain() {
        return this.to('UpdateTagsForDomain');
    }
    /**
     * (experimental) Grants permission to get all the domain-related billing records for the current AWS account for a specified period.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_ViewBilling.html
     *
     * @experimental
     */
    toViewBilling() {
        return this.to('ViewBilling');
    }
}
exports.Route53domains = Route53domains;
_a = JSII_RTTI_SYMBOL_1;
Route53domains[_a] = { fqn: "iam-floyd.Route53domains", version: "0.277.0" };
//# sourceMappingURL=data:application/json;base64,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