"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthorizationType = exports.Method = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const apigateway_generated_1 = require("./apigateway.generated");
const authorizer_1 = require("./authorizer");
const mock_1 = require("./integrations/mock");
const restapi_1 = require("./restapi");
const util_1 = require("./util");
class Method extends core_1.Resource {
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_MethodProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.resource = props.resource;
        this.api = props.resource.api;
        this.httpMethod = props.httpMethod.toUpperCase();
        util_1.validateHttpMethod(this.httpMethod);
        const options = props.options || {};
        const defaultMethodOptions = props.resource.defaultMethodOptions || {};
        const authorizer = options.authorizer || defaultMethodOptions.authorizer;
        const authorizerId = authorizer === null || authorizer === void 0 ? void 0 : authorizer.authorizerId;
        const authorizationTypeOption = options.authorizationType || defaultMethodOptions.authorizationType;
        const authorizationType = (authorizer === null || authorizer === void 0 ? void 0 : authorizer.authorizationType) || authorizationTypeOption || AuthorizationType.NONE;
        // if the authorizer defines an authorization type and we also have an explicit option set, check that they are the same
        if ((authorizer === null || authorizer === void 0 ? void 0 : authorizer.authorizationType) && authorizationTypeOption && (authorizer === null || authorizer === void 0 ? void 0 : authorizer.authorizationType) !== authorizationTypeOption) {
            throw new Error(`${this.resource}/${this.httpMethod} - Authorization type is set to ${authorizationTypeOption} ` +
                `which is different from what is required by the authorizer [${authorizer.authorizationType}]`);
        }
        if (authorizer_1.Authorizer.isAuthorizer(authorizer)) {
            authorizer._attachToApi(this.api);
        }
        this.methodResponses = (_b = options.methodResponses) !== null && _b !== void 0 ? _b : [];
        const integration = (_d = (_c = props.integration) !== null && _c !== void 0 ? _c : this.resource.defaultIntegration) !== null && _d !== void 0 ? _d : new mock_1.MockIntegration();
        const bindResult = integration.bind(this);
        const methodProps = {
            resourceId: props.resource.resourceId,
            restApiId: this.api.restApiId,
            httpMethod: this.httpMethod,
            operationName: options.operationName || defaultMethodOptions.operationName,
            apiKeyRequired: options.apiKeyRequired || defaultMethodOptions.apiKeyRequired,
            authorizationType,
            authorizerId,
            requestParameters: options.requestParameters || defaultMethodOptions.requestParameters,
            integration: this.renderIntegration(bindResult),
            methodResponses: core_1.Lazy.any({ produce: () => this.renderMethodResponses(this.methodResponses) }, { omitEmptyArray: true }),
            requestModels: this.renderRequestModels(options.requestModels),
            requestValidatorId: this.requestValidatorId(options),
            authorizationScopes: (_e = options.authorizationScopes) !== null && _e !== void 0 ? _e : defaultMethodOptions.authorizationScopes,
        };
        const resource = new apigateway_generated_1.CfnMethod(this, 'Resource', methodProps);
        this.methodId = resource.ref;
        if (restapi_1.RestApiBase._isRestApiBase(props.resource.api)) {
            props.resource.api._attachMethod(this);
        }
        const deployment = props.resource.api.latestDeployment;
        if (deployment) {
            deployment.node.addDependency(resource);
            deployment.addToLogicalId({
                method: {
                    ...methodProps,
                    integrationToken: bindResult === null || bindResult === void 0 ? void 0 : bindResult.deploymentToken,
                },
            });
        }
    }
    /**
     * The RestApi associated with this Method
     * @deprecated - Throws an error if this Resource is not associated with an instance of `RestApi`. Use `api` instead.
     */
    get restApi() {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-apigateway.Method#restApi", "- Throws an error if this Resource is not associated with an instance of `RestApi`. Use `api` instead.");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, jsiiDeprecationWarnings.getPropertyDescriptor(this, "restApi").get);
            }
            throw error;
        }
        return this.resource.restApi;
    }
    /**
     * Returns an execute-api ARN for this method:
     *
     *   arn:aws:execute-api:{region}:{account}:{restApiId}/{stage}/{method}/{path}
     *
     * NOTE: {stage} will refer to the `restApi.deploymentStage`, which will
     * automatically set if auto-deploy is enabled, or can be explicitly assigned.
     * When not configured, {stage} will be set to '*', as a shorthand for 'all stages'.
     *
     * @attribute
     */
    get methodArn() {
        var _b;
        const stage = (_b = this.api.deploymentStage) === null || _b === void 0 ? void 0 : _b.stageName;
        return this.api.arnForExecuteApi(this.httpMethod, pathForArn(this.resource.path), stage);
    }
    /**
     * Returns an execute-api ARN for this method's "test-invoke-stage" stage.
     * This stage is used by the AWS Console UI when testing the method.
     */
    get testMethodArn() {
        return this.api.arnForExecuteApi(this.httpMethod, pathForArn(this.resource.path), 'test-invoke-stage');
    }
    /**
     * Add a method response to this method
     */
    addMethodResponse(methodResponse) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_MethodResponse(methodResponse);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addMethodResponse);
            }
            throw error;
        }
        this.methodResponses.push(methodResponse);
    }
    renderIntegration(bindResult) {
        var _b, _c;
        const options = (_b = bindResult.options) !== null && _b !== void 0 ? _b : {};
        let credentials;
        if (options.credentialsRole) {
            credentials = options.credentialsRole.roleArn;
        }
        else if (options.credentialsPassthrough) {
            // arn:aws:iam::*:user/*
            // eslint-disable-next-line max-len
            credentials = core_1.Stack.of(this).formatArn({ service: 'iam', region: '', account: '*', resource: 'user', arnFormat: core_1.ArnFormat.SLASH_RESOURCE_NAME, resourceName: '*' });
        }
        return {
            type: bindResult.type,
            uri: bindResult.uri,
            cacheKeyParameters: options.cacheKeyParameters,
            cacheNamespace: options.cacheNamespace,
            contentHandling: options.contentHandling,
            integrationHttpMethod: bindResult.integrationHttpMethod,
            requestParameters: options.requestParameters,
            requestTemplates: options.requestTemplates,
            passthroughBehavior: options.passthroughBehavior,
            integrationResponses: options.integrationResponses,
            connectionType: options.connectionType,
            connectionId: options.vpcLink ? options.vpcLink.vpcLinkId : undefined,
            credentials,
            timeoutInMillis: (_c = options.timeout) === null || _c === void 0 ? void 0 : _c.toMilliseconds(),
        };
    }
    renderMethodResponses(methodResponses) {
        if (!methodResponses) {
            // Fall back to nothing
            return undefined;
        }
        return methodResponses.map(mr => {
            let responseModels;
            if (mr.responseModels) {
                responseModels = {};
                for (const contentType in mr.responseModels) {
                    if (mr.responseModels.hasOwnProperty(contentType)) {
                        responseModels[contentType] = mr.responseModels[contentType].modelId;
                    }
                }
            }
            const methodResponseProp = {
                statusCode: mr.statusCode,
                responseParameters: mr.responseParameters,
                responseModels,
            };
            return methodResponseProp;
        });
    }
    renderRequestModels(requestModels) {
        if (!requestModels) {
            // Fall back to nothing
            return undefined;
        }
        const models = {};
        for (const contentType in requestModels) {
            if (requestModels.hasOwnProperty(contentType)) {
                models[contentType] = requestModels[contentType].modelId;
            }
        }
        return models;
    }
    requestValidatorId(options) {
        var _b;
        if (options.requestValidator && options.requestValidatorOptions) {
            throw new Error('Only one of \'requestValidator\' or \'requestValidatorOptions\' must be specified.');
        }
        if (options.requestValidatorOptions) {
            const validator = this.api.addRequestValidator('validator', options.requestValidatorOptions);
            return validator.requestValidatorId;
        }
        // For backward compatibility
        return (_b = options.requestValidator) === null || _b === void 0 ? void 0 : _b.requestValidatorId;
    }
}
exports.Method = Method;
_a = JSII_RTTI_SYMBOL_1;
Method[_a] = { fqn: "@aws-cdk/aws-apigateway.Method", version: "1.156.1" };
var AuthorizationType;
(function (AuthorizationType) {
    /**
     * Open access.
     */
    AuthorizationType["NONE"] = "NONE";
    /**
     * Use AWS IAM permissions.
     */
    AuthorizationType["IAM"] = "AWS_IAM";
    /**
     * Use a custom authorizer.
     */
    AuthorizationType["CUSTOM"] = "CUSTOM";
    /**
     * Use an AWS Cognito user pool.
     */
    AuthorizationType["COGNITO"] = "COGNITO_USER_POOLS";
})(AuthorizationType = exports.AuthorizationType || (exports.AuthorizationType = {}));
function pathForArn(path) {
    return path.replace(/\{[^\}]*\}/g, '*'); // replace path parameters (like '{bookId}') with asterisk
}
//# sourceMappingURL=data:application/json;base64,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