"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProxyResource = exports.Resource = exports.ResourceBase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const apigateway_generated_1 = require("./apigateway.generated");
const cors_1 = require("./cors");
const integrations_1 = require("./integrations");
const method_1 = require("./method");
class ResourceBase extends core_1.Resource {
    constructor(scope, id) {
        super(scope, id);
        this.children = {};
    }
    addResource(pathPart, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_ResourceOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addResource);
            }
            throw error;
        }
        return new Resource(this, pathPart, { parent: this, pathPart, ...options });
    }
    addMethod(httpMethod, integration, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_Integration(integration);
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_MethodOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addMethod);
            }
            throw error;
        }
        return new method_1.Method(this, httpMethod, { resource: this, httpMethod, integration, options });
    }
    addProxy(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_ProxyResourceOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addProxy);
            }
            throw error;
        }
        return new ProxyResource(this, '{proxy+}', { parent: this, ...options });
    }
    addCorsPreflight(options) {
        var _d;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_CorsOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addCorsPreflight);
            }
            throw error;
        }
        const headers = {};
        //
        // Access-Control-Allow-Headers
        const allowHeaders = options.allowHeaders || cors_1.Cors.DEFAULT_HEADERS;
        headers['Access-Control-Allow-Headers'] = `'${allowHeaders.join(',')}'`;
        //
        // Access-Control-Allow-Origin
        if (options.allowOrigins.length === 0) {
            throw new Error('allowOrigins must contain at least one origin');
        }
        if (options.allowOrigins.includes('*') && options.allowOrigins.length > 1) {
            throw new Error(`Invalid "allowOrigins" - cannot mix "*" with specific origins: ${options.allowOrigins.join(',')}`);
        }
        // we use the first origin here and if there are more origins in the list, we
        // will match against them in the response velocity template
        const initialOrigin = options.allowOrigins[0];
        headers['Access-Control-Allow-Origin'] = `'${initialOrigin}'`;
        // the "Vary" header is required if we allow a specific origin
        // https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin#CORS_and_caching
        if (initialOrigin !== '*') {
            headers.Vary = '\'Origin\'';
        }
        //
        // Access-Control-Allow-Methods
        let allowMethods = options.allowMethods || cors_1.Cors.ALL_METHODS;
        if (allowMethods.includes('ANY')) {
            if (allowMethods.length > 1) {
                throw new Error(`ANY cannot be used with any other method. Received: ${allowMethods.join(',')}`);
            }
            allowMethods = cors_1.Cors.ALL_METHODS;
        }
        headers['Access-Control-Allow-Methods'] = `'${allowMethods.join(',')}'`;
        //
        // Access-Control-Allow-Credentials
        if (options.allowCredentials) {
            headers['Access-Control-Allow-Credentials'] = '\'true\'';
        }
        //
        // Access-Control-Max-Age
        let maxAgeSeconds;
        if (options.maxAge && options.disableCache) {
            throw new Error('The options "maxAge" and "disableCache" are mutually exclusive');
        }
        if (options.maxAge) {
            maxAgeSeconds = options.maxAge.toSeconds();
        }
        if (options.disableCache) {
            maxAgeSeconds = -1;
        }
        if (maxAgeSeconds) {
            headers['Access-Control-Max-Age'] = `'${maxAgeSeconds}'`;
        }
        //
        // Access-Control-Expose-Headers
        //
        if (options.exposeHeaders) {
            headers['Access-Control-Expose-Headers'] = `'${options.exposeHeaders.join(',')}'`;
        }
        //
        // statusCode
        const statusCode = (_d = options.statusCode) !== null && _d !== void 0 ? _d : 204;
        //
        // prepare responseParams
        const integrationResponseParams = {};
        const methodResponseParams = {};
        for (const [name, value] of Object.entries(headers)) {
            const key = `method.response.header.${name}`;
            integrationResponseParams[key] = value;
            methodResponseParams[key] = true;
        }
        return this.addMethod('OPTIONS', new integrations_1.MockIntegration({
            requestTemplates: { 'application/json': '{ statusCode: 200 }' },
            integrationResponses: [
                { statusCode: `${statusCode}`, responseParameters: integrationResponseParams, responseTemplates: renderResponseTemplate() },
            ],
        }), {
            methodResponses: [
                { statusCode: `${statusCode}`, responseParameters: methodResponseParams },
            ],
        });
        // renders the response template to match all possible origins (if we have more than one)
        function renderResponseTemplate() {
            const origins = options.allowOrigins.slice(1);
            if (origins.length === 0) {
                return undefined;
            }
            const template = new Array();
            template.push('#set($origin = $input.params().header.get("Origin"))');
            template.push('#if($origin == "") #set($origin = $input.params().header.get("origin")) #end');
            const condition = origins.map(o => `$origin.matches("${o}")`).join(' || ');
            template.push(`#if(${condition})`);
            template.push('  #set($context.responseOverride.header.Access-Control-Allow-Origin = $origin)');
            template.push('#end');
            return {
                'application/json': template.join('\n'),
            };
        }
    }
    getResource(pathPart) {
        return this.children[pathPart];
    }
    /**
     * @internal
     */
    _trackChild(pathPart, resource) {
        this.children[pathPart] = resource;
    }
    resourceForPath(path) {
        if (!path) {
            return this;
        }
        if (path.startsWith('/')) {
            if (this.path !== '/') {
                throw new Error(`Path may start with "/" only for the resource, but we are at: ${this.path}`);
            }
            // trim trailing "/"
            return this.resourceForPath(path.slice(1));
        }
        const parts = path.split('/');
        const next = parts.shift();
        if (!next || next === '') {
            throw new Error('resourceForPath cannot be called with an empty path');
        }
        let resource = this.getResource(next);
        if (!resource) {
            resource = this.addResource(next);
        }
        return resource.resourceForPath(parts.join('/'));
    }
    /**
     * @deprecated - Throws error in some use cases that have been enabled since this deprecation notice. Use `RestApi.urlForPath()` instead.
     */
    get url() {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-apigateway.ResourceBase#url", "- Throws error in some use cases that have been enabled since this deprecation notice. Use `RestApi.urlForPath()` instead.");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, jsiiDeprecationWarnings.getPropertyDescriptor(this, "url").get);
            }
            throw error;
        }
        return this.restApi.urlForPath(this.path);
    }
}
exports.ResourceBase = ResourceBase;
_a = JSII_RTTI_SYMBOL_1;
ResourceBase[_a] = { fqn: "@aws-cdk/aws-apigateway.ResourceBase", version: "1.156.1" };
class Resource extends ResourceBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_ResourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        validateResourcePathPart(props.pathPart);
        this.parentResource = props.parent;
        if (props.parent instanceof ResourceBase) {
            props.parent._trackChild(props.pathPart, this);
        }
        const resourceProps = {
            restApiId: props.parent.api.restApiId,
            parentId: props.parent.resourceId,
            pathPart: props.pathPart,
        };
        const resource = new apigateway_generated_1.CfnResource(this, 'Resource', resourceProps);
        this.resourceId = resource.ref;
        this.api = props.parent.api;
        // render resource path (special case for root)
        this.path = props.parent.path;
        if (!this.path.endsWith('/')) {
            this.path += '/';
        }
        this.path += props.pathPart;
        const deployment = props.parent.api.latestDeployment;
        if (deployment) {
            deployment.node.addDependency(resource);
            deployment.addToLogicalId({ resource: resourceProps });
        }
        // setup defaults based on properties and inherit from parent. method defaults
        // are inherited per property, so children can override piecemeal.
        this.defaultIntegration = props.defaultIntegration || props.parent.defaultIntegration;
        this.defaultMethodOptions = {
            ...props.parent.defaultMethodOptions,
            ...props.defaultMethodOptions,
        };
        this.defaultCorsPreflightOptions = props.defaultCorsPreflightOptions || props.parent.defaultCorsPreflightOptions;
        if (this.defaultCorsPreflightOptions) {
            this.addCorsPreflight(this.defaultCorsPreflightOptions);
        }
    }
    /**
     * Import an existing resource
     */
    static fromResourceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_ResourceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromResourceAttributes);
            }
            throw error;
        }
        class Import extends ResourceBase {
            constructor() {
                super(...arguments);
                this.api = attrs.restApi;
                this.resourceId = attrs.resourceId;
                this.path = attrs.path;
                this.defaultIntegration = undefined;
                this.defaultMethodOptions = undefined;
                this.defaultCorsPreflightOptions = undefined;
            }
            get parentResource() {
                throw new Error('parentResource is not configured for imported resource.');
            }
            get restApi() {
                throw new Error('restApi is not configured for imported resource.');
            }
        }
        return new Import(scope, id);
    }
    /**
     * The RestApi associated with this Resource
     * @deprecated - Throws an error if this Resource is not associated with an instance of `RestApi`. Use `api` instead.
     */
    get restApi() {
        try {
            jsiiDeprecationWarnings.print("@aws-cdk/aws-apigateway.Resource#restApi", "- Throws an error if this Resource is not associated with an instance of `RestApi`. Use `api` instead.");
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, jsiiDeprecationWarnings.getPropertyDescriptor(this, "restApi").get);
            }
            throw error;
        }
        if (!this.parentResource) {
            throw new Error('parentResource was unexpectedly not defined');
        }
        return this.parentResource.restApi;
    }
}
exports.Resource = Resource;
_b = JSII_RTTI_SYMBOL_1;
Resource[_b] = { fqn: "@aws-cdk/aws-apigateway.Resource", version: "1.156.1" };
/**
 * Defines a {proxy+} greedy resource and an ANY method on a route.
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-set-up-simple-proxy.html
 */
class ProxyResource extends Resource {
    constructor(scope, id, props) {
        var _d;
        super(scope, id, {
            parent: props.parent,
            pathPart: '{proxy+}',
            defaultIntegration: props.defaultIntegration,
            defaultMethodOptions: props.defaultMethodOptions,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_ProxyResourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const anyMethod = (_d = props.anyMethod) !== null && _d !== void 0 ? _d : true;
        if (anyMethod) {
            this.anyMethod = this.addMethod('ANY');
        }
    }
    addMethod(httpMethod, integration, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_Integration(integration);
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_MethodOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addMethod);
            }
            throw error;
        }
        // In case this proxy is mounted under the root, also add this method to
        // the root so that empty paths are proxied as well.
        if (this.parentResource && this.parentResource.path === '/') {
            // skip if the root resource already has this method defined
            if (!(this.parentResource.node.tryFindChild(httpMethod) instanceof method_1.Method)) {
                this.parentResource.addMethod(httpMethod, integration, options);
            }
        }
        return super.addMethod(httpMethod, integration, options);
    }
}
exports.ProxyResource = ProxyResource;
_c = JSII_RTTI_SYMBOL_1;
ProxyResource[_c] = { fqn: "@aws-cdk/aws-apigateway.ProxyResource", version: "1.156.1" };
function validateResourcePathPart(part) {
    // strip {} which indicate this is a parameter
    if (part.startsWith('{') && part.endsWith('}')) {
        part = part.slice(1, -1);
        // proxy resources are allowed to end with a '+'
        if (part.endsWith('+')) {
            part = part.slice(0, -1);
        }
    }
    if (!/^[a-zA-Z0-9\.\_\-]+$/.test(part)) {
        throw new Error(`Resource's path part only allow [a-zA-Z0-9._-], an optional trailing '+'
      and curly braces at the beginning and the end: ${part}`);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmVzb3VyY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJyZXNvdXJjZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSx3Q0FBMEY7QUFFMUYsaUVBQXVFO0FBQ3ZFLGlDQUEyQztBQUUzQyxpREFBaUQ7QUFDakQscUNBQWlEO0FBNEpqRCxNQUFzQixZQUFhLFNBQVEsZUFBaUI7SUFlMUQsWUFBWSxLQUFnQixFQUFFLEVBQVU7UUFDdEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUhGLGFBQVEsR0FBcUMsRUFBRyxDQUFDO0tBSWpFO0lBRU0sV0FBVyxDQUFDLFFBQWdCLEVBQUUsT0FBeUI7Ozs7Ozs7Ozs7UUFDNUQsT0FBTyxJQUFJLFFBQVEsQ0FBQyxJQUFJLEVBQUUsUUFBUSxFQUFFLEVBQUUsTUFBTSxFQUFFLElBQUksRUFBRSxRQUFRLEVBQUUsR0FBRyxPQUFPLEVBQUUsQ0FBQyxDQUFDO0tBQzdFO0lBRU0sU0FBUyxDQUFDLFVBQWtCLEVBQUUsV0FBeUIsRUFBRSxPQUF1Qjs7Ozs7Ozs7Ozs7UUFDckYsT0FBTyxJQUFJLGVBQU0sQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRSxVQUFVLEVBQUUsV0FBVyxFQUFFLE9BQU8sRUFBRSxDQUFDLENBQUM7S0FDM0Y7SUFFTSxRQUFRLENBQUMsT0FBOEI7Ozs7Ozs7Ozs7UUFDNUMsT0FBTyxJQUFJLGFBQWEsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFLEVBQUUsTUFBTSxFQUFFLElBQUksRUFBRSxHQUFHLE9BQU8sRUFBRSxDQUFDLENBQUM7S0FDMUU7SUFFTSxnQkFBZ0IsQ0FBQyxPQUFvQjs7Ozs7Ozs7Ozs7UUFDMUMsTUFBTSxPQUFPLEdBQStCLEVBQUcsQ0FBQztRQUVoRCxFQUFFO1FBQ0YsK0JBQStCO1FBRS9CLE1BQU0sWUFBWSxHQUFHLE9BQU8sQ0FBQyxZQUFZLElBQUksV0FBSSxDQUFDLGVBQWUsQ0FBQztRQUNsRSxPQUFPLENBQUMsOEJBQThCLENBQUMsR0FBRyxJQUFJLFlBQVksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQztRQUV4RSxFQUFFO1FBQ0YsOEJBQThCO1FBRTlCLElBQUksT0FBTyxDQUFDLFlBQVksQ0FBQyxNQUFNLEtBQUssQ0FBQyxFQUFFO1lBQ3JDLE1BQU0sSUFBSSxLQUFLLENBQUMsK0NBQStDLENBQUMsQ0FBQztTQUNsRTtRQUVELElBQUksT0FBTyxDQUFDLFlBQVksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLElBQUksT0FBTyxDQUFDLFlBQVksQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFO1lBQ3pFLE1BQU0sSUFBSSxLQUFLLENBQUMsa0VBQWtFLE9BQU8sQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsQ0FBQztTQUNySDtRQUVELDZFQUE2RTtRQUM3RSw0REFBNEQ7UUFDNUQsTUFBTSxhQUFhLEdBQUcsT0FBTyxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUM5QyxPQUFPLENBQUMsNkJBQTZCLENBQUMsR0FBRyxJQUFJLGFBQWEsR0FBRyxDQUFDO1FBRTlELDhEQUE4RDtRQUM5RCx5R0FBeUc7UUFDekcsSUFBSSxhQUFhLEtBQUssR0FBRyxFQUFFO1lBQ3pCLE9BQU8sQ0FBQyxJQUFJLEdBQUcsWUFBWSxDQUFDO1NBQzdCO1FBRUQsRUFBRTtRQUNGLCtCQUErQjtRQUUvQixJQUFJLFlBQVksR0FBRyxPQUFPLENBQUMsWUFBWSxJQUFJLFdBQUksQ0FBQyxXQUFXLENBQUM7UUFFNUQsSUFBSSxZQUFZLENBQUMsUUFBUSxDQUFDLEtBQUssQ0FBQyxFQUFFO1lBQ2hDLElBQUksWUFBWSxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7Z0JBQzNCLE1BQU0sSUFBSSxLQUFLLENBQUMsdURBQXVELFlBQVksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDO2FBQ2xHO1lBRUQsWUFBWSxHQUFHLFdBQUksQ0FBQyxXQUFXLENBQUM7U0FDakM7UUFFRCxPQUFPLENBQUMsOEJBQThCLENBQUMsR0FBRyxJQUFJLFlBQVksQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQztRQUV4RSxFQUFFO1FBQ0YsbUNBQW1DO1FBRW5DLElBQUksT0FBTyxDQUFDLGdCQUFnQixFQUFFO1lBQzVCLE9BQU8sQ0FBQyxrQ0FBa0MsQ0FBQyxHQUFHLFVBQVUsQ0FBQztTQUMxRDtRQUVELEVBQUU7UUFDRix5QkFBeUI7UUFFekIsSUFBSSxhQUFhLENBQUM7UUFFbEIsSUFBSSxPQUFPLENBQUMsTUFBTSxJQUFJLE9BQU8sQ0FBQyxZQUFZLEVBQUU7WUFDMUMsTUFBTSxJQUFJLEtBQUssQ0FBQyxnRUFBZ0UsQ0FBQyxDQUFDO1NBQ25GO1FBRUQsSUFBSSxPQUFPLENBQUMsTUFBTSxFQUFFO1lBQ2xCLGFBQWEsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLFNBQVMsRUFBRSxDQUFDO1NBQzVDO1FBRUQsSUFBSSxPQUFPLENBQUMsWUFBWSxFQUFFO1lBQ3hCLGFBQWEsR0FBRyxDQUFDLENBQUMsQ0FBQztTQUNwQjtRQUVELElBQUksYUFBYSxFQUFFO1lBQ2pCLE9BQU8sQ0FBQyx3QkFBd0IsQ0FBQyxHQUFHLElBQUksYUFBYSxHQUFHLENBQUM7U0FDMUQ7UUFFRCxFQUFFO1FBQ0YsZ0NBQWdDO1FBQ2hDLEVBQUU7UUFFRixJQUFJLE9BQU8sQ0FBQyxhQUFhLEVBQUU7WUFDekIsT0FBTyxDQUFDLCtCQUErQixDQUFDLEdBQUcsSUFBSSxPQUFPLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsR0FBRyxDQUFDO1NBQ25GO1FBRUQsRUFBRTtRQUNGLGFBQWE7UUFFYixNQUFNLFVBQVUsU0FBRyxPQUFPLENBQUMsVUFBVSxtQ0FBSSxHQUFHLENBQUM7UUFFN0MsRUFBRTtRQUNGLHlCQUF5QjtRQUV6QixNQUFNLHlCQUF5QixHQUE0QixFQUFHLENBQUM7UUFDL0QsTUFBTSxvQkFBb0IsR0FBNkIsRUFBRyxDQUFDO1FBRTNELEtBQUssTUFBTSxDQUFDLElBQUksRUFBRSxLQUFLLENBQUMsSUFBSSxNQUFNLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUFFO1lBQ25ELE1BQU0sR0FBRyxHQUFHLDBCQUEwQixJQUFJLEVBQUUsQ0FBQztZQUM3Qyx5QkFBeUIsQ0FBQyxHQUFHLENBQUMsR0FBRyxLQUFLLENBQUM7WUFDdkMsb0JBQW9CLENBQUMsR0FBRyxDQUFDLEdBQUcsSUFBSSxDQUFDO1NBQ2xDO1FBRUQsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDLFNBQVMsRUFBRSxJQUFJLDhCQUFlLENBQUM7WUFDbkQsZ0JBQWdCLEVBQUUsRUFBRSxrQkFBa0IsRUFBRSxxQkFBcUIsRUFBRTtZQUMvRCxvQkFBb0IsRUFBRTtnQkFDcEIsRUFBRSxVQUFVLEVBQUUsR0FBRyxVQUFVLEVBQUUsRUFBRSxrQkFBa0IsRUFBRSx5QkFBeUIsRUFBRSxpQkFBaUIsRUFBRSxzQkFBc0IsRUFBRSxFQUFFO2FBQzVIO1NBQ0YsQ0FBQyxFQUFFO1lBQ0YsZUFBZSxFQUFFO2dCQUNmLEVBQUUsVUFBVSxFQUFFLEdBQUcsVUFBVSxFQUFFLEVBQUUsa0JBQWtCLEVBQUUsb0JBQW9CLEVBQUU7YUFDMUU7U0FDRixDQUFDLENBQUM7UUFFSCx5RkFBeUY7UUFDekYsU0FBUyxzQkFBc0I7WUFDN0IsTUFBTSxPQUFPLEdBQUcsT0FBTyxDQUFDLFlBQVksQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFFOUMsSUFBSSxPQUFPLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtnQkFDeEIsT0FBTyxTQUFTLENBQUM7YUFDbEI7WUFFRCxNQUFNLFFBQVEsR0FBRyxJQUFJLEtBQUssRUFBVSxDQUFDO1lBRXJDLFFBQVEsQ0FBQyxJQUFJLENBQUMsc0RBQXNELENBQUMsQ0FBQztZQUN0RSxRQUFRLENBQUMsSUFBSSxDQUFDLDhFQUE4RSxDQUFDLENBQUM7WUFFOUYsTUFBTSxTQUFTLEdBQUcsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztZQUUzRSxRQUFRLENBQUMsSUFBSSxDQUFDLE9BQU8sU0FBUyxHQUFHLENBQUMsQ0FBQztZQUNuQyxRQUFRLENBQUMsSUFBSSxDQUFDLGdGQUFnRixDQUFDLENBQUM7WUFDaEcsUUFBUSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztZQUV0QixPQUFPO2dCQUNMLGtCQUFrQixFQUFFLFFBQVEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDO2FBQ3hDLENBQUM7UUFDSixDQUFDO0tBQ0Y7SUFFTSxXQUFXLENBQUMsUUFBZ0I7UUFDakMsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxDQUFDO0tBQ2hDO0lBRUQ7O09BRUc7SUFDSSxXQUFXLENBQUMsUUFBZ0IsRUFBRSxRQUFrQjtRQUNyRCxJQUFJLENBQUMsUUFBUSxDQUFDLFFBQVEsQ0FBQyxHQUFHLFFBQVEsQ0FBQztLQUNwQztJQUVNLGVBQWUsQ0FBQyxJQUFZO1FBQ2pDLElBQUksQ0FBQyxJQUFJLEVBQUU7WUFDVCxPQUFPLElBQUksQ0FBQztTQUNiO1FBRUQsSUFBSSxJQUFJLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxFQUFFO1lBQ3hCLElBQUksSUFBSSxDQUFDLElBQUksS0FBSyxHQUFHLEVBQUU7Z0JBQ3JCLE1BQU0sSUFBSSxLQUFLLENBQUMsaUVBQWlFLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQyxDQUFDO2FBQy9GO1lBRUQsb0JBQW9CO1lBQ3BCLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7U0FDNUM7UUFFRCxNQUFNLEtBQUssR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQzlCLE1BQU0sSUFBSSxHQUFHLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUMzQixJQUFJLENBQUMsSUFBSSxJQUFJLElBQUksS0FBSyxFQUFFLEVBQUU7WUFDeEIsTUFBTSxJQUFJLEtBQUssQ0FBQyxxREFBcUQsQ0FBQyxDQUFDO1NBQ3hFO1FBRUQsSUFBSSxRQUFRLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUN0QyxJQUFJLENBQUMsUUFBUSxFQUFFO1lBQ2IsUUFBUSxHQUFHLElBQUksQ0FBQyxXQUFXLENBQUMsSUFBSSxDQUFDLENBQUM7U0FDbkM7UUFFRCxPQUFPLFFBQVEsQ0FBQyxlQUFlLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0tBQ2xEO0lBRUQ7O09BRUc7SUFDSCxJQUFXLEdBQUc7Ozs7Ozs7Ozs7UUFDWixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztLQUMzQzs7QUFsTkgsb0NBbU5DOzs7QUFzQkQsTUFBYSxRQUFTLFNBQVEsWUFBWTtJQWtDeEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFvQjtRQUM1RCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDOzs7Ozs7Ozs7O1FBRWpCLHdCQUF3QixDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUV6QyxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUM7UUFFbkMsSUFBSSxLQUFLLENBQUMsTUFBTSxZQUFZLFlBQVksRUFBRTtZQUN4QyxLQUFLLENBQUMsTUFBTSxDQUFDLFdBQVcsQ0FBQyxLQUFLLENBQUMsUUFBUSxFQUFFLElBQUksQ0FBQyxDQUFDO1NBQ2hEO1FBRUQsTUFBTSxhQUFhLEdBQXFCO1lBQ3RDLFNBQVMsRUFBRSxLQUFLLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxTQUFTO1lBQ3JDLFFBQVEsRUFBRSxLQUFLLENBQUMsTUFBTSxDQUFDLFVBQVU7WUFDakMsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO1NBQ3pCLENBQUM7UUFDRixNQUFNLFFBQVEsR0FBRyxJQUFJLGtDQUFXLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRSxhQUFhLENBQUMsQ0FBQztRQUVsRSxJQUFJLENBQUMsVUFBVSxHQUFHLFFBQVEsQ0FBQyxHQUFHLENBQUM7UUFDL0IsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQztRQUU1QiwrQ0FBK0M7UUFDL0MsSUFBSSxDQUFDLElBQUksR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQztRQUM5QixJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLEVBQUU7WUFBRSxJQUFJLENBQUMsSUFBSSxJQUFJLEdBQUcsQ0FBQztTQUFFO1FBQ25ELElBQUksQ0FBQyxJQUFJLElBQUksS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUU1QixNQUFNLFVBQVUsR0FBRyxLQUFLLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQztRQUNyRCxJQUFJLFVBQVUsRUFBRTtZQUNkLFVBQVUsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1lBQ3hDLFVBQVUsQ0FBQyxjQUFjLENBQUMsRUFBRSxRQUFRLEVBQUUsYUFBYSxFQUFFLENBQUMsQ0FBQztTQUN4RDtRQUVELDhFQUE4RTtRQUM5RSxrRUFBa0U7UUFDbEUsSUFBSSxDQUFDLGtCQUFrQixHQUFHLEtBQUssQ0FBQyxrQkFBa0IsSUFBSSxLQUFLLENBQUMsTUFBTSxDQUFDLGtCQUFrQixDQUFDO1FBQ3RGLElBQUksQ0FBQyxvQkFBb0IsR0FBRztZQUMxQixHQUFHLEtBQUssQ0FBQyxNQUFNLENBQUMsb0JBQW9CO1lBQ3BDLEdBQUcsS0FBSyxDQUFDLG9CQUFvQjtTQUM5QixDQUFDO1FBQ0YsSUFBSSxDQUFDLDJCQUEyQixHQUFHLEtBQUssQ0FBQywyQkFBMkIsSUFBSSxLQUFLLENBQUMsTUFBTSxDQUFDLDJCQUEyQixDQUFDO1FBRWpILElBQUksSUFBSSxDQUFDLDJCQUEyQixFQUFFO1lBQ3BDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsMkJBQTJCLENBQUMsQ0FBQztTQUN6RDtLQUNGO0lBN0VEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLHNCQUFzQixDQUFDLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQXlCOzs7Ozs7Ozs7O1FBQzFGLE1BQU0sTUFBTyxTQUFRLFlBQVk7WUFBakM7O2dCQUNrQixRQUFHLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztnQkFDcEIsZUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLENBQUM7Z0JBQzlCLFNBQUksR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDO2dCQUNsQix1QkFBa0IsR0FBaUIsU0FBUyxDQUFDO2dCQUM3Qyx5QkFBb0IsR0FBbUIsU0FBUyxDQUFDO2dCQUNqRCxnQ0FBMkIsR0FBaUIsU0FBUyxDQUFDO1lBU3hFLENBQUM7WUFQQyxJQUFXLGNBQWM7Z0JBQ3ZCLE1BQU0sSUFBSSxLQUFLLENBQUMseURBQXlELENBQUMsQ0FBQztZQUM3RSxDQUFDO1lBRUQsSUFBVyxPQUFPO2dCQUNoQixNQUFNLElBQUksS0FBSyxDQUFDLGtEQUFrRCxDQUFDLENBQUM7WUFDdEUsQ0FBQztTQUNGO1FBRUQsT0FBTyxJQUFJLE1BQU0sQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7S0FDOUI7SUF5REQ7OztPQUdHO0lBQ0gsSUFBVyxPQUFPOzs7Ozs7Ozs7O1FBQ2hCLElBQUksQ0FBQyxJQUFJLENBQUMsY0FBYyxFQUFFO1lBQ3hCLE1BQU0sSUFBSSxLQUFLLENBQUMsNkNBQTZDLENBQUMsQ0FBQztTQUNoRTtRQUNELE9BQU8sSUFBSSxDQUFDLGNBQWMsQ0FBQyxPQUFPLENBQUM7S0FDcEM7O0FBekZILDRCQTBGQzs7O0FBb0JEOzs7R0FHRztBQUNILE1BQWEsYUFBYyxTQUFRLFFBQVE7SUFPekMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUF5Qjs7UUFDakUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixNQUFNLEVBQUUsS0FBSyxDQUFDLE1BQU07WUFDcEIsUUFBUSxFQUFFLFVBQVU7WUFDcEIsa0JBQWtCLEVBQUUsS0FBSyxDQUFDLGtCQUFrQjtZQUM1QyxvQkFBb0IsRUFBRSxLQUFLLENBQUMsb0JBQW9CO1NBQ2pELENBQUMsQ0FBQzs7Ozs7Ozs7OztRQUVILE1BQU0sU0FBUyxTQUFHLEtBQUssQ0FBQyxTQUFTLG1DQUFJLElBQUksQ0FBQztRQUMxQyxJQUFJLFNBQVMsRUFBRTtZQUNiLElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQztTQUN4QztLQUNGO0lBRU0sU0FBUyxDQUFDLFVBQWtCLEVBQUUsV0FBeUIsRUFBRSxPQUF1Qjs7Ozs7Ozs7Ozs7UUFDckYsd0VBQXdFO1FBQ3hFLG9EQUFvRDtRQUNwRCxJQUFJLElBQUksQ0FBQyxjQUFjLElBQUksSUFBSSxDQUFDLGNBQWMsQ0FBQyxJQUFJLEtBQUssR0FBRyxFQUFFO1lBQzNELDREQUE0RDtZQUM1RCxJQUFJLENBQUMsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsVUFBVSxDQUFDLFlBQVksZUFBTSxDQUFDLEVBQUU7Z0JBQzFFLElBQUksQ0FBQyxjQUFjLENBQUMsU0FBUyxDQUFDLFVBQVUsRUFBRSxXQUFXLEVBQUUsT0FBTyxDQUFDLENBQUM7YUFDakU7U0FDRjtRQUNELE9BQU8sS0FBSyxDQUFDLFNBQVMsQ0FBQyxVQUFVLEVBQUUsV0FBVyxFQUFFLE9BQU8sQ0FBQyxDQUFDO0tBQzFEOztBQS9CSCxzQ0FnQ0M7OztBQUVELFNBQVMsd0JBQXdCLENBQUMsSUFBWTtJQUM1Qyw4Q0FBOEM7SUFDOUMsSUFBSSxJQUFJLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLEVBQUU7UUFDOUMsSUFBSSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFFekIsZ0RBQWdEO1FBQ2hELElBQUksSUFBSSxDQUFDLFFBQVEsQ0FBQyxHQUFHLENBQUMsRUFBRTtZQUN0QixJQUFJLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztTQUMxQjtLQUNGO0lBRUQsSUFBSSxDQUFDLHNCQUFzQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsRUFBRTtRQUN0QyxNQUFNLElBQUksS0FBSyxDQUFDO3VEQUNtQyxJQUFJLEVBQUUsQ0FBQyxDQUFDO0tBQzVEO0FBQ0gsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElSZXNvdXJjZSBhcyBJUmVzb3VyY2VCYXNlLCBSZXNvdXJjZSBhcyBSZXNvdXJjZUNvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDZm5SZXNvdXJjZSwgQ2ZuUmVzb3VyY2VQcm9wcyB9IGZyb20gJy4vYXBpZ2F0ZXdheS5nZW5lcmF0ZWQnO1xuaW1wb3J0IHsgQ29ycywgQ29yc09wdGlvbnMgfSBmcm9tICcuL2NvcnMnO1xuaW1wb3J0IHsgSW50ZWdyYXRpb24gfSBmcm9tICcuL2ludGVncmF0aW9uJztcbmltcG9ydCB7IE1vY2tJbnRlZ3JhdGlvbiB9IGZyb20gJy4vaW50ZWdyYXRpb25zJztcbmltcG9ydCB7IE1ldGhvZCwgTWV0aG9kT3B0aW9ucyB9IGZyb20gJy4vbWV0aG9kJztcbmltcG9ydCB7IElSZXN0QXBpLCBSZXN0QXBpIH0gZnJvbSAnLi9yZXN0YXBpJztcblxuZXhwb3J0IGludGVyZmFjZSBJUmVzb3VyY2UgZXh0ZW5kcyBJUmVzb3VyY2VCYXNlIHtcbiAgLyoqXG4gICAqIFRoZSBwYXJlbnQgb2YgdGhpcyByZXNvdXJjZSBvciB1bmRlZmluZWQgZm9yIHRoZSByb290IHJlc291cmNlLlxuICAgKi9cbiAgcmVhZG9ubHkgcGFyZW50UmVzb3VyY2U/OiBJUmVzb3VyY2U7XG5cbiAgLyoqXG4gICAqIFRoZSByZXN0IEFQSSB0aGF0IHRoaXMgcmVzb3VyY2UgaXMgcGFydCBvZi5cbiAgICpcbiAgICogQGRlcHJlY2F0ZWQgLSBUaHJvd3MgYW4gZXJyb3IgaWYgdGhpcyBSZXNvdXJjZSBpcyBub3QgYXNzb2NpYXRlZCB3aXRoIGFuIGluc3RhbmNlIG9mIGBSZXN0QXBpYC4gVXNlIGBhcGlgIGluc3RlYWQuXG4gICAqL1xuICByZWFkb25seSByZXN0QXBpOiBSZXN0QXBpO1xuXG4gIC8qKlxuICAgKiBUaGUgcmVzdCBBUEkgdGhhdCB0aGlzIHJlc291cmNlIGlzIHBhcnQgb2YuXG4gICAqXG4gICAqIFRoZSByZWFzb24gd2UgbmVlZCB0aGUgUmVzdEFwaSBvYmplY3QgaXRzZWxmIGFuZCBub3QganVzdCB0aGUgSUQgaXMgYmVjYXVzZSB0aGUgbW9kZWxcbiAgICogaXMgYmVpbmcgdHJhY2tlZCBieSB0aGUgdG9wLWxldmVsIFJlc3RBcGkgb2JqZWN0IGZvciB0aGUgcHVycG9zZSBvZiBjYWxjdWxhdGluZyBpdCdzXG4gICAqIGhhc2ggdG8gZGV0ZXJtaW5lIHRoZSBJRCBvZiB0aGUgZGVwbG95bWVudC4gVGhpcyBhbGxvd3MgdXMgdG8gYXV0b21hdGljYWxseSB1cGRhdGVcbiAgICogdGhlIGRlcGxveW1lbnQgd2hlbiB0aGUgbW9kZWwgb2YgdGhlIFJFU1QgQVBJIGNoYW5nZXMuXG4gICAqL1xuICByZWFkb25seSBhcGk6IElSZXN0QXBpO1xuXG4gIC8qKlxuICAgKiBUaGUgSUQgb2YgdGhlIHJlc291cmNlLlxuICAgKiBAYXR0cmlidXRlXG4gICAqL1xuICByZWFkb25seSByZXNvdXJjZUlkOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBmdWxsIHBhdGggb2YgdGhpcyByZXNvdXJjZS5cbiAgICovXG4gIHJlYWRvbmx5IHBhdGg6IHN0cmluZztcblxuICAvKipcbiAgICogQW4gaW50ZWdyYXRpb24gdG8gdXNlIGFzIGEgZGVmYXVsdCBmb3IgYWxsIG1ldGhvZHMgY3JlYXRlZCB3aXRoaW4gdGhpc1xuICAgKiBBUEkgdW5sZXNzIGFuIGludGVncmF0aW9uIGlzIHNwZWNpZmllZC5cbiAgICovXG4gIHJlYWRvbmx5IGRlZmF1bHRJbnRlZ3JhdGlvbj86IEludGVncmF0aW9uO1xuXG4gIC8qKlxuICAgKiBNZXRob2Qgb3B0aW9ucyB0byB1c2UgYXMgYSBkZWZhdWx0IGZvciBhbGwgbWV0aG9kcyBjcmVhdGVkIHdpdGhpbiB0aGlzXG4gICAqIEFQSSB1bmxlc3MgY3VzdG9tIG9wdGlvbnMgYXJlIHNwZWNpZmllZC5cbiAgICovXG4gIHJlYWRvbmx5IGRlZmF1bHRNZXRob2RPcHRpb25zPzogTWV0aG9kT3B0aW9ucztcblxuICAvKipcbiAgICogRGVmYXVsdCBvcHRpb25zIGZvciBDT1JTIHByZWZsaWdodCBPUFRJT05TIG1ldGhvZC5cbiAgICovXG4gIHJlYWRvbmx5IGRlZmF1bHRDb3JzUHJlZmxpZ2h0T3B0aW9ucz86IENvcnNPcHRpb25zO1xuXG4gIC8qKlxuICAgKiBHZXRzIG9yIGNyZWF0ZSBhbGwgcmVzb3VyY2VzIGxlYWRpbmcgdXAgdG8gdGhlIHNwZWNpZmllZCBwYXRoLlxuICAgKlxuICAgKiAtIFBhdGggbWF5IG9ubHkgc3RhcnQgd2l0aCBcIi9cIiBpZiB0aGlzIG1ldGhvZCBpcyBjYWxsZWQgb24gdGhlIHJvb3QgcmVzb3VyY2UuXG4gICAqIC0gQWxsIHJlc291cmNlcyBhcmUgY3JlYXRlZCB1c2luZyBkZWZhdWx0IG9wdGlvbnMuXG4gICAqXG4gICAqIEBwYXJhbSBwYXRoIFRoZSByZWxhdGl2ZSBwYXRoXG4gICAqIEByZXR1cm5zIGEgbmV3IG9yIGV4aXN0aW5nIHJlc291cmNlLlxuICAgKi9cbiAgcmVzb3VyY2VGb3JQYXRoKHBhdGg6IHN0cmluZyk6IFJlc291cmNlO1xuXG4gIC8qKlxuICAgKiBEZWZpbmVzIGEgbmV3IGNoaWxkIHJlc291cmNlIHdoZXJlIHRoaXMgcmVzb3VyY2UgaXMgdGhlIHBhcmVudC5cbiAgICogQHBhcmFtIHBhdGhQYXJ0IFRoZSBwYXRoIHBhcnQgZm9yIHRoZSBjaGlsZCByZXNvdXJjZVxuICAgKiBAcGFyYW0gb3B0aW9ucyBSZXNvdXJjZSBvcHRpb25zXG4gICAqIEByZXR1cm5zIEEgUmVzb3VyY2Ugb2JqZWN0XG4gICAqL1xuICBhZGRSZXNvdXJjZShwYXRoUGFydDogc3RyaW5nLCBvcHRpb25zPzogUmVzb3VyY2VPcHRpb25zKTogUmVzb3VyY2U7XG5cbiAgLyoqXG4gICAqIFJldHJpZXZlcyBhIGNoaWxkIHJlc291cmNlIGJ5IHBhdGggcGFydC5cbiAgICpcbiAgICogQHBhcmFtIHBhdGhQYXJ0IFRoZSBwYXRoIHBhcnQgb2YgdGhlIGNoaWxkIHJlc291cmNlXG4gICAqIEByZXR1cm5zIHRoZSBjaGlsZCByZXNvdXJjZSBvciB1bmRlZmluZWQgaWYgbm90IGZvdW5kXG4gICAqL1xuICBnZXRSZXNvdXJjZShwYXRoUGFydDogc3RyaW5nKTogSVJlc291cmNlIHwgdW5kZWZpbmVkO1xuXG4gIC8qKlxuICAgKiBBZGRzIGEgZ3JlZWR5IHByb3h5IHJlc291cmNlIChcIntwcm94eSt9XCIpIGFuZCBhbiBBTlkgbWV0aG9kIHRvIHRoaXMgcm91dGUuXG4gICAqIEBwYXJhbSBvcHRpb25zIERlZmF1bHQgaW50ZWdyYXRpb24gYW5kIG1ldGhvZCBvcHRpb25zLlxuICAgKi9cbiAgYWRkUHJveHkob3B0aW9ucz86IFByb3h5UmVzb3VyY2VPcHRpb25zKTogUHJveHlSZXNvdXJjZTtcblxuICAvKipcbiAgICogRGVmaW5lcyBhIG5ldyBtZXRob2QgZm9yIHRoaXMgcmVzb3VyY2UuXG4gICAqIEBwYXJhbSBodHRwTWV0aG9kIFRoZSBIVFRQIG1ldGhvZFxuICAgKiBAcGFyYW0gdGFyZ2V0IFRoZSB0YXJnZXQgYmFja2VuZCBpbnRlZ3JhdGlvbiBmb3IgdGhpcyBtZXRob2RcbiAgICogQHBhcmFtIG9wdGlvbnMgTWV0aG9kIG9wdGlvbnMsIHN1Y2ggYXMgYXV0aGVudGljYXRpb24uXG4gICAqXG4gICAqIEByZXR1cm5zIFRoZSBuZXdseSBjcmVhdGVkIGBNZXRob2RgIG9iamVjdC5cbiAgICovXG4gIGFkZE1ldGhvZChodHRwTWV0aG9kOiBzdHJpbmcsIHRhcmdldD86IEludGVncmF0aW9uLCBvcHRpb25zPzogTWV0aG9kT3B0aW9ucyk6IE1ldGhvZDtcblxuICAvKipcbiAgICogQWRkcyBhbiBPUFRJT05TIG1ldGhvZCB0byB0aGlzIHJlc291cmNlIHdoaWNoIHJlc3BvbmRzIHRvIENyb3NzLU9yaWdpblxuICAgKiBSZXNvdXJjZSBTaGFyaW5nIChDT1JTKSBwcmVmbGlnaHQgcmVxdWVzdHMuXG4gICAqXG4gICAqIENyb3NzLU9yaWdpbiBSZXNvdXJjZSBTaGFyaW5nIChDT1JTKSBpcyBhIG1lY2hhbmlzbSB0aGF0IHVzZXMgYWRkaXRpb25hbFxuICAgKiBIVFRQIGhlYWRlcnMgdG8gdGVsbCBicm93c2VycyB0byBnaXZlIGEgd2ViIGFwcGxpY2F0aW9uIHJ1bm5pbmcgYXQgb25lXG4gICAqIG9yaWdpbiwgYWNjZXNzIHRvIHNlbGVjdGVkIHJlc291cmNlcyBmcm9tIGEgZGlmZmVyZW50IG9yaWdpbi4gQSB3ZWJcbiAgICogYXBwbGljYXRpb24gZXhlY3V0ZXMgYSBjcm9zcy1vcmlnaW4gSFRUUCByZXF1ZXN0IHdoZW4gaXQgcmVxdWVzdHMgYVxuICAgKiByZXNvdXJjZSB0aGF0IGhhcyBhIGRpZmZlcmVudCBvcmlnaW4gKGRvbWFpbiwgcHJvdG9jb2wsIG9yIHBvcnQpIGZyb20gaXRzXG4gICAqIG93bi5cbiAgICpcbiAgICogQHNlZSBodHRwczovL2RldmVsb3Blci5tb3ppbGxhLm9yZy9lbi1VUy9kb2NzL1dlYi9IVFRQL0NPUlNcbiAgICogQHBhcmFtIG9wdGlvbnMgQ09SUyBvcHRpb25zXG4gICAqIEByZXR1cm5zIGEgYE1ldGhvZGAgb2JqZWN0XG4gICAqL1xuICBhZGRDb3JzUHJlZmxpZ2h0KG9wdGlvbnM6IENvcnNPcHRpb25zKTogTWV0aG9kO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIFJlc291cmNlT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBBbiBpbnRlZ3JhdGlvbiB0byB1c2UgYXMgYSBkZWZhdWx0IGZvciBhbGwgbWV0aG9kcyBjcmVhdGVkIHdpdGhpbiB0aGlzXG4gICAqIEFQSSB1bmxlc3MgYW4gaW50ZWdyYXRpb24gaXMgc3BlY2lmaWVkLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIEluaGVyaXRlZCBmcm9tIHBhcmVudC5cbiAgICovXG4gIHJlYWRvbmx5IGRlZmF1bHRJbnRlZ3JhdGlvbj86IEludGVncmF0aW9uO1xuXG4gIC8qKlxuICAgKiBNZXRob2Qgb3B0aW9ucyB0byB1c2UgYXMgYSBkZWZhdWx0IGZvciBhbGwgbWV0aG9kcyBjcmVhdGVkIHdpdGhpbiB0aGlzXG4gICAqIEFQSSB1bmxlc3MgY3VzdG9tIG9wdGlvbnMgYXJlIHNwZWNpZmllZC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBJbmhlcml0ZWQgZnJvbSBwYXJlbnQuXG4gICAqL1xuICByZWFkb25seSBkZWZhdWx0TWV0aG9kT3B0aW9ucz86IE1ldGhvZE9wdGlvbnM7XG5cbiAgLyoqXG4gICAqIEFkZHMgYSBDT1JTIHByZWZsaWdodCBPUFRJT05TIG1ldGhvZCB0byB0aGlzIHJlc291cmNlIGFuZCBhbGwgY2hpbGRcbiAgICogcmVzb3VyY2VzLlxuICAgKlxuICAgKiBZb3UgY2FuIGFkZCBDT1JTIGF0IHRoZSByZXNvdXJjZS1sZXZlbCB1c2luZyBgYWRkQ29yc1ByZWZsaWdodGAuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gQ09SUyBpcyBkaXNhYmxlZFxuICAgKi9cbiAgcmVhZG9ubHkgZGVmYXVsdENvcnNQcmVmbGlnaHRPcHRpb25zPzogQ29yc09wdGlvbnM7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUmVzb3VyY2VQcm9wcyBleHRlbmRzIFJlc291cmNlT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBUaGUgcGFyZW50IHJlc291cmNlIG9mIHRoaXMgcmVzb3VyY2UuIFlvdSBjYW4gZWl0aGVyIHBhc3MgYW5vdGhlclxuICAgKiBgUmVzb3VyY2VgIG9iamVjdCBvciBhIGBSZXN0QXBpYCBvYmplY3QgaGVyZS5cbiAgICovXG4gIHJlYWRvbmx5IHBhcmVudDogSVJlc291cmNlO1xuXG4gIC8qKlxuICAgKiBBIHBhdGggbmFtZSBmb3IgdGhlIHJlc291cmNlLlxuICAgKi9cbiAgcmVhZG9ubHkgcGF0aFBhcnQ6IHN0cmluZztcbn1cblxuZXhwb3J0IGFic3RyYWN0IGNsYXNzIFJlc291cmNlQmFzZSBleHRlbmRzIFJlc291cmNlQ29uc3RydWN0IGltcGxlbWVudHMgSVJlc291cmNlIHtcbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IHBhcmVudFJlc291cmNlPzogSVJlc291cmNlO1xuICAvKipcbiAgICogQGRlcHJlY2F0ZWQgLSAgVGhyb3dzIGFuIGVycm9yIGlmIHRoaXMgUmVzb3VyY2UgaXMgbm90IGFzc29jaWF0ZWQgd2l0aCBhbiBpbnN0YW5jZSBvZiBgUmVzdEFwaWAuIFVzZSBgYXBpYCBpbnN0ZWFkLlxuICAgKi9cbiAgcHVibGljIGFic3RyYWN0IHJlYWRvbmx5IHJlc3RBcGk6IFJlc3RBcGk7XG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBhcGk6IElSZXN0QXBpO1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgcmVzb3VyY2VJZDogc3RyaW5nO1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgcGF0aDogc3RyaW5nO1xuICBwdWJsaWMgYWJzdHJhY3QgcmVhZG9ubHkgZGVmYXVsdEludGVncmF0aW9uPzogSW50ZWdyYXRpb247XG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBkZWZhdWx0TWV0aG9kT3B0aW9ucz86IE1ldGhvZE9wdGlvbnM7XG4gIHB1YmxpYyBhYnN0cmFjdCByZWFkb25seSBkZWZhdWx0Q29yc1ByZWZsaWdodE9wdGlvbnM/OiBDb3JzT3B0aW9ucztcblxuICBwcml2YXRlIHJlYWRvbmx5IGNoaWxkcmVuOiB7IFtwYXRoUGFydDogc3RyaW5nXTogUmVzb3VyY2UgfSA9IHsgfTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgfVxuXG4gIHB1YmxpYyBhZGRSZXNvdXJjZShwYXRoUGFydDogc3RyaW5nLCBvcHRpb25zPzogUmVzb3VyY2VPcHRpb25zKTogUmVzb3VyY2Uge1xuICAgIHJldHVybiBuZXcgUmVzb3VyY2UodGhpcywgcGF0aFBhcnQsIHsgcGFyZW50OiB0aGlzLCBwYXRoUGFydCwgLi4ub3B0aW9ucyB9KTtcbiAgfVxuXG4gIHB1YmxpYyBhZGRNZXRob2QoaHR0cE1ldGhvZDogc3RyaW5nLCBpbnRlZ3JhdGlvbj86IEludGVncmF0aW9uLCBvcHRpb25zPzogTWV0aG9kT3B0aW9ucyk6IE1ldGhvZCB7XG4gICAgcmV0dXJuIG5ldyBNZXRob2QodGhpcywgaHR0cE1ldGhvZCwgeyByZXNvdXJjZTogdGhpcywgaHR0cE1ldGhvZCwgaW50ZWdyYXRpb24sIG9wdGlvbnMgfSk7XG4gIH1cblxuICBwdWJsaWMgYWRkUHJveHkob3B0aW9ucz86IFByb3h5UmVzb3VyY2VPcHRpb25zKTogUHJveHlSZXNvdXJjZSB7XG4gICAgcmV0dXJuIG5ldyBQcm94eVJlc291cmNlKHRoaXMsICd7cHJveHkrfScsIHsgcGFyZW50OiB0aGlzLCAuLi5vcHRpb25zIH0pO1xuICB9XG5cbiAgcHVibGljIGFkZENvcnNQcmVmbGlnaHQob3B0aW9uczogQ29yc09wdGlvbnMpIHtcbiAgICBjb25zdCBoZWFkZXJzOiB7IFtuYW1lOiBzdHJpbmddOiBzdHJpbmcgfSA9IHsgfTtcblxuICAgIC8vXG4gICAgLy8gQWNjZXNzLUNvbnRyb2wtQWxsb3ctSGVhZGVyc1xuXG4gICAgY29uc3QgYWxsb3dIZWFkZXJzID0gb3B0aW9ucy5hbGxvd0hlYWRlcnMgfHwgQ29ycy5ERUZBVUxUX0hFQURFUlM7XG4gICAgaGVhZGVyc1snQWNjZXNzLUNvbnRyb2wtQWxsb3ctSGVhZGVycyddID0gYCcke2FsbG93SGVhZGVycy5qb2luKCcsJyl9J2A7XG5cbiAgICAvL1xuICAgIC8vIEFjY2Vzcy1Db250cm9sLUFsbG93LU9yaWdpblxuXG4gICAgaWYgKG9wdGlvbnMuYWxsb3dPcmlnaW5zLmxlbmd0aCA9PT0gMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdhbGxvd09yaWdpbnMgbXVzdCBjb250YWluIGF0IGxlYXN0IG9uZSBvcmlnaW4nKTtcbiAgICB9XG5cbiAgICBpZiAob3B0aW9ucy5hbGxvd09yaWdpbnMuaW5jbHVkZXMoJyonKSAmJiBvcHRpb25zLmFsbG93T3JpZ2lucy5sZW5ndGggPiAxKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoYEludmFsaWQgXCJhbGxvd09yaWdpbnNcIiAtIGNhbm5vdCBtaXggXCIqXCIgd2l0aCBzcGVjaWZpYyBvcmlnaW5zOiAke29wdGlvbnMuYWxsb3dPcmlnaW5zLmpvaW4oJywnKX1gKTtcbiAgICB9XG5cbiAgICAvLyB3ZSB1c2UgdGhlIGZpcnN0IG9yaWdpbiBoZXJlIGFuZCBpZiB0aGVyZSBhcmUgbW9yZSBvcmlnaW5zIGluIHRoZSBsaXN0LCB3ZVxuICAgIC8vIHdpbGwgbWF0Y2ggYWdhaW5zdCB0aGVtIGluIHRoZSByZXNwb25zZSB2ZWxvY2l0eSB0ZW1wbGF0ZVxuICAgIGNvbnN0IGluaXRpYWxPcmlnaW4gPSBvcHRpb25zLmFsbG93T3JpZ2luc1swXTtcbiAgICBoZWFkZXJzWydBY2Nlc3MtQ29udHJvbC1BbGxvdy1PcmlnaW4nXSA9IGAnJHtpbml0aWFsT3JpZ2lufSdgO1xuXG4gICAgLy8gdGhlIFwiVmFyeVwiIGhlYWRlciBpcyByZXF1aXJlZCBpZiB3ZSBhbGxvdyBhIHNwZWNpZmljIG9yaWdpblxuICAgIC8vIGh0dHBzOi8vZGV2ZWxvcGVyLm1vemlsbGEub3JnL2VuLVVTL2RvY3MvV2ViL0hUVFAvSGVhZGVycy9BY2Nlc3MtQ29udHJvbC1BbGxvdy1PcmlnaW4jQ09SU19hbmRfY2FjaGluZ1xuICAgIGlmIChpbml0aWFsT3JpZ2luICE9PSAnKicpIHtcbiAgICAgIGhlYWRlcnMuVmFyeSA9ICdcXCdPcmlnaW5cXCcnO1xuICAgIH1cblxuICAgIC8vXG4gICAgLy8gQWNjZXNzLUNvbnRyb2wtQWxsb3ctTWV0aG9kc1xuXG4gICAgbGV0IGFsbG93TWV0aG9kcyA9IG9wdGlvbnMuYWxsb3dNZXRob2RzIHx8IENvcnMuQUxMX01FVEhPRFM7XG5cbiAgICBpZiAoYWxsb3dNZXRob2RzLmluY2x1ZGVzKCdBTlknKSkge1xuICAgICAgaWYgKGFsbG93TWV0aG9kcy5sZW5ndGggPiAxKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcihgQU5ZIGNhbm5vdCBiZSB1c2VkIHdpdGggYW55IG90aGVyIG1ldGhvZC4gUmVjZWl2ZWQ6ICR7YWxsb3dNZXRob2RzLmpvaW4oJywnKX1gKTtcbiAgICAgIH1cblxuICAgICAgYWxsb3dNZXRob2RzID0gQ29ycy5BTExfTUVUSE9EUztcbiAgICB9XG5cbiAgICBoZWFkZXJzWydBY2Nlc3MtQ29udHJvbC1BbGxvdy1NZXRob2RzJ10gPSBgJyR7YWxsb3dNZXRob2RzLmpvaW4oJywnKX0nYDtcblxuICAgIC8vXG4gICAgLy8gQWNjZXNzLUNvbnRyb2wtQWxsb3ctQ3JlZGVudGlhbHNcblxuICAgIGlmIChvcHRpb25zLmFsbG93Q3JlZGVudGlhbHMpIHtcbiAgICAgIGhlYWRlcnNbJ0FjY2Vzcy1Db250cm9sLUFsbG93LUNyZWRlbnRpYWxzJ10gPSAnXFwndHJ1ZVxcJyc7XG4gICAgfVxuXG4gICAgLy9cbiAgICAvLyBBY2Nlc3MtQ29udHJvbC1NYXgtQWdlXG5cbiAgICBsZXQgbWF4QWdlU2Vjb25kcztcblxuICAgIGlmIChvcHRpb25zLm1heEFnZSAmJiBvcHRpb25zLmRpc2FibGVDYWNoZSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdUaGUgb3B0aW9ucyBcIm1heEFnZVwiIGFuZCBcImRpc2FibGVDYWNoZVwiIGFyZSBtdXR1YWxseSBleGNsdXNpdmUnKTtcbiAgICB9XG5cbiAgICBpZiAob3B0aW9ucy5tYXhBZ2UpIHtcbiAgICAgIG1heEFnZVNlY29uZHMgPSBvcHRpb25zLm1heEFnZS50b1NlY29uZHMoKTtcbiAgICB9XG5cbiAgICBpZiAob3B0aW9ucy5kaXNhYmxlQ2FjaGUpIHtcbiAgICAgIG1heEFnZVNlY29uZHMgPSAtMTtcbiAgICB9XG5cbiAgICBpZiAobWF4QWdlU2Vjb25kcykge1xuICAgICAgaGVhZGVyc1snQWNjZXNzLUNvbnRyb2wtTWF4LUFnZSddID0gYCcke21heEFnZVNlY29uZHN9J2A7XG4gICAgfVxuXG4gICAgLy9cbiAgICAvLyBBY2Nlc3MtQ29udHJvbC1FeHBvc2UtSGVhZGVyc1xuICAgIC8vXG5cbiAgICBpZiAob3B0aW9ucy5leHBvc2VIZWFkZXJzKSB7XG4gICAgICBoZWFkZXJzWydBY2Nlc3MtQ29udHJvbC1FeHBvc2UtSGVhZGVycyddID0gYCcke29wdGlvbnMuZXhwb3NlSGVhZGVycy5qb2luKCcsJyl9J2A7XG4gICAgfVxuXG4gICAgLy9cbiAgICAvLyBzdGF0dXNDb2RlXG5cbiAgICBjb25zdCBzdGF0dXNDb2RlID0gb3B0aW9ucy5zdGF0dXNDb2RlID8/IDIwNDtcblxuICAgIC8vXG4gICAgLy8gcHJlcGFyZSByZXNwb25zZVBhcmFtc1xuXG4gICAgY29uc3QgaW50ZWdyYXRpb25SZXNwb25zZVBhcmFtczogeyBbcDogc3RyaW5nXTogc3RyaW5nIH0gPSB7IH07XG4gICAgY29uc3QgbWV0aG9kUmVzcG9uc2VQYXJhbXM6IHsgW3A6IHN0cmluZ106IGJvb2xlYW4gfSA9IHsgfTtcblxuICAgIGZvciAoY29uc3QgW25hbWUsIHZhbHVlXSBvZiBPYmplY3QuZW50cmllcyhoZWFkZXJzKSkge1xuICAgICAgY29uc3Qga2V5ID0gYG1ldGhvZC5yZXNwb25zZS5oZWFkZXIuJHtuYW1lfWA7XG4gICAgICBpbnRlZ3JhdGlvblJlc3BvbnNlUGFyYW1zW2tleV0gPSB2YWx1ZTtcbiAgICAgIG1ldGhvZFJlc3BvbnNlUGFyYW1zW2tleV0gPSB0cnVlO1xuICAgIH1cblxuICAgIHJldHVybiB0aGlzLmFkZE1ldGhvZCgnT1BUSU9OUycsIG5ldyBNb2NrSW50ZWdyYXRpb24oe1xuICAgICAgcmVxdWVzdFRlbXBsYXRlczogeyAnYXBwbGljYXRpb24vanNvbic6ICd7IHN0YXR1c0NvZGU6IDIwMCB9JyB9LFxuICAgICAgaW50ZWdyYXRpb25SZXNwb25zZXM6IFtcbiAgICAgICAgeyBzdGF0dXNDb2RlOiBgJHtzdGF0dXNDb2RlfWAsIHJlc3BvbnNlUGFyYW1ldGVyczogaW50ZWdyYXRpb25SZXNwb25zZVBhcmFtcywgcmVzcG9uc2VUZW1wbGF0ZXM6IHJlbmRlclJlc3BvbnNlVGVtcGxhdGUoKSB9LFxuICAgICAgXSxcbiAgICB9KSwge1xuICAgICAgbWV0aG9kUmVzcG9uc2VzOiBbXG4gICAgICAgIHsgc3RhdHVzQ29kZTogYCR7c3RhdHVzQ29kZX1gLCByZXNwb25zZVBhcmFtZXRlcnM6IG1ldGhvZFJlc3BvbnNlUGFyYW1zIH0sXG4gICAgICBdLFxuICAgIH0pO1xuXG4gICAgLy8gcmVuZGVycyB0aGUgcmVzcG9uc2UgdGVtcGxhdGUgdG8gbWF0Y2ggYWxsIHBvc3NpYmxlIG9yaWdpbnMgKGlmIHdlIGhhdmUgbW9yZSB0aGFuIG9uZSlcbiAgICBmdW5jdGlvbiByZW5kZXJSZXNwb25zZVRlbXBsYXRlKCkge1xuICAgICAgY29uc3Qgb3JpZ2lucyA9IG9wdGlvbnMuYWxsb3dPcmlnaW5zLnNsaWNlKDEpO1xuXG4gICAgICBpZiAob3JpZ2lucy5sZW5ndGggPT09IDApIHtcbiAgICAgICAgcmV0dXJuIHVuZGVmaW5lZDtcbiAgICAgIH1cblxuICAgICAgY29uc3QgdGVtcGxhdGUgPSBuZXcgQXJyYXk8c3RyaW5nPigpO1xuXG4gICAgICB0ZW1wbGF0ZS5wdXNoKCcjc2V0KCRvcmlnaW4gPSAkaW5wdXQucGFyYW1zKCkuaGVhZGVyLmdldChcIk9yaWdpblwiKSknKTtcbiAgICAgIHRlbXBsYXRlLnB1c2goJyNpZigkb3JpZ2luID09IFwiXCIpICNzZXQoJG9yaWdpbiA9ICRpbnB1dC5wYXJhbXMoKS5oZWFkZXIuZ2V0KFwib3JpZ2luXCIpKSAjZW5kJyk7XG5cbiAgICAgIGNvbnN0IGNvbmRpdGlvbiA9IG9yaWdpbnMubWFwKG8gPT4gYCRvcmlnaW4ubWF0Y2hlcyhcIiR7b31cIilgKS5qb2luKCcgfHwgJyk7XG5cbiAgICAgIHRlbXBsYXRlLnB1c2goYCNpZigke2NvbmRpdGlvbn0pYCk7XG4gICAgICB0ZW1wbGF0ZS5wdXNoKCcgICNzZXQoJGNvbnRleHQucmVzcG9uc2VPdmVycmlkZS5oZWFkZXIuQWNjZXNzLUNvbnRyb2wtQWxsb3ctT3JpZ2luID0gJG9yaWdpbiknKTtcbiAgICAgIHRlbXBsYXRlLnB1c2goJyNlbmQnKTtcblxuICAgICAgcmV0dXJuIHtcbiAgICAgICAgJ2FwcGxpY2F0aW9uL2pzb24nOiB0ZW1wbGF0ZS5qb2luKCdcXG4nKSxcbiAgICAgIH07XG4gICAgfVxuICB9XG5cbiAgcHVibGljIGdldFJlc291cmNlKHBhdGhQYXJ0OiBzdHJpbmcpOiBJUmVzb3VyY2UgfCB1bmRlZmluZWQge1xuICAgIHJldHVybiB0aGlzLmNoaWxkcmVuW3BhdGhQYXJ0XTtcbiAgfVxuXG4gIC8qKlxuICAgKiBAaW50ZXJuYWxcbiAgICovXG4gIHB1YmxpYyBfdHJhY2tDaGlsZChwYXRoUGFydDogc3RyaW5nLCByZXNvdXJjZTogUmVzb3VyY2UpIHtcbiAgICB0aGlzLmNoaWxkcmVuW3BhdGhQYXJ0XSA9IHJlc291cmNlO1xuICB9XG5cbiAgcHVibGljIHJlc291cmNlRm9yUGF0aChwYXRoOiBzdHJpbmcpOiBSZXNvdXJjZSB7XG4gICAgaWYgKCFwYXRoKSB7XG4gICAgICByZXR1cm4gdGhpcztcbiAgICB9XG5cbiAgICBpZiAocGF0aC5zdGFydHNXaXRoKCcvJykpIHtcbiAgICAgIGlmICh0aGlzLnBhdGggIT09ICcvJykge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoYFBhdGggbWF5IHN0YXJ0IHdpdGggXCIvXCIgb25seSBmb3IgdGhlIHJlc291cmNlLCBidXQgd2UgYXJlIGF0OiAke3RoaXMucGF0aH1gKTtcbiAgICAgIH1cblxuICAgICAgLy8gdHJpbSB0cmFpbGluZyBcIi9cIlxuICAgICAgcmV0dXJuIHRoaXMucmVzb3VyY2VGb3JQYXRoKHBhdGguc2xpY2UoMSkpO1xuICAgIH1cblxuICAgIGNvbnN0IHBhcnRzID0gcGF0aC5zcGxpdCgnLycpO1xuICAgIGNvbnN0IG5leHQgPSBwYXJ0cy5zaGlmdCgpO1xuICAgIGlmICghbmV4dCB8fCBuZXh0ID09PSAnJykge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdyZXNvdXJjZUZvclBhdGggY2Fubm90IGJlIGNhbGxlZCB3aXRoIGFuIGVtcHR5IHBhdGgnKTtcbiAgICB9XG5cbiAgICBsZXQgcmVzb3VyY2UgPSB0aGlzLmdldFJlc291cmNlKG5leHQpO1xuICAgIGlmICghcmVzb3VyY2UpIHtcbiAgICAgIHJlc291cmNlID0gdGhpcy5hZGRSZXNvdXJjZShuZXh0KTtcbiAgICB9XG5cbiAgICByZXR1cm4gcmVzb3VyY2UucmVzb3VyY2VGb3JQYXRoKHBhcnRzLmpvaW4oJy8nKSk7XG4gIH1cblxuICAvKipcbiAgICogQGRlcHJlY2F0ZWQgLSBUaHJvd3MgZXJyb3IgaW4gc29tZSB1c2UgY2FzZXMgdGhhdCBoYXZlIGJlZW4gZW5hYmxlZCBzaW5jZSB0aGlzIGRlcHJlY2F0aW9uIG5vdGljZS4gVXNlIGBSZXN0QXBpLnVybEZvclBhdGgoKWAgaW5zdGVhZC5cbiAgICovXG4gIHB1YmxpYyBnZXQgdXJsKCk6IHN0cmluZyB7XG4gICAgcmV0dXJuIHRoaXMucmVzdEFwaS51cmxGb3JQYXRoKHRoaXMucGF0aCk7XG4gIH1cbn1cblxuLyoqXG4gKiBBdHRyaWJ1dGVzIHRoYXQgY2FuIGJlIHNwZWNpZmllZCB3aGVuIGltcG9ydGluZyBhIFJlc291cmNlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUmVzb3VyY2VBdHRyaWJ1dGVzIHtcbiAgLyoqXG4gICAqIFRoZSBJRCBvZiB0aGUgcmVzb3VyY2UuXG4gICAqL1xuICByZWFkb25seSByZXNvdXJjZUlkOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSByZXN0IEFQSSB0aGF0IHRoaXMgcmVzb3VyY2UgaXMgcGFydCBvZi5cbiAgICovXG4gIHJlYWRvbmx5IHJlc3RBcGk6IElSZXN0QXBpO1xuXG4gIC8qKlxuICAgKiBUaGUgZnVsbCBwYXRoIG9mIHRoaXMgcmVzb3VyY2UuXG4gICAqL1xuICByZWFkb25seSBwYXRoOiBzdHJpbmc7XG59XG5cbmV4cG9ydCBjbGFzcyBSZXNvdXJjZSBleHRlbmRzIFJlc291cmNlQmFzZSB7XG4gIC8qKlxuICAgKiBJbXBvcnQgYW4gZXhpc3RpbmcgcmVzb3VyY2VcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbVJlc291cmNlQXR0cmlidXRlcyhzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBhdHRyczogUmVzb3VyY2VBdHRyaWJ1dGVzKTogSVJlc291cmNlIHtcbiAgICBjbGFzcyBJbXBvcnQgZXh0ZW5kcyBSZXNvdXJjZUJhc2Uge1xuICAgICAgcHVibGljIHJlYWRvbmx5IGFwaSA9IGF0dHJzLnJlc3RBcGk7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgcmVzb3VyY2VJZCA9IGF0dHJzLnJlc291cmNlSWQ7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgcGF0aCA9IGF0dHJzLnBhdGg7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgZGVmYXVsdEludGVncmF0aW9uPzogSW50ZWdyYXRpb24gPSB1bmRlZmluZWQ7XG4gICAgICBwdWJsaWMgcmVhZG9ubHkgZGVmYXVsdE1ldGhvZE9wdGlvbnM/OiBNZXRob2RPcHRpb25zID0gdW5kZWZpbmVkO1xuICAgICAgcHVibGljIHJlYWRvbmx5IGRlZmF1bHRDb3JzUHJlZmxpZ2h0T3B0aW9ucz86IENvcnNPcHRpb25zID0gdW5kZWZpbmVkO1xuXG4gICAgICBwdWJsaWMgZ2V0IHBhcmVudFJlc291cmNlKCk6IElSZXNvdXJjZSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcigncGFyZW50UmVzb3VyY2UgaXMgbm90IGNvbmZpZ3VyZWQgZm9yIGltcG9ydGVkIHJlc291cmNlLicpO1xuICAgICAgfVxuXG4gICAgICBwdWJsaWMgZ2V0IHJlc3RBcGkoKTogUmVzdEFwaSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcigncmVzdEFwaSBpcyBub3QgY29uZmlndXJlZCBmb3IgaW1wb3J0ZWQgcmVzb3VyY2UuJyk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyBJbXBvcnQoc2NvcGUsIGlkKTtcbiAgfVxuXG4gIHB1YmxpYyByZWFkb25seSBwYXJlbnRSZXNvdXJjZT86IElSZXNvdXJjZTtcbiAgcHVibGljIHJlYWRvbmx5IGFwaTogSVJlc3RBcGk7XG4gIHB1YmxpYyByZWFkb25seSByZXNvdXJjZUlkOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBwYXRoOiBzdHJpbmc7XG5cbiAgcHVibGljIHJlYWRvbmx5IGRlZmF1bHRJbnRlZ3JhdGlvbj86IEludGVncmF0aW9uO1xuICBwdWJsaWMgcmVhZG9ubHkgZGVmYXVsdE1ldGhvZE9wdGlvbnM/OiBNZXRob2RPcHRpb25zO1xuICBwdWJsaWMgcmVhZG9ubHkgZGVmYXVsdENvcnNQcmVmbGlnaHRPcHRpb25zPzogQ29yc09wdGlvbnM7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFJlc291cmNlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdmFsaWRhdGVSZXNvdXJjZVBhdGhQYXJ0KHByb3BzLnBhdGhQYXJ0KTtcblxuICAgIHRoaXMucGFyZW50UmVzb3VyY2UgPSBwcm9wcy5wYXJlbnQ7XG5cbiAgICBpZiAocHJvcHMucGFyZW50IGluc3RhbmNlb2YgUmVzb3VyY2VCYXNlKSB7XG4gICAgICBwcm9wcy5wYXJlbnQuX3RyYWNrQ2hpbGQocHJvcHMucGF0aFBhcnQsIHRoaXMpO1xuICAgIH1cblxuICAgIGNvbnN0IHJlc291cmNlUHJvcHM6IENmblJlc291cmNlUHJvcHMgPSB7XG4gICAgICByZXN0QXBpSWQ6IHByb3BzLnBhcmVudC5hcGkucmVzdEFwaUlkLFxuICAgICAgcGFyZW50SWQ6IHByb3BzLnBhcmVudC5yZXNvdXJjZUlkLFxuICAgICAgcGF0aFBhcnQ6IHByb3BzLnBhdGhQYXJ0LFxuICAgIH07XG4gICAgY29uc3QgcmVzb3VyY2UgPSBuZXcgQ2ZuUmVzb3VyY2UodGhpcywgJ1Jlc291cmNlJywgcmVzb3VyY2VQcm9wcyk7XG5cbiAgICB0aGlzLnJlc291cmNlSWQgPSByZXNvdXJjZS5yZWY7XG4gICAgdGhpcy5hcGkgPSBwcm9wcy5wYXJlbnQuYXBpO1xuXG4gICAgLy8gcmVuZGVyIHJlc291cmNlIHBhdGggKHNwZWNpYWwgY2FzZSBmb3Igcm9vdClcbiAgICB0aGlzLnBhdGggPSBwcm9wcy5wYXJlbnQucGF0aDtcbiAgICBpZiAoIXRoaXMucGF0aC5lbmRzV2l0aCgnLycpKSB7IHRoaXMucGF0aCArPSAnLyc7IH1cbiAgICB0aGlzLnBhdGggKz0gcHJvcHMucGF0aFBhcnQ7XG5cbiAgICBjb25zdCBkZXBsb3ltZW50ID0gcHJvcHMucGFyZW50LmFwaS5sYXRlc3REZXBsb3ltZW50O1xuICAgIGlmIChkZXBsb3ltZW50KSB7XG4gICAgICBkZXBsb3ltZW50Lm5vZGUuYWRkRGVwZW5kZW5jeShyZXNvdXJjZSk7XG4gICAgICBkZXBsb3ltZW50LmFkZFRvTG9naWNhbElkKHsgcmVzb3VyY2U6IHJlc291cmNlUHJvcHMgfSk7XG4gICAgfVxuXG4gICAgLy8gc2V0dXAgZGVmYXVsdHMgYmFzZWQgb24gcHJvcGVydGllcyBhbmQgaW5oZXJpdCBmcm9tIHBhcmVudC4gbWV0aG9kIGRlZmF1bHRzXG4gICAgLy8gYXJlIGluaGVyaXRlZCBwZXIgcHJvcGVydHksIHNvIGNoaWxkcmVuIGNhbiBvdmVycmlkZSBwaWVjZW1lYWwuXG4gICAgdGhpcy5kZWZhdWx0SW50ZWdyYXRpb24gPSBwcm9wcy5kZWZhdWx0SW50ZWdyYXRpb24gfHwgcHJvcHMucGFyZW50LmRlZmF1bHRJbnRlZ3JhdGlvbjtcbiAgICB0aGlzLmRlZmF1bHRNZXRob2RPcHRpb25zID0ge1xuICAgICAgLi4ucHJvcHMucGFyZW50LmRlZmF1bHRNZXRob2RPcHRpb25zLFxuICAgICAgLi4ucHJvcHMuZGVmYXVsdE1ldGhvZE9wdGlvbnMsXG4gICAgfTtcbiAgICB0aGlzLmRlZmF1bHRDb3JzUHJlZmxpZ2h0T3B0aW9ucyA9IHByb3BzLmRlZmF1bHRDb3JzUHJlZmxpZ2h0T3B0aW9ucyB8fCBwcm9wcy5wYXJlbnQuZGVmYXVsdENvcnNQcmVmbGlnaHRPcHRpb25zO1xuXG4gICAgaWYgKHRoaXMuZGVmYXVsdENvcnNQcmVmbGlnaHRPcHRpb25zKSB7XG4gICAgICB0aGlzLmFkZENvcnNQcmVmbGlnaHQodGhpcy5kZWZhdWx0Q29yc1ByZWZsaWdodE9wdGlvbnMpO1xuICAgIH1cbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgUmVzdEFwaSBhc3NvY2lhdGVkIHdpdGggdGhpcyBSZXNvdXJjZVxuICAgKiBAZGVwcmVjYXRlZCAtIFRocm93cyBhbiBlcnJvciBpZiB0aGlzIFJlc291cmNlIGlzIG5vdCBhc3NvY2lhdGVkIHdpdGggYW4gaW5zdGFuY2Ugb2YgYFJlc3RBcGlgLiBVc2UgYGFwaWAgaW5zdGVhZC5cbiAgICovXG4gIHB1YmxpYyBnZXQgcmVzdEFwaSgpOiBSZXN0QXBpIHtcbiAgICBpZiAoIXRoaXMucGFyZW50UmVzb3VyY2UpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcigncGFyZW50UmVzb3VyY2Ugd2FzIHVuZXhwZWN0ZWRseSBub3QgZGVmaW5lZCcpO1xuICAgIH1cbiAgICByZXR1cm4gdGhpcy5wYXJlbnRSZXNvdXJjZS5yZXN0QXBpO1xuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUHJveHlSZXNvdXJjZU9wdGlvbnMgZXh0ZW5kcyBSZXNvdXJjZU9wdGlvbnMge1xuICAvKipcbiAgICogQWRkcyBhbiBcIkFOWVwiIG1ldGhvZCB0byB0aGlzIHJlc291cmNlLiBJZiBzZXQgdG8gYGZhbHNlYCwgeW91IHdpbGwgaGF2ZSB0byBleHBsaWNpdGx5XG4gICAqIGFkZCBtZXRob2RzIHRvIHRoaXMgcmVzb3VyY2UgYWZ0ZXIgaXQncyBjcmVhdGVkLlxuICAgKlxuICAgKiBAZGVmYXVsdCB0cnVlXG4gICAqL1xuICByZWFkb25seSBhbnlNZXRob2Q/OiBib29sZWFuO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIFByb3h5UmVzb3VyY2VQcm9wcyBleHRlbmRzIFByb3h5UmVzb3VyY2VPcHRpb25zIHtcbiAgLyoqXG4gICAqIFRoZSBwYXJlbnQgcmVzb3VyY2Ugb2YgdGhpcyByZXNvdXJjZS4gWW91IGNhbiBlaXRoZXIgcGFzcyBhbm90aGVyXG4gICAqIGBSZXNvdXJjZWAgb2JqZWN0IG9yIGEgYFJlc3RBcGlgIG9iamVjdCBoZXJlLlxuICAgKi9cbiAgcmVhZG9ubHkgcGFyZW50OiBJUmVzb3VyY2U7XG59XG5cbi8qKlxuICogRGVmaW5lcyBhIHtwcm94eSt9IGdyZWVkeSByZXNvdXJjZSBhbmQgYW4gQU5ZIG1ldGhvZCBvbiBhIHJvdXRlLlxuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vYXBpZ2F0ZXdheS9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvYXBpLWdhdGV3YXktc2V0LXVwLXNpbXBsZS1wcm94eS5odG1sXG4gKi9cbmV4cG9ydCBjbGFzcyBQcm94eVJlc291cmNlIGV4dGVuZHMgUmVzb3VyY2Uge1xuICAvKipcbiAgICogSWYgYHByb3BzLmFueU1ldGhvZGAgaXMgYHRydWVgLCB0aGlzIHdpbGwgYmUgdGhlIHJlZmVyZW5jZSB0byB0aGUgJ0FOWSdcbiAgICogbWV0aG9kIGFzc29jaWF0ZWQgd2l0aCB0aGlzIHByb3h5IHJlc291cmNlLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGFueU1ldGhvZD86IE1ldGhvZDtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUHJveHlSZXNvdXJjZVByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICBwYXJlbnQ6IHByb3BzLnBhcmVudCxcbiAgICAgIHBhdGhQYXJ0OiAne3Byb3h5K30nLFxuICAgICAgZGVmYXVsdEludGVncmF0aW9uOiBwcm9wcy5kZWZhdWx0SW50ZWdyYXRpb24sXG4gICAgICBkZWZhdWx0TWV0aG9kT3B0aW9uczogcHJvcHMuZGVmYXVsdE1ldGhvZE9wdGlvbnMsXG4gICAgfSk7XG5cbiAgICBjb25zdCBhbnlNZXRob2QgPSBwcm9wcy5hbnlNZXRob2QgPz8gdHJ1ZTtcbiAgICBpZiAoYW55TWV0aG9kKSB7XG4gICAgICB0aGlzLmFueU1ldGhvZCA9IHRoaXMuYWRkTWV0aG9kKCdBTlknKTtcbiAgICB9XG4gIH1cblxuICBwdWJsaWMgYWRkTWV0aG9kKGh0dHBNZXRob2Q6IHN0cmluZywgaW50ZWdyYXRpb24/OiBJbnRlZ3JhdGlvbiwgb3B0aW9ucz86IE1ldGhvZE9wdGlvbnMpOiBNZXRob2Qge1xuICAgIC8vIEluIGNhc2UgdGhpcyBwcm94eSBpcyBtb3VudGVkIHVuZGVyIHRoZSByb290LCBhbHNvIGFkZCB0aGlzIG1ldGhvZCB0b1xuICAgIC8vIHRoZSByb290IHNvIHRoYXQgZW1wdHkgcGF0aHMgYXJlIHByb3hpZWQgYXMgd2VsbC5cbiAgICBpZiAodGhpcy5wYXJlbnRSZXNvdXJjZSAmJiB0aGlzLnBhcmVudFJlc291cmNlLnBhdGggPT09ICcvJykge1xuICAgICAgLy8gc2tpcCBpZiB0aGUgcm9vdCByZXNvdXJjZSBhbHJlYWR5IGhhcyB0aGlzIG1ldGhvZCBkZWZpbmVkXG4gICAgICBpZiAoISh0aGlzLnBhcmVudFJlc291cmNlLm5vZGUudHJ5RmluZENoaWxkKGh0dHBNZXRob2QpIGluc3RhbmNlb2YgTWV0aG9kKSkge1xuICAgICAgICB0aGlzLnBhcmVudFJlc291cmNlLmFkZE1ldGhvZChodHRwTWV0aG9kLCBpbnRlZ3JhdGlvbiwgb3B0aW9ucyk7XG4gICAgICB9XG4gICAgfVxuICAgIHJldHVybiBzdXBlci5hZGRNZXRob2QoaHR0cE1ldGhvZCwgaW50ZWdyYXRpb24sIG9wdGlvbnMpO1xuICB9XG59XG5cbmZ1bmN0aW9uIHZhbGlkYXRlUmVzb3VyY2VQYXRoUGFydChwYXJ0OiBzdHJpbmcpIHtcbiAgLy8gc3RyaXAge30gd2hpY2ggaW5kaWNhdGUgdGhpcyBpcyBhIHBhcmFtZXRlclxuICBpZiAocGFydC5zdGFydHNXaXRoKCd7JykgJiYgcGFydC5lbmRzV2l0aCgnfScpKSB7XG4gICAgcGFydCA9IHBhcnQuc2xpY2UoMSwgLTEpO1xuXG4gICAgLy8gcHJveHkgcmVzb3VyY2VzIGFyZSBhbGxvd2VkIHRvIGVuZCB3aXRoIGEgJysnXG4gICAgaWYgKHBhcnQuZW5kc1dpdGgoJysnKSkge1xuICAgICAgcGFydCA9IHBhcnQuc2xpY2UoMCwgLTEpO1xuICAgIH1cbiAgfVxuXG4gIGlmICghL15bYS16QS1aMC05XFwuXFxfXFwtXSskLy50ZXN0KHBhcnQpKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKGBSZXNvdXJjZSdzIHBhdGggcGFydCBvbmx5IGFsbG93IFthLXpBLVowLTkuXy1dLCBhbiBvcHRpb25hbCB0cmFpbGluZyAnKydcbiAgICAgIGFuZCBjdXJseSBicmFjZXMgYXQgdGhlIGJlZ2lubmluZyBhbmQgdGhlIGVuZDogJHtwYXJ0fWApO1xuICB9XG59XG4iXX0=